/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.monitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.DatabricksDeploymentInfo;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetricsFetchingService;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.deployer.apideployer.monitoring.DeploymentAndEndpointIdAndName;
import com.dataiku.dip.deployer.apideployer.monitoring.GetEndpointMonitoringMetrics;
import com.dataiku.dip.deployer.apideployer.monitoring.ScopeAndEndpoint;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksHTTPClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class DatabricksActivityMetricsFetchingService
extends ActivityMetricsFetchingService {
    private static final int SECONDS_IN_MINUTE = 60;
    public static final String DATABRICKS_ACTIVITY_METRICS_FETCHING_SERVICE_THREAD_COUNT = "dku.databricksActivityMetricsFetchingService.threadCount";
    public static final String DATABRICKS_ACTIVITY_METRICS_FETCHING_SERVICE_SCOPE_TIMEOUT_SECONDS = "dku.databricksActivityMetricsFetchingService.scopeTimeoutSeconds";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.monitoring.databricksActivityMetricsFetchingService");

    public DatabricksActivityMetricsFetchingService(TransactionService transactionService, UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO, APIServiceDeploymentsService apiServiceDeploymentsService) {
        super(transactionService, unifiedMonitoringSettingsDAO, apiServiceDeploymentsService);
    }

    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getInfraActivityMetrics_NT(AuthCtx authCtx, DatabricksAPIDeploymentInfra infra, String overridingConnectionName, int connectTimeout, int socketTimeout) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        String usedConnection = overridingConnectionName != null ? overridingConnectionName : infra.authConnection;
        String displayedUsedConnection = overridingConnectionName != null ? overridingConnectionName : infra.getDisplayedConnectionName();
        logger.infoV("Getting activity metrics from Databricks for infrastructure %s using connection %s", new Object[]{infra.id, displayedUsedConnection});
        try {
            List<ActivityMetricsFetchingService.DeploymentAndEndpoint<DatabricksDeploymentInfo>> deployments = this.getDeploymentAndEndpoints(infra.id, authCtx);
            logger.infoV("Will fetch activity metrics from Databricks for at least %d dss endpoints for infrastructure %s using connection %s", new Object[]{deployments.size(), infra.id, displayedUsedConnection});
            DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, usedConnection);
            if (connection == null) {
                logger.errorV("Failed to fetch activity metrics from Databricks for infrastructure %s using connection %s because connection is empty or not found", new Object[]{infra.id, displayedUsedConnection});
                return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
            }
            DatabricksHTTPClient client = connection.getClient(authCtx, connectTimeout, socketTimeout);
            return this.getDeploymentEndpointsActivityMetricsFromCloudMonitoring(client, deployments);
        }
        catch (DKUSecurityException | IOException e) {
            logger.errorV(e, "Failed to fetch activity metrics from Databricks for infrastructure %s using connection %s", new Object[]{infra.id, displayedUsedConnection});
            return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
        }
    }

    public ActivityMetric.TimeAndMetricsByEndpoint getScopeActivityMetrics_NT(AuthCtx authCtx, UnifiedMonitoringExternalEndpointsScope.Databricks externalEndpointsScope, int connectTimeout, int socketTimeout) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.infoV("Getting activity metrics from Databricks for scope %s using connection %s", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
        try {
            List<MonitoredExternalApiEndpoint> endpoints = externalEndpointsScope.listEndpoints(authCtx);
            logger.infoV("Will fetch activity metrics for %d external endpoints for scope %s using connection %s", new Object[]{endpoints.size(), externalEndpointsScope.name, externalEndpointsScope.connectionName});
            DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, externalEndpointsScope.connectionName);
            if (connection == null) {
                logger.errorV("Failed to fetch activity metrics from Databricks for scope %s using connection %s because connection is empty or not found", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
                return new ActivityMetric.TimeAndMetricsByEndpoint.None();
            }
            DatabricksHTTPClient client = connection.getClient(authCtx, connectTimeout, socketTimeout);
            return this.getExternalEndpointsActivityMetricsFromCloudMonitoring(client, endpoints);
        }
        catch (DKUSecurityException | IOException e) {
            logger.errorV(e, "Failed to fetch activity metrics from Databricks for scope %s using connection %s", new Object[]{externalEndpointsScope.name, externalEndpointsScope.connectionName});
            return new ActivityMetric.TimeAndMetricsByEndpoint.None();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityMetric.TimeAndMetricsByEndpoint getExternalEndpointsActivityMetricsFromCloudMonitoring(DatabricksHTTPClient client, List<MonitoredExternalApiEndpoint> endpoints) throws InterruptedException {
        ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint = new ActivityMetric.TimeAndMetricsByEndpoint();
        ExecutorService es = Executors.newFixedThreadPool(DKUApp.getParams().getIntParam(DATABRICKS_ACTIVITY_METRICS_FETCHING_SERVICE_THREAD_COUNT, Integer.valueOf(5)), new ThreadFactoryBuilder().setNameFormat("getExternalEndpointsActivityMetricsFromCloudMonitoring-%d").build());
        try {
            ActivityMetric.TimeAndMetricsByEndpoint withTotalMetrics;
            List futures;
            ArrayList<GetEndpointMonitoringMetrics<ScopeAndEndpoint>> tasks = new ArrayList<GetEndpointMonitoringMetrics<ScopeAndEndpoint>>(endpoints.size());
            for (MonitoredExternalApiEndpoint endpoint : endpoints) {
                ScopeAndEndpoint scopeAndEndpoint = new ScopeAndEndpoint(endpoint.externalEndpointsScope.name, endpoint.endpointName);
                tasks.add(new GetEndpointMonitoringMetrics<ScopeAndEndpoint>(client, scopeAndEndpoint));
            }
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                futures = es.invokeAll(tasks, DKUApp.getParams().getIntParam(DATABRICKS_ACTIVITY_METRICS_FETCHING_SERVICE_SCOPE_TIMEOUT_SECONDS, Integer.valueOf(120)), TimeUnit.SECONDS);
                logger.debugV("Retrieved metrics from %d databricks endpoints in %d milliseconds", new Object[]{endpoints.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                logger.errorV((Throwable)ie, "Collection of metrics of endpoints of a Databricks scope was interrupted", new Object[0]);
                throw ie;
            }
            for (Future future : futures) {
                try {
                    ScopeAndEndpoint scopeAndEndpoint = (ScopeAndEndpoint)((Pair)future.get()).first;
                    ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime = (ActivityMetric.TimeAndMetricsByTime)((Pair)future.get()).second;
                    ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsByEndpoint.computeIfAbsent(scopeAndEndpoint.endpointName, ActivityMetric.TimeAndMetricsForEndpoint::new);
                    timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime = timeAndMetricsOrderedByTime;
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    logger.warn((Object)"At least one future did not complete while retrieving metrics of databricks endpoints", (Throwable)e);
                }
            }
            ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint2 = withTotalMetrics = ApiEndpointActivityMonitoringService.mapAverageToTotal(timeAndMetricsByEndpoint);
            return timeAndMetricsByEndpoint2;
        }
        finally {
            es.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getDeploymentEndpointsActivityMetricsFromCloudMonitoring(DatabricksHTTPClient client, List<ActivityMetricsFetchingService.DeploymentAndEndpoint<DatabricksDeploymentInfo>> deploymentAndEndpoints) throws InterruptedException {
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint = new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint();
        ExecutorService es = Executors.newFixedThreadPool(DKUApp.getParams().getIntParam(DATABRICKS_ACTIVITY_METRICS_FETCHING_SERVICE_THREAD_COUNT, Integer.valueOf(5)), new ThreadFactoryBuilder().setNameFormat("getDeploymentEndpointsActivityMetricsFromCloudMonitoring-%d").build());
        try {
            ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint withTotalMetrics;
            List futures;
            ArrayList<GetEndpointMonitoringMetrics<DeploymentAndEndpointIdAndName>> tasks = new ArrayList<GetEndpointMonitoringMetrics<DeploymentAndEndpointIdAndName>>(deploymentAndEndpoints.size());
            for (ActivityMetricsFetchingService.DeploymentAndEndpoint<DatabricksDeploymentInfo> endpoint : deploymentAndEndpoints) {
                String endpointName = ((DatabricksDeploymentInfo)endpoint.deploymentInfo).dbxEndpointName;
                if (endpointName == null) continue;
                DeploymentAndEndpointIdAndName endpointIdAndName = new DeploymentAndEndpointIdAndName(endpoint.deploymentId, endpoint.endpointId, endpointName);
                tasks.add(new GetEndpointMonitoringMetrics<DeploymentAndEndpointIdAndName>(client, endpointIdAndName));
            }
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                futures = es.invokeAll(tasks, DKUApp.getParams().getIntParam(DATABRICKS_ACTIVITY_METRICS_FETCHING_SERVICE_SCOPE_TIMEOUT_SECONDS, Integer.valueOf(120)), TimeUnit.SECONDS);
                logger.debugV("Retrieved metrics from %d databricks endpoints in %d milliseconds", new Object[]{futures.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                logger.errorV((Throwable)ie, "Collection of metrics of endpoints of a Databricks infrastructure was interrupted", new Object[0]);
                throw ie;
            }
            for (Future future : futures) {
                try {
                    DeploymentAndEndpointIdAndName deploymentAndEndpoint = (DeploymentAndEndpointIdAndName)((Pair)future.get()).first;
                    ActivityMetric.TimeAndMetricsByTime timeAndMetricsOrderedByTime = (ActivityMetric.TimeAndMetricsByTime)((Pair)future.get()).second;
                    ActivityMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = timeAndMetricsByDeploymentAndEndpoint.computeIfAbsent(deploymentAndEndpoint.dssDeploymentId, ActivityMetric.TimeAndMetricsForDeployment::new);
                    ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsForDeployment.timeAndMetricsForEndpoint.computeIfAbsent(deploymentAndEndpoint.dssEndpointId, ActivityMetric.TimeAndMetricsForEndpoint::new);
                    timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime = timeAndMetricsOrderedByTime;
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    logger.warn((Object)"At least one future did not complete while retrieving metrics of databricks endpoints", (Throwable)e);
                }
            }
            ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint2 = withTotalMetrics = ApiEndpointActivityMonitoringService.mapAverageToTotal(timeAndMetricsByDeploymentAndEndpoint);
            return timeAndMetricsByDeploymentAndEndpoint2;
        }
        finally {
            es.shutdownNow();
        }
    }

    public static enum DatabricksMetricTypeMap {
        request_4xx_count_total(null, 60),
        request_count_total(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S, 60),
        request_5xx_count_total(ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S, 60),
        cpu_usage_percentage(null, null),
        mem_usage_percentage(null, null),
        request_latency_ms_sum(null, null),
        request_latency_ms_count(null, null),
        request_latency_ms_bucket(null, null),
        provisioned_concurrent_requests_total(null, null);

        public final ActivityMetric.Type metricType;
        private final Integer aggregationPeriodInSeconds;

        private DatabricksMetricTypeMap(ActivityMetric.Type metricType, Integer aggregationPeriodInSeconds) {
            this.metricType = metricType;
            this.aggregationPeriodInSeconds = aggregationPeriodInSeconds;
        }

        public double convertValueToDSSMetrics(double value) {
            if (this.aggregationPeriodInSeconds == null) {
                return value;
            }
            return value / (double)this.aggregationPeriodInSeconds.intValue();
        }
    }
}

