/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfBoxPdfDocumentScreenshotsDrawer
implements IDocumentScreenshotsDrawer {
    private static final String SCREENSHOT_CONVERSION_PDFBOX = "screenshot-conversion-pdfbox";
    PDFRenderer pdfRenderer;
    private final int pageNumber;
    PDDocument document;

    public PdfBoxPdfDocumentScreenshotsDrawer(InputStream inputStream) {
        try {
            MemoryUsageSetting memoryUsageSetting = MemoryUsageSetting.setupMixed((long)(IDocumentScreenshotsDrawer.MEMORY_LIMIT_PER_DOCUMENT * 1000 * 1000));
            memoryUsageSetting.setTempDir(DSSTempUtils.getTempFolderWithSpecificName((String)"docextraction", (String)SCREENSHOT_CONVERSION_PDFBOX));
            this.document = PDDocument.load((InputStream)inputStream, (MemoryUsageSetting)memoryUsageSetting);
            this.pdfRenderer = new PDFRenderer(this.document);
            this.pageNumber = this.document.getNumberOfPages();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getPageCount() {
        return this.pageNumber;
    }

    @Override
    public BufferedImage drawImage(int index) throws IOException {
        PDRectangle cropBox = this.document.getPage(index).getCropBox();
        double scaleForCurrentImage = IDocumentScreenshotsDrawer.getMaximumScalePriorImageDrawing(cropBox.getWidth(), cropBox.getHeight());
        return this.pdfRenderer.renderImage(index, (float)scaleForCurrentImage);
    }

    @Override
    public void close() throws IOException {
        this.document.close();
    }
}

