/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen;

import com.dataiku.dip.analysis.docgen.DocumentGenerationThread;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.docgen.handler.DocxTreeExtractorHandler;
import com.dataiku.dip.docgen.handler.DocxTreeRenderHandler;
import com.dataiku.dip.docgen.handler.PythonPlaceholderExtractionCommand;
import com.dataiku.dip.docgen.handler.PythonRenderingCommand;
import com.dataiku.dip.docgen.resolver.ExportOutputExecutor;
import com.dataiku.dip.docgen.resolver.PlaceholderResolver;
import com.dataiku.dip.docgen.resolver.PlaceholderStore;
import com.dataiku.dip.docgen.resolver.ResolvedResult;
import com.dataiku.dip.docgen.resolver.UnresolvedPlaceholder;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.security.DSSAuthCtx;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public abstract class GenericDocumentGenerationThread<DocGenContext>
extends DocumentGenerationThread {
    public GenericDocumentGenerationThread(DSSAuthCtx user, String projectKey, InputStream templateInputStream, String rootUrl, FuturePayload futurePayload) {
        super(user, projectKey, templateInputStream, rootUrl, futurePayload);
    }

    public abstract DocGenContext getDocumentGenerationContext();

    public abstract PlaceholderStore<DocGenContext> getPlaceholderStore();

    public abstract String getOutputFileName();

    public void onPost() throws Exception {
    }

    protected UnresolvedPlaceholder.AsImportedFromPython extractPlaceholders() throws Exception {
        FutureProgress.pushState((String)"Parsing template for placeholders");
        PythonPlaceholderExtractionCommand command = new PythonPlaceholderExtractionCommand("extract placeholders", this.templateFile.getAbsolutePath());
        DocxTreeExtractorHandler extractHandler = new DocxTreeExtractorHandler(this.owner, this.projectKey, command, this.apiTicketService);
        UnresolvedPlaceholder.AsImportedFromPython res = this.executePython(extractHandler);
        FutureProgress.popState();
        this.percentageProgressState.increment(1.0);
        return res;
    }

    protected File resolvePlaceholders(List<UnresolvedPlaceholder> placeholders) throws Exception {
        ExportOutputExecutor exportOutputExecutor = new ExportOutputExecutor(this.owner, this.documentGenerationResponse.data);
        PlaceholderResolver<DocGenContext> resolver = new PlaceholderResolver<DocGenContext>(this.getDocumentGenerationContext(), this.getPlaceholderStore(), this.documentGenerationResponse.data, exportOutputExecutor);
        FutureProgress.pushState((String)"Resolving placeholders found in template");
        List<ResolvedResult> resolvedResult = resolver.resolve(placeholders);
        FutureProgress.popState();
        this.percentageProgressState.increment(1.0);
        exportOutputExecutor.executeExports();
        this.percentageProgressState.increment(1.0);
        return MDGFileUtil.writeOnTemporaryFile(resolvedResult, this.templateUploadId);
    }

    protected void render(File resolvedResultFile) throws Exception {
        String outputFilename = this.getOutputFileName();
        String absoluteOutputFilepath = new File(MDGFileUtil.getTmpExportDirectory(this.templateUploadId), outputFilename).toString();
        PythonRenderingCommand command = new PythonRenderingCommand("export", this.templateFile.getAbsolutePath(), resolvedResultFile.getAbsolutePath(), absoluteOutputFilepath, this.projectKey);
        DocxTreeRenderHandler renderHandler = new DocxTreeRenderHandler(this.owner, this.projectKey, command, this.apiTicketService);
        FutureProgress.pushState((String)"Rendering output document");
        this.executePython(renderHandler);
        FutureProgress.popState();
        this.percentageProgressState.increment(1.0);
    }

    @Override
    protected void renderOutputDocument() throws Exception {
        this.percentageProgressState.setTarget(3L);
        UnresolvedPlaceholder.AsImportedFromPython placeholders = this.extractPlaceholders();
        File resolvedResultFile = this.resolvePlaceholders(placeholders.placeholders);
        this.render(resolvedResultFile);
        this.onPost();
    }
}

