/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.apache.commons.lang3.StringUtils;

public class ExportParams {
    public transient AuthCtx user;
    public String contextProjectKey;
    public ExportDestinationType destinationType = ExportDestinationType.DOWNLOAD;
    public TemporaryFileBehavior temporaryFileBehavior = TemporaryFileBehavior.AUTO;
    public String filenameBase;
    public String originatingOptionId;
    public SerializedFormat format;
    public String destinationDatasetProjectKey;
    public String destinationDatasetName;
    public String destinationDatasetConnection;
    public boolean overwriteDestinationDataset;
    public String exporterType;
    public JsonObject config;
    public boolean applyExplorationFilters;
    public ExplorationFiltersAndSearchQuery explorationFiltersAndSearchQuery = null;
    public boolean applyColoring;
    public StreamableDatasetSelection selection = new StreamableDatasetSelection();

    public ExportParams() {
        this.format = new SerializedFormat();
        this.format.type = "csv";
        CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
        this.format.params = (JsonObject)JSON.parse((String)JSON.json((Object)config), JsonObject.class);
        this.selection = StreamableDatasetSelection.full();
    }

    public static enum ExportDestinationType {
        DOWNLOAD,
        DATASET,
        CUSTOM_MANAGED;

    }

    public static enum TemporaryFileBehavior {
        AUTO,
        YES,
        NO;

    }

    public static class ExplorationFiltersAndSearchQuery {
        public String globalSearchQuery = "";
        public JsonArray explorationFilters = new JsonArray();

        public boolean isActive() {
            return this.explorationFilters != null || StringUtils.isNotBlank((CharSequence)this.globalSearchQuery);
        }
    }

    public static class SerializedFormat {
        public String type;
        public JsonObject params;
    }
}

