/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.time.LocalDate;
import org.apache.parquet.io.api.PrimitiveConverter;

public class HiveDateOnlyConverter
extends PrimitiveConverter {
    private final ParentValueContainer parent;
    private static final DateTimeFormatter isoFormatter = ISODateTimeFormat.date().withZone(DateTimeZone.UTC);

    public HiveDateOnlyConverter(ParentValueContainer parent) {
        this.parent = parent;
    }

    public void addInt(int value) {
        LocalDate date = LocalDate.ofEpochDay(value);
        this.parent.addString(isoFormatter.print((ReadableInstant)new DateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, DateTimeZone.UTC)));
    }
}

