/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.vertex.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.vertex.api.GeminiQuery;
import com.dataiku.dip.llm.utils.json_schema.JSONSchemaCompatibilityEnhancer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class GeminiQueryAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.vertex.client");

    private GeminiQueryAdapter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeminiQuery adapt(String model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) {
        GeminiQuery geminiQuery = new GeminiQuery();
        if (ccs.maxTokens != null) {
            geminiQuery.generationConfig.maxOutputTokens = ccs.maxTokens;
        }
        if (ccs.temperature != null) {
            geminiQuery.generationConfig.temperature = ccs.temperature;
        }
        if (ccs.topK != null) {
            geminiQuery.generationConfig.topK = ccs.topK;
        }
        if (ccs.topP != null) {
            geminiQuery.generationConfig.topP = ccs.topP;
        }
        if (ccs.frequencyPenalty != null) {
            geminiQuery.generationConfig.frequencyPenalty = ccs.frequencyPenalty;
        }
        if (ccs.presencePenalty != null) {
            geminiQuery.generationConfig.presencePenalty = ccs.presencePenalty;
        }
        if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
            geminiQuery.generationConfig.stopSequences = new ArrayList<String>(ccs.stopSequences);
        }
        if (ccs.responseFormat instanceof LLMClient.ResponseFormatJson) {
            LLMClient.ResponseFormatJson responseFormat = (LLMClient.ResponseFormatJson)ccs.responseFormat;
            geminiQuery.generationConfig.responseMimeType = "application/json";
            if (responseFormat.schema != null) {
                boolean compatible = responseFormat.compatible == null || responseFormat.compatible != false;
                geminiQuery.generationConfig.responseSchema = JSONSchemaCompatibilityEnhancer.enhance(responseFormat.schema, compatible ? JSONSchemaCompatibilityEnhancer.Provider.GEMINI : JSONSchemaCompatibilityEnhancer.Provider.PASSTHROUGH);
            }
        }
        if (ccs.toolChoice != null) {
            geminiQuery.toolConfig = GeminiQueryAdapter.adapt(ccs.toolChoice);
        }
        if (ccs.tools != null && !ccs.tools.isEmpty()) {
            GeminiQuery.FunctionTool ft = new GeminiQuery.FunctionTool();
            ft.functionDeclarations = ccs.tools.stream().map(GeminiQueryAdapter::adapt).collect(Collectors.toList());
            geminiQuery.tools.add(ft);
        }
        if (ccs.reasoningEffort != null) {
            geminiQuery.generationConfig.thinkingConfig = new GeminiQuery.ThinkingConfig();
            if (ccs.reasoningEffort == LLMClient.ReasoningEffort.OFF) {
                geminiQuery.generationConfig.thinkingConfig.thinkingBudget = 0;
                geminiQuery.generationConfig.thinkingConfig.includeThoughts = false;
            } else if (ccs.reasoningEffort == LLMClient.ReasoningEffort.STANDARD) {
                geminiQuery.generationConfig.thinkingConfig.thinkingBudget = -1;
                geminiQuery.generationConfig.thinkingConfig.includeThoughts = true;
            } else {
                if (ccs.reasoningEffort != LLMClient.ReasoningEffort.CUSTOM) throw new IllegalArgumentException(String.format("Unsupported Reasoning Effort for Vertex: expected OFF, STANDARD or CUSTOM but received %s.", new Object[]{ccs.reasoningEffort}));
                if (StringUtils.isEmpty((String)ccs.customReasoningEffort)) {
                    throw new IllegalArgumentException(String.format("Custom reasoning effort cannot be null or empty: %s ", ccs.customReasoningEffort));
                }
                try {
                    int budget = Integer.parseInt(ccs.customReasoningEffort);
                    geminiQuery.generationConfig.thinkingConfig.thinkingBudget = budget;
                    geminiQuery.generationConfig.thinkingConfig.includeThoughts = budget != 0;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Invalid 'customReasoningEffort' for Vertex: Expected an integer (number of tokens for reasoning), but received '%s'. ", ccs.customReasoningEffort));
                }
            }
        } else if (ccs.includeReasoning != null && ccs.includeReasoning.booleanValue() && !model.equals("gemini-2.5-flash-lite")) {
            geminiQuery.generationConfig.thinkingConfig = new GeminiQuery.ThinkingConfig();
            geminiQuery.generationConfig.thinkingConfig.includeThoughts = true;
        }
        GeminiQueryAdapter.adaptMessages(messages, geminiQuery);
        return geminiQuery;
    }

    private static void adaptMessages(List<LLMClient.ChatMessage> messages, GeminiQuery geminiQuery) {
        String thoughtSignature = null;
        block16: for (LLMClient.ChatMessage chatMessage : messages) {
            switch (chatMessage.role) {
                case "system": {
                    if (geminiQuery.systemInstruction != null) {
                        logger.warn((Object)("Multiple system prompts are not supported for Gemini models, using only the last one: " + JSON.prettyLog(messages)));
                    }
                    geminiQuery.systemInstruction = GeminiQueryAdapter.adaptSystemMessage(chatMessage);
                    continue block16;
                }
                case "user": {
                    GeminiQuery.Message message = GeminiQueryAdapter.adaptMessage(chatMessage, null);
                    message.role = "user";
                    geminiQuery.contents.add(message);
                    continue block16;
                }
                case "assistant": {
                    GeminiQuery.Message message = GeminiQueryAdapter.adaptMessage(chatMessage, thoughtSignature);
                    message.role = "model";
                    geminiQuery.contents.add(message);
                    thoughtSignature = null;
                    continue block16;
                }
                case "tool": {
                    geminiQuery.contents.add(GeminiQueryAdapter.adaptToolMessage(chatMessage));
                    continue block16;
                }
                case "memoryFragment": {
                    if (chatMessage.memoryFragment == null || chatMessage.memoryFragment.llmReasoning == null) {
                        throw new IllegalArgumentException("Invalid thinking message format : the thinking message is null.");
                    }
                    try {
                        thoughtSignature = chatMessage.memoryFragment.llmReasoning.get("thoughtSignature").getAsString();
                        continue block16;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Invalid thinking message format, thought signature is not present or not a string %s", chatMessage.memoryFragment.llmReasoning));
                    }
                }
            }
            throw new IllegalArgumentException("Unknown message role for Gemini model: " + chatMessage.role);
        }
    }

    private static GeminiQuery.FunctionDeclaration adapt(LLMClient.AbstractTool tool) {
        if (tool instanceof LLMClient.FunctionTool) {
            LLMClient.FunctionTool fDesc = (LLMClient.FunctionTool)tool;
            GeminiQuery.FunctionDeclaration ft = new GeminiQuery.FunctionDeclaration();
            ft.name = fDesc.function.name;
            ft.description = fDesc.function.description;
            boolean compatible = fDesc.function.compatible == null || fDesc.function.compatible != false;
            ft.parametersJsonSchema = JSONSchemaCompatibilityEnhancer.enhance(fDesc.function.getParameters(), compatible ? JSONSchemaCompatibilityEnhancer.Provider.GEMINI : JSONSchemaCompatibilityEnhancer.Provider.PASSTHROUGH);
            return ft;
        }
        throw new IllegalArgumentException(String.format("Unknown tool: %s", tool.getClass().getSimpleName()));
    }

    private static GeminiQuery.Message adaptMessage(LLMClient.ChatMessage chatMessage, String thoughtSignature) {
        GeminiQuery.Message message = new GeminiQuery.Message();
        if (chatMessage.toolCalls != null) {
            message.parts = chatMessage.toolCalls.stream().map(GeminiQueryAdapter::adaptToolCall).collect(Collectors.toList());
        } else if (chatMessage.isTextOnly()) {
            GeminiQuery.MessagePart part = new GeminiQuery.MessagePart();
            part.text = chatMessage.getText();
            if (thoughtSignature != null) {
                part.thoughtSignature = thoughtSignature;
            }
            message.parts.add(part);
        } else {
            assert (chatMessage.parts != null);
            message.parts = GeminiQueryAdapter.adaptMessageParts(chatMessage.parts, thoughtSignature);
        }
        return message;
    }

    private static GeminiQuery.MessagePart adaptToolCall(LLMClient.AbstractToolCall atc) {
        if (atc instanceof LLMClient.FunctionToolCall) {
            LLMClient.FunctionToolCall ftc = (LLMClient.FunctionToolCall)atc;
            GeminiQuery.MessagePart part = new GeminiQuery.MessagePart();
            GeminiQuery.FunctionCall call = new GeminiQuery.FunctionCall();
            call.name = ftc.function.name;
            call.args = (JsonObject)JSON.parse((String)ftc.function.arguments, JsonObject.class);
            part.functionCall = call;
            if (atc.llmReasoning != null) {
                try {
                    part.thoughtSignature = atc.llmReasoning.get("thoughtSignature").getAsString();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Invalid thinking message format, thought signature is not present or not a string %s", atc.llmReasoning));
                }
            }
            return part;
        }
        throw new IllegalArgumentException("AbstractToolCall should be of type FunctionToolCall");
    }

    private static GeminiQuery.Message adaptSystemMessage(LLMClient.ChatMessage message) {
        if (!message.isTextOnly() || message.toolCalls != null) {
            throw new IllegalArgumentException("Chat message with role: system must be text-only");
        }
        GeminiQuery.Message geminiMessage = GeminiQueryAdapter.adaptMessage(message, null);
        geminiMessage.role = "system";
        return geminiMessage;
    }

    private static List<GeminiQuery.MessagePart> adaptMessageParts(List<LLMClient.ChatMessagePart> chatParts, String thoughtSignature) {
        chatParts = GeminiQueryAdapter.addTextPartIfNotPresent(chatParts);
        ArrayList<GeminiQuery.MessagePart> geminiParts = new ArrayList<GeminiQuery.MessagePart>();
        for (LLMClient.ChatMessagePart part : chatParts) {
            GeminiQuery.MessagePart geminiPart = new GeminiQuery.MessagePart();
            switch (part.type) {
                case TEXT: {
                    geminiPart.text = Strings.isNullOrEmpty((String)part.text) ? "image:" : part.text;
                    if (thoughtSignature == null) break;
                    geminiPart.thoughtSignature = thoughtSignature;
                    break;
                }
                case IMAGE_URI: {
                    if (!part.containsImageData()) {
                        throw new IllegalArgumentException("Image URIs not supported for Vertex models. Use inline images instead.");
                    }
                }
                case IMAGE_INLINE: {
                    LLMClient.Base64Image image = part.getBase64Image();
                    (geminiPart.inlineData = new GeminiQuery.InlineData()).mimeType = StringUtils.isBlank((String)image.mimeType) ? "image/jpeg" : image.mimeType;
                    geminiPart.inlineData.data = image.base64Data;
                }
            }
            geminiParts.add(geminiPart);
        }
        return geminiParts;
    }

    private static List<LLMClient.ChatMessagePart> addTextPartIfNotPresent(List<LLMClient.ChatMessagePart> chatParts) {
        Set partTypes = chatParts.stream().map(p -> p.type).collect(Collectors.toSet());
        Set onlyImageType = Stream.of(LLMClient.ChatMessagePartType.IMAGE_INLINE, LLMClient.ChatMessagePartType.IMAGE_URI).collect(Collectors.toSet());
        if (onlyImageType.containsAll(partTypes)) {
            LLMClient.ChatMessagePart dummyTextPart = new LLMClient.ChatMessagePart();
            dummyTextPart.type = LLMClient.ChatMessagePartType.TEXT;
            chatParts.add(dummyTextPart);
        }
        return chatParts;
    }

    private static GeminiQuery.Message adaptToolMessage(LLMClient.ChatMessage message) {
        if (!message.isTextOnly()) {
            throw new IllegalArgumentException(String.format("Chat message with role: %s must be text-only", message.role));
        }
        if (message.toolOutputs == null) {
            throw new IllegalArgumentException(String.format("Chat message with role: %s must have tool outputs", message.role));
        }
        GeminiQuery.Message geminiMessage = new GeminiQuery.Message();
        geminiMessage.role = "user";
        geminiMessage.parts = message.toolOutputs.stream().map(GeminiQueryAdapter::adapt).collect(Collectors.toList());
        return geminiMessage;
    }

    private static GeminiQuery.MessagePart adapt(LLMClient.ToolOutput toolOutput) {
        GeminiQuery.MessagePart part = new GeminiQuery.MessagePart();
        GeminiQuery.FunctionResponse resp = new GeminiQuery.FunctionResponse();
        resp.name = toolOutput.callId;
        try {
            resp.response = (JsonObject)JSON.parse((String)toolOutput.output, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            JsonObject json = new JsonObject();
            json.addProperty("result", toolOutput.output);
            resp.response = json;
        }
        part.functionResponse = resp;
        return part;
    }

    private static GeminiQuery.ToolConfig adapt(LLMClient.ToolChoice choice) {
        GeminiQuery.ToolConfig toolConfig = new GeminiQuery.ToolConfig();
        GeminiQuery.FunctionCallingConfig functionCallingConfig = new GeminiQuery.FunctionCallingConfig();
        if (choice instanceof LLMClient.NoneToolChoice) {
            functionCallingConfig.mode = GeminiQuery.ToolMode.NONE;
        } else if (choice instanceof LLMClient.RequiredToolChoice) {
            functionCallingConfig.mode = GeminiQuery.ToolMode.ANY;
        } else if (choice instanceof LLMClient.AutoToolChoice) {
            functionCallingConfig.mode = GeminiQuery.ToolMode.AUTO;
        } else if (choice instanceof LLMClient.NamedToolChoice) {
            LLMClient.NamedToolChoice ntc = (LLMClient.NamedToolChoice)choice;
            functionCallingConfig.mode = GeminiQuery.ToolMode.ANY;
            functionCallingConfig.allowedFunctions = Arrays.asList(ntc.name);
        }
        toolConfig.functionCallingConfig = functionCallingConfig;
        return toolConfig;
    }
}

