/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.utils;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.llm.RawAgentTrajectoryExtractor;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@UIModel
public class EnrichedTrajectory {
    @Nonnull
    public String agentId;
    @Nonnull
    public String agentSavedModelSmartId;
    @Nonnull
    public String agentSavedModelVersion;
    @Nonnull
    public String begin;
    @Nonnull
    public String end;
    @Nonnull
    public Long durationMs;
    @Nonnull
    public JsonElement input;
    @Nullable
    public JsonElement output;
    @Nullable
    public RawAgentTrajectoryExtractor.TrajectoryError error;
    @Nonnull
    public List<Element> agentLoop;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.trajectory");

    public EnrichedTrajectory(@Nonnull String agentId, @Nonnull String agentSavedModelSmartId, @Nonnull String agentSavedModelVersion, @Nonnull String begin, @Nonnull String end, @Nonnull Long durationMs, @Nonnull JsonElement input, @Nullable JsonElement output, @Nullable RawAgentTrajectoryExtractor.TrajectoryError error, @Nonnull List<Element> agentLoop) {
        this.agentId = agentId;
        this.agentSavedModelSmartId = agentSavedModelSmartId;
        this.agentSavedModelVersion = agentSavedModelVersion;
        this.begin = begin;
        this.end = end;
        this.durationMs = durationMs;
        this.input = input;
        this.output = output;
        this.error = error;
        this.agentLoop = agentLoop;
    }

    private static JsonElement getInputContent(RawAgentTrajectoryExtractor.ToolCallTrajectoryElement toolCall) {
        JsonObject fallback = toolCall.inputs;
        if (toolCall.inputs == null || !toolCall.inputs.isJsonObject()) {
            return fallback;
        }
        JsonElement input = toolCall.inputs.get("input");
        if (input == null) {
            return fallback;
        }
        try {
            return JsonParser.parseString((String)input.getAsString());
        }
        catch (Exception e) {
            return input;
        }
    }

    private static JsonElement getOutputContent(@Nonnull JsonObject toolCallOutputs) {
        JsonElement output = toolCallOutputs.get("output");
        if (output == null || !output.isJsonObject()) {
            return output;
        }
        JsonElement content = output.getAsJsonObject().get("content");
        if (content == null) {
            return output;
        }
        try {
            return JsonParser.parseString((String)content.getAsString());
        }
        catch (Exception e) {
            return content;
        }
    }

    public static class TriggeredGuardrail
    extends Element {
        @Nullable
        public String llmId;
        @Nonnull
        public RawAgentTrajectoryExtractor.GuardrailEnforcementType guardrailEnforcementType;
        @Nonnull
        public RawAgentTrajectoryExtractor.TrajectoryLevel trajectoryLevel;
        @Nullable
        public String guardrailType;
        @Deprecated
        @Nullable
        public GuardrailsPipelineSettings.GuardrailsPipelineElement guardrailDefinition;
        @Nonnull
        public JsonObject inputs;
        @Nonnull
        public JsonObject outputs;

        protected TriggeredGuardrail() {
        }

        public TriggeredGuardrail(RawAgentTrajectoryExtractor.GuardrailTrajectoryElement guardrail) {
            this.begin = guardrail.begin;
            this.end = guardrail.end;
            this.durationMs = guardrail.duration;
            this.llmId = guardrail.llmId;
            this.guardrailEnforcementType = guardrail.guardrailEnforcementType;
            this.trajectoryLevel = guardrail.guardrailLevel;
            this.guardrailType = TriggeredGuardrail.processGuardrailName(guardrail.name);
            this.inputs = guardrail.inputs;
            this.outputs = guardrail.outputs;
        }

        @Nullable
        @VisibleForTesting
        static String processGuardrailName(String guardrailName) {
            if (StringUtils.isEmpty((String)guardrailName)) {
                return guardrailName;
            }
            Pattern pattern = Pattern.compile("^GUARDRAIL_(.+)_\\d+$");
            Matcher matcher = pattern.matcher(guardrailName);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return guardrailName;
        }
    }

    public static class ToolCall
    extends Element {
        @Nullable
        public String toolId;
        @Nonnull
        public String toolName;
        @Nullable
        public String toolType;
        @Nullable
        public String subToolName;
        @Nullable
        public String toolDescriptorName;
        @Nullable
        public String toolDescriptorDescription;
        @Nullable
        public JsonElement inputContent;
        @Nullable
        public JsonElement outputContent;
        @Nullable
        public String error;

        protected ToolCall() {
        }

        ToolCall(RawAgentTrajectoryExtractor.ToolCallTrajectoryElement toolCall, AgentTool tool, AgentToolMeta.ToolDescriptor descriptor) {
            this.fillFromToolCallRawTrajectoryElement(toolCall);
            this.toolId = tool.id;
            this.toolName = tool.name;
            this.toolType = tool.type;
            this.toolDescriptorName = descriptor.name;
            this.toolDescriptorDescription = descriptor.description;
            this.subToolName = JsonUtils.getOrNullStr(toolCall.attributes, "subtoolName");
        }

        ToolCall(RawAgentTrajectoryExtractor.ToolCallTrajectoryElement toolCall, @Nonnull String toolCallName) {
            this.fillFromToolCallRawTrajectoryElement(toolCall);
            this.toolName = toolCallName;
        }

        private void fillFromToolCallRawTrajectoryElement(RawAgentTrajectoryExtractor.ToolCallTrajectoryElement toolCall) {
            this.inputContent = EnrichedTrajectory.getInputContent(toolCall);
            if (toolCall.outputs == null) {
                this.outputContent = null;
                this.error = null;
            } else {
                JsonElement error = toolCall.outputs.get("error");
                if (error != null && error.isJsonPrimitive()) {
                    this.error = error.getAsString();
                    this.outputContent = null;
                } else {
                    this.outputContent = EnrichedTrajectory.getOutputContent(toolCall.outputs);
                }
            }
            this.begin = toolCall.begin;
            this.end = toolCall.end;
            this.durationMs = toolCall.duration;
        }
    }

    @PolyJSON(value={@Mapping(value=ToolCall.class, type="TOOLCALL"), @Mapping(value=TriggeredGuardrail.class, type="GUARDRAIL")})
    public static abstract class Element {
        String begin;
        String end;
        Long durationMs;
    }
}

