/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.PivotMissingContext;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.io.LinoWriter;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.pivot.backend.common.automaticbin.PivotTableTensorAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.FiltersChartBuilder;
import com.dataiku.dip.pivot.backend.dss.HexbinTensorPivotBuilder;
import com.dataiku.dip.pivot.backend.dss.MultipassPivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.NonBinnedBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotTableAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.SimplePivotBuilder;
import com.dataiku.dip.pivot.backend.dss.TensorPivotBuilder;
import com.dataiku.dip.pivot.backend.dss.WebappChartBuilder;
import com.dataiku.dip.pivot.backend.dss.boxplots.BoxPlotsBuilder;
import com.dataiku.dip.pivot.backend.dss.density.Density2DBuilder;
import com.dataiku.dip.pivot.backend.dss.maps.MapRawGeometryBuilder;
import com.dataiku.dip.pivot.backend.dss.maps.MapScatterBuilder;
import com.dataiku.dip.pivot.backend.dss.maps.PivotMapAdminAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.maps.PivotMapGridAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.scatter.ScatterBuilder;
import com.dataiku.dip.pivot.backend.model.AggregatedPivotTableResponse;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.ColumnWithType;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.model.SideResponseKey;
import com.dataiku.dip.pivot.backend.model.SimpleAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.boxplots.PTBoxplotsRequest;
import com.dataiku.dip.pivot.backend.model.boxplots.PTBoxplotsResponse;
import com.dataiku.dip.pivot.backend.model.density.PT2DDensityRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrAdminRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrGridResponse;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrResponse;
import com.dataiku.dip.pivot.backend.model.maps.PTMapRawGeometryRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapScatterRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableFiltersRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableWebappRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterMultiplePairsRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterRequest;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.shaker.types.AbstractUDMDetector;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import gnu.trove.map.TIntIntMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinoUtils {
    @Autowired
    private IBasicMeaningsService basicMeaningsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.reports");

    public static List<SchemaColumn> getLinoableColumns(MemTable table) {
        ArrayList<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        Schema schema = TableToSchema.inferSchemaSimple(table, false);
        for (SchemaColumn col : schema.getColumns()) {
            if (col.getType() == Type.STRING) {
                MemColumn mc = table.column(col.getName());
                if (mc.distinctValues < 200) {
                    columns.add(col);
                    continue;
                }
                logger.info((Object)("Not linoable " + col.getName()));
                continue;
            }
            columns.add(col);
        }
        return columns;
    }

    public static void enrichWithSamplingMetadata(PivotTableResponse pivotResponse, File cacheFolder) {
        SampleMetadata sampleMetadata = SampleBuilder.getSampleMetadata(new File(cacheFolder, "sampling.metadata.json"));
        if (sampleMetadata != null) {
            pivotResponse.sampleMetadata = sampleMetadata;
        }
    }

    private static void checkColumnType(LinoReader linoReader, String in, String columnName, AxisDef.Type requestedType) {
        if (StringUtils.isBlank((String)columnName) || linoReader.nbRecords() == 0L || requestedType == AxisDef.Type.CUSTOM) {
            return;
        }
        LinoMetaFile.ColumnHeader header = linoReader.getColHeader(columnName);
        if (requestedType == AxisDef.Type.NUMERICAL && header.memType != ColumnBlock.MemoryType.DOUBLE || requestedType == AxisDef.Type.DATE && header.memType != ColumnBlock.MemoryType.DOUBLE) {
            throw ErrorContext.iaef((String)"In %s: Column %s was expected to be %s but is not. Maybe it changed type ? Try removing and re-adding it (found %s)", (Object)in, (Object[])new Object[]{columnName, requestedType, header.memType});
        }
    }

    private static void checkFilterColumnTypes(LinoReader linoReader, PivotTableRequest request) {
        for (RowFilter filter : request.filters) {
            if (filter.filterType == ChartFilter.FilterType.EXPLICIT) {
                for (ChartFilter.ExplicitCondition condition : filter.explicitConditions) {
                    LinoUtils.checkColumnType(linoReader, "filters", condition.column, condition.columnType);
                }
                continue;
            }
            LinoUtils.checkColumnType(linoReader, "filters", filter.column, filter.columnType);
        }
    }

    public static void checkColumnTypes(LinoReader linoReader, List<? extends ColumnWithType> columns, String label) {
        for (ColumnWithType columnWithType : columns) {
            if (columnWithType == null) continue;
            LinoUtils.checkColumnType(linoReader, label, columnWithType.column, columnWithType.type == null ? AxisDef.Type.NUMERICAL : columnWithType.type);
        }
    }

    public static PivotTableResponse fromLino(PivotTableRequest request, LinoReader linoReader, VariablesContext variablesContext) throws Exception {
        LinoUtils.checkFilterColumnTypes(linoReader, request);
        PivotTableResponse pivotTableResponse = LinoUtils.getPivotTableResponse(request, linoReader, variablesContext);
        LinoUtils.handleSideRequests(pivotTableResponse, request, linoReader, variablesContext);
        return pivotTableResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PivotTableResponse getPivotTableResponse(PivotTableRequest request, LinoReader linoReader, VariablesContext variablesContext) throws Exception {
        LinoUtils.checkFilterColumnTypes(linoReader, request);
        switch (request.type) {
            case AGGREGATED_ND: {
                int i;
                ColumnBlock[] axisBlocks;
                int b;
                PivotTableTensorRequest tensorRequest = (PivotTableTensorRequest)request;
                int numAxes = tensorRequest.axes.length;
                LinoUtils.checkColumnTypes(linoReader, Arrays.asList(tensorRequest.axes), "dimension");
                LinoUtils.checkColumnTypes(linoReader, tensorRequest.aggregations, "aggregations");
                BinsAndTensorsSafetyChecks.failIfTooManyBinsBasedOnExplicitConfiguration(tensorRequest, tensorRequest.axes);
                new PivotTableTensorAutomaticRequestHandler(tensorRequest, linoReader).replaceAutomaticAggregationLevels();
                AxisHandler[] handlers = new AxisHandler[numAxes];
                for (int i2 = 0; i2 < numAxes; ++i2) {
                    handlers[i2] = PivotTableAggrBuilder.buildLinoAxisHandler(linoReader, tensorRequest.axes[i2]);
                }
                MultipassPivotTableBuilder builder = LinoUtils.getMultipassPivotTableBuilder(tensorRequest, handlers, variablesContext, linoReader);
                builder.linoInit(linoReader);
                logger.info((Object)"Begin pass 1");
                for (b = 0; b < linoReader.nblocks(); ++b) {
                    axisBlocks = new ColumnBlock[numAxes];
                    for (i = 0; i < numAxes; ++i) {
                        axisBlocks[i] = linoReader.readColumnBlock(tensorRequest.axes[i].column, b);
                    }
                    builder.addPass1(axisBlocks, linoReader, b);
                }
                builder.endPass1();
                logger.info((Object)"Begin pass 2");
                try {
                    for (b = 0; b < linoReader.nblocks(); ++b) {
                        axisBlocks = new ColumnBlock[numAxes];
                        for (i = 0; i < numAxes; ++i) {
                            axisBlocks[i] = linoReader.readColumnBlock(tensorRequest.axes[i].column, b);
                        }
                        builder.addPass2(axisBlocks, PivotTableAggrBuilder.getAggrBlocks(linoReader, tensorRequest.aggregations, b), linoReader, b);
                    }
                    logger.info((Object)"End");
                    AggregatedPivotTableResponse aggregatedPivotTableResponse = builder.end();
                    return aggregatedPivotTableResponse;
                }
                finally {
                    builder.cleanup();
                }
            }
            case AGGREGATED_GEO_ADMIN: {
                PTMapAggrAdminRequest mapRequest = (PTMapAggrAdminRequest)request;
                LinoUtils.checkColumnTypes(linoReader, mapRequest.aggregations, "aggregations");
                PivotMapAdminAggrBuilder builder = new PivotMapAdminAggrBuilder(mapRequest);
                try {
                    PTMapAggrResponse pTMapAggrResponse = builder.buildFromLino(linoReader, variablesContext);
                    return pTMapAggrResponse;
                }
                finally {
                    PivotUtils.cleanupAggregators(builder.aggregators);
                }
            }
            case AGGREGATED_GEO_GRID: {
                PTMapAggrGridRequest mapRequest = (PTMapAggrGridRequest)request;
                LinoUtils.checkColumnTypes(linoReader, mapRequest.aggregations, "aggregations");
                PivotMapGridAggrBuilder builder = new PivotMapGridAggrBuilder(mapRequest);
                try {
                    PTMapAggrGridResponse pTMapAggrGridResponse = builder.buildFromLino(linoReader, variablesContext);
                    return pTMapAggrGridResponse;
                }
                finally {
                    PivotUtils.cleanupAggregators(builder.aggregators);
                }
            }
            case BOXPLOTS: {
                PTBoxplotsRequest boxplotsRequest = (PTBoxplotsRequest)request;
                if (boxplotsRequest.axes != null) {
                    LinoUtils.checkColumnTypes(linoReader, Arrays.asList(boxplotsRequest.axes), "axes");
                }
                LinoUtils.checkColumnTypes(linoReader, Collections.singletonList(boxplotsRequest.column), "column");
                BoxPlotsBuilder bb = new BoxPlotsBuilder(boxplotsRequest);
                try {
                    PTBoxplotsResponse pTBoxplotsResponse = bb.buildFromLino(linoReader);
                    return pTBoxplotsResponse;
                }
                finally {
                    bb.cleanup();
                }
            }
            case SCATTER_NON_AGGREGATED: {
                PTScatterRequest ptScatterRequest = (PTScatterRequest)request;
                LinoUtils.checkColumnTypes(linoReader, ptScatterRequest.columns, "columns");
                LinoUtils.checkColumnTypes(linoReader, Collections.singletonList(ptScatterRequest.xAxis), "xAxis");
                LinoUtils.checkColumnTypes(linoReader, Collections.singletonList(ptScatterRequest.yAxis), "yAxis");
                ScatterBuilder sb = new ScatterBuilder(ptScatterRequest);
                return sb.buildFromLino(linoReader);
            }
            case SCATTER_MULTIPLE_PAIRS_NON_AGGREGATED: {
                PTScatterMultiplePairsRequest ptScatterMPRequest = (PTScatterMultiplePairsRequest)request;
                LinoUtils.checkColumnTypes(linoReader, ptScatterMPRequest.columns, "columns");
                for (int i = 0; i < ptScatterMPRequest.axisPairs.size(); ++i) {
                    LinoUtils.checkColumnTypes(linoReader, Collections.singletonList(ptScatterMPRequest.axisPairs.get((int)i).xAxis), "xAxis");
                    LinoUtils.checkColumnTypes(linoReader, Collections.singletonList(ptScatterMPRequest.axisPairs.get((int)i).yAxis), "yAxis");
                }
                ScatterBuilder sb = new ScatterBuilder(ptScatterMPRequest);
                return sb.buildFromLino(linoReader);
            }
            case MAP_SCATTER_NON_AGGREGATED: {
                PTMapScatterRequest ptMapScatterRequest = (PTMapScatterRequest)request;
                LinoUtils.checkColumnTypes(linoReader, ptMapScatterRequest.columns, "columns");
                MapScatterBuilder sb = new MapScatterBuilder(ptMapScatterRequest);
                return sb.buildFromLino(linoReader);
            }
            case RAW_GEOMETRY: {
                PTMapRawGeometryRequest ptMapScatterRequest = (PTMapRawGeometryRequest)request;
                LinoUtils.checkColumnTypes(linoReader, ptMapScatterRequest.columns, "columns");
                MapRawGeometryBuilder sb = new MapRawGeometryBuilder((PTMapRawGeometryRequest)request);
                return sb.buildFromLino(linoReader);
            }
            case DENSITY_2D: {
                PT2DDensityRequest pt2DDensityRequest = (PT2DDensityRequest)request;
                LinoUtils.checkColumnType(linoReader, "X", pt2DDensityRequest.xColumn, AxisDef.Type.NUMERICAL);
                LinoUtils.checkColumnType(linoReader, "Y", pt2DDensityRequest.yColumn, AxisDef.Type.NUMERICAL);
                Density2DBuilder b = new Density2DBuilder(pt2DDensityRequest);
                return b.buildFromLino(linoReader);
            }
            case NO_PIVOT_AGGREGATED: {
                SimpleAggregatedRequest simpleAggregatedRequest = (SimpleAggregatedRequest)request;
                LinoUtils.checkColumnTypes(linoReader, simpleAggregatedRequest.aggregations, "aggregations");
                NonBinnedBuilder b = new NonBinnedBuilder(simpleAggregatedRequest, variablesContext, linoReader);
                return b.buildFromLino(linoReader);
            }
            case WEBAPP: {
                WebappChartBuilder b = new WebappChartBuilder((PivotTableWebappRequest)request);
                return b.buildFromLino(linoReader);
            }
            case FILTERS: {
                FiltersChartBuilder b = new FiltersChartBuilder((PivotTableFiltersRequest)request);
                return b.buildFromLino(linoReader);
            }
        }
        throw new Error("unreachable");
    }

    private static MultipassPivotTableBuilder getMultipassPivotTableBuilder(PivotTableTensorRequest tensorRequest, AxisHandler[] handlers, VariablesContext variablesContext, LinoReader linoReader) {
        PivotTableAggrBuilder builder = !tensorRequest.computeSubTotals && tensorRequest.axes.length == 1 ? new SimplePivotBuilder(tensorRequest, handlers, variablesContext, linoReader) : (tensorRequest.hexbin ? new HexbinTensorPivotBuilder(tensorRequest, handlers) : new TensorPivotBuilder(tensorRequest, handlers, variablesContext, linoReader));
        return builder;
    }

    public static boolean hasAllColumns(PivotTableRequest request, LinoReader linoReader) {
        return LinoUtils.areAxesCorrect(request, linoReader) && LinoUtils.areAggregationsCorrect(request, linoReader);
    }

    private static boolean areAxesCorrect(PivotTableRequest request, LinoReader linoReader) {
        if (request instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest tensorRequest = (PivotTableTensorRequest)request;
            try {
                for (AxisDef axis : tensorRequest.axes) {
                    linoReader.getColHeader(axis.column);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static boolean areAggregationsCorrect(PivotTableRequest request, LinoReader linoReader) {
        if (request instanceof PivotTableAggregatedRequest) {
            try {
                PivotTableAggregatedRequest aggregatedRequest = (PivotTableAggregatedRequest)request;
                for (Aggregation aggr : aggregatedRequest.aggregations) {
                    if (aggr.column == null || aggr.type == AxisDef.Type.CUSTOM) continue;
                    linoReader.getColHeader(aggr.column);
                }
            }
            catch (Exception e) {
                logger.info((Object)"Cache does not have all required columns");
                return false;
            }
        }
        return true;
    }

    public static void checkAllColumns(List<SchemaColumn> allColumns, PivotTableRequest request) {
        if (request == null) {
            return;
        }
        HashSet<String> columns = new HashSet<String>();
        for (SchemaColumn schemaColumn : allColumns) {
            columns.add(schemaColumn.getName());
        }
        if (request instanceof PivotTableAggregatedRequest) {
            if (request instanceof PivotTableTensorRequest) {
                PivotTableTensorRequest tensorRequest = (PivotTableTensorRequest)request;
                for (AxisDef axis : tensorRequest.axes) {
                    if (columns.contains(axis.column)) continue;
                    throw ErrorContext.pmce((String)axis.column, (PivotMissingContext)PivotMissingContext.BREAK_DOWN);
                }
            }
            for (Aggregation aggregation : ((PivotTableAggregatedRequest)request).aggregations) {
                if (aggregation.column == null || aggregation.function == Aggregation.Function.CUSTOM || columns.contains(aggregation.column)) continue;
                throw ErrorContext.iaef((String)"Column %s does not exist (used in measures)", (Object)aggregation.column, (Object[])new Object[0]);
            }
        }
        for (RowFilter rowFilter : request.filters) {
            if (rowFilter.column == null) continue;
            if (rowFilter.filterType == ChartFilter.FilterType.EXPLICIT) {
                for (ChartFilter.ExplicitCondition explicitCondition : rowFilter.explicitConditions) {
                    if (columns.contains(explicitCondition.column)) continue;
                    throw ErrorContext.pmce((String)explicitCondition.column, (PivotMissingContext)PivotMissingContext.FILTERS);
                }
                continue;
            }
            if (columns.contains(rowFilter.column)) continue;
            throw ErrorContext.pmce((String)rowFilter.column, (PivotMissingContext)PivotMissingContext.FILTERS);
        }
    }

    public static boolean allColumnsAreLinoable(List<SchemaColumn> linoableColumns, PivotTableRequest request) {
        boolean found = false;
        if (request instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest tensorRequest = (PivotTableTensorRequest)request;
            for (AxisDef axis : tensorRequest.axes) {
                for (SchemaColumn sc : linoableColumns) {
                    if (!sc.getName().equals(axis.column)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    logger.info((Object)("Not linoable: " + axis.column));
                    return false;
                }
                found = false;
            }
        }
        if (request instanceof PivotTableAggregatedRequest) {
            for (Aggregation aggr : ((PivotTableAggregatedRequest)request).aggregations) {
                if (aggr.column == null || aggr.function == Aggregation.Function.CUSTOM) continue;
                found = false;
                for (SchemaColumn sc : linoableColumns) {
                    if (!sc.getName().equals(aggr.column)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                logger.info((Object)("Not linoable " + aggr.column));
                return false;
            }
        }
        return true;
    }

    public static void handleSideRequests(PivotTableResponse response, PivotTableRequest request, LinoReader linoReader, VariablesContext variablesContext) throws Exception {
        if (response != null) {
            for (Map.Entry<SideResponseKey, List<PivotTableRequest>> entry : request.sideRequests.entrySet()) {
                logger.info((Object)("Building side request: " + String.valueOf((Object)entry.getKey())));
                ArrayList<PivotTableResponse> responses = new ArrayList<PivotTableResponse>();
                for (PivotTableRequest req : entry.getValue()) {
                    responses.add(LinoUtils.fromLino(req, linoReader, variablesContext));
                }
                response.sideResponses.put(entry.getKey(), responses);
            }
        }
    }

    public void fillUsableColumns(MemTable mt, ColumnSummary ret) throws IOException {
        for (Column _col : mt.columns()) {
            MemColumn col = (MemColumn)_col;
            ColumnSummary.UsableColumn dc = new ColumnSummary.UsableColumn();
            dc.column = col.getName();
            if (col.selectedType.type.getClass().getSimpleName().equals("Date")) {
                dc.type = AxisDef.Type.DATE.toString();
                dc.cacheable = true;
            } else if (col.selectedType.type.getClass().getSimpleName().equals("DateOnly")) {
                dc.type = AxisDef.Type.DATE.toString();
                dc.cacheable = true;
            } else if (col.selectedType.type.getClass().getSimpleName().equals("DatetimeNoTz")) {
                dc.type = AxisDef.Type.DATE.toString();
                dc.cacheable = true;
            } else if (col.selectedType.type.getClass().getSimpleName().equals("GeoPoint")) {
                dc.type = AxisDef.Type.GEOPOINT.toString();
                dc.cacheable = true;
            } else if (col.selectedType.type.getClass().getSimpleName().equals("GeometryMeaning")) {
                dc.type = AxisDef.Type.GEOMETRY.toString();
                dc.cacheable = true;
            } else if (col.selectedType.type.isDouble()) {
                dc.type = AxisDef.Type.NUMERICAL.toString();
                dc.cacheable = true;
            } else {
                dc.type = AxisDef.Type.ALPHANUM.toString();
            }
            if (col.distinctValues < 200) {
                dc.cacheable = true;
                ret.cacheableColumns.add(col.getName());
            }
            if (col.selectedType.type instanceof AbstractUDMDetector) {
                UserDefinedMeaning udm = this.basicMeaningsService.getUDMs().get(col.selectedType.type.getMeaningId());
                dc.meaningInfo = new ColumnSummary.MeaningInfo(udm);
            }
            ret.usableColumns.add(dc);
        }
    }

    public static LinoReader getCachedReader(File cacheFolder, PivotTableRequest request) throws IOException {
        if (cacheFolder != null && cacheFolder.isDirectory()) {
            LinoReader cacheReader;
            logger.info((Object)("Open cache: " + String.valueOf(cacheFolder)));
            try {
                cacheReader = new LinoReader(cacheFolder, "cache");
            }
            catch (IOException e) {
                logger.info((Object)"Invalid cache", (Throwable)e);
                DKUFileUtils.deleteDirectory((File)cacheFolder);
                return null;
            }
            logger.info((Object)"Cache is open");
            if (request == null || LinoUtils.hasAllColumns(request, cacheReader)) {
                return cacheReader;
            }
            logger.info((Object)"Don't use cache, bad column");
        } else {
            logger.info((Object)"No cache");
        }
        return null;
    }

    public static int nbRecords(LinoReader reader, int blockIdx) {
        long blockSize = reader.blockSizeAtIndex(blockIdx);
        return Math.toIntExact(blockIdx == 0 ? blockSize : blockSize - reader.blockSizeAtIndex(blockIdx - 1));
    }

    public static class LinoWritingOutput
    extends SinkProcessorOutput {
        ColumnFactory cf;
        LinoWriter wr;
        private final TIntIntMap firstLinoColPerSchemaCol;
        private final List<Column> columns;
        private final List<SchemaColumn> schemaColumns;
        Date dateType = new Date();
        DateOnly dateOnlyType = new DateOnly();
        DatetimeNoTz datetimeNoTzType = new DatetimeNoTz();
        GeometryMeaning geoMeaning = new GeometryMeaning();
        int except = 0;
        int rowIs = 0;

        public LinoWritingOutput(LinoWriter wr, ColumnFactory cf, List<SchemaColumn> schemaColumns, List<Column> columns, TIntIntMap firstLinoColPerSchemaCol) {
            this.wr = wr;
            this.cf = cf;
            this.firstLinoColPerSchemaCol = firstLinoColPerSchemaCol;
            this.columns = columns;
            this.schemaColumns = schemaColumns;
            assert (columns.size() == schemaColumns.size());
            assert (firstLinoColPerSchemaCol.size() == schemaColumns.size());
        }

        public void emitRow(Row row) throws Exception {
            this.wr.beginRow();
            block12: for (int i = 0; i < this.columns.size(); ++i) {
                String v = row.get(this.columns.get(i));
                int firstLinoCol = this.firstLinoColPerSchemaCol.get(i);
                switch (this.schemaColumns.get(i).getType()) {
                    case DATE: {
                        long ms = this.dateType.msSinceEpoch(v);
                        if (ms == Long.MAX_VALUE) {
                            this.wr.write(firstLinoCol, Double.NaN);
                            continue block12;
                        }
                        this.wr.write(firstLinoCol, ms);
                        continue block12;
                    }
                    case DATEONLY: {
                        long ms = this.dateOnlyType.msSinceEpoch(v);
                        if (ms == Long.MAX_VALUE) {
                            this.wr.write(firstLinoCol, Double.NaN);
                            continue block12;
                        }
                        this.wr.write(firstLinoCol, ms);
                        continue block12;
                    }
                    case DATETIMENOTZ: {
                        long ms = this.datetimeNoTzType.msSinceEpoch(v);
                        if (ms == Long.MAX_VALUE) {
                            this.wr.write(firstLinoCol, Double.NaN);
                            continue block12;
                        }
                        this.wr.write(firstLinoCol, ms);
                        continue block12;
                    }
                    case GEOPOINT: {
                        GeoPoint.Coords coords = GeoPoint.convert(v);
                        if (coords != null) {
                            this.wr.write(firstLinoCol, coords.longitude);
                            this.wr.write(firstLinoCol + 1, coords.latitude);
                        } else {
                            this.wr.write(firstLinoCol, Double.NaN);
                            this.wr.write(firstLinoCol + 1, Double.NaN);
                        }
                        this.wr.write(firstLinoCol + 2, v);
                        continue block12;
                    }
                    case GEOMETRY: {
                        boolean ok = false;
                        try {
                            Geometry geom = this.geoMeaning.toGeometry(v);
                            if (geom != null) {
                                ok = true;
                                Coordinate coords = geom.getCentroid().getCoordinate();
                                this.wr.write(firstLinoCol, coords.x);
                                this.wr.write(firstLinoCol + 1, coords.y);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!ok) {
                            this.wr.write(firstLinoCol, Double.NaN);
                            this.wr.write(firstLinoCol + 1, Double.NaN);
                        }
                        this.wr.write(firstLinoCol + 2, v);
                        continue block12;
                    }
                    case OBJECT: 
                    case MAP: 
                    case ARRAY: 
                    case STRING: 
                    case BOOLEAN: {
                        this.wr.write(firstLinoCol, v);
                        continue block12;
                    }
                    default: {
                        if (v == null) {
                            this.wr.write(firstLinoCol, Double.NaN);
                            continue block12;
                        }
                        try {
                            double d = Double.parseDouble(v);
                            this.wr.write(firstLinoCol, d);
                            continue block12;
                        }
                        catch (Exception e) {
                            ++this.except;
                            this.wr.write(firstLinoCol, Double.NaN);
                        }
                    }
                }
            }
            if (this.rowIs++ % 100000 == 0) {
                logger.infoV("Emitted %d records (%d failed)", new Object[]{this.rowIs, this.except});
            }
            this.wr.endRow();
        }
    }
}

