/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableUtils;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumericalNotBinnedAxisHandler
implements AxisHandler {
    List<Double> list = new ArrayList<Double>();
    Map<Double, Integer> map = new HashMap<Double, Integer>();
    private final Column col;

    public NumericalNotBinnedAxisHandler(Column col) {
        this.col = col;
        this.map.put(Double.NaN, 0);
        this.list.add(Double.NaN);
    }

    @Override
    public void observe(Row row) {
        String v = row.get(this.col);
        if (v == null || v.isEmpty()) {
            return;
        }
        double dv = Double.NaN;
        try {
            dv = Double.parseDouble(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Double.isNaN(dv)) {
            return;
        }
        Integer bin = this.map.get(dv);
        if (bin == null) {
            bin = this.map.size();
            this.map.put(dv, bin);
            this.list.add(dv);
        }
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        switch (block.getMemoryType()) {
            case DOUBLE: {
                BinsAndTensorsSafetyChecks.failIfTooManyBinsOnSingleAxis(null, this.map.size());
                for (int i = 0; i < block.doubles.length; ++i) {
                    Integer bin;
                    double v;
                    if (filters != null && !filters[i] || Double.isNaN(v = block.doubles[i]) || (bin = this.map.get(v)) != null) continue;
                    bin = this.map.size();
                    this.map.put(v, bin);
                    this.list.add(v);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unbinned axis on " + String.valueOf((Object)block.getMemoryType()) + " is not supported");
            }
        }
    }

    @Override
    public int getNbBins() {
        return this.map.size();
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (filters != null && !filters[i]) {
                ret[i] = 0;
                continue;
            }
            double v = block.doubles[i];
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                ret[i] = 0;
                continue;
            }
            Integer bin = this.map.get(v);
            if (bin == null) {
                throw new Error("Bin not found for value -->" + v + "<--");
            }
            ret[i] = bin;
        }
    }

    @Override
    public List<AxisElt> getAxisElts() {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        for (double value : this.list) {
            NumericalAxisElt elt = new NumericalAxisElt();
            if (Double.isNaN(value)) {
                elt.label = "___dku_no_value___";
                elt.sortValue = 0.0;
            } else {
                elt.label = PivotTableUtils.formatDouble(value);
                elt.sortValue = value;
            }
            ret.add(elt);
        }
        return ret;
    }
}

