/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.agents.blocks.custom.CustomBlocksGraphBlocksService;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockService;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateService;
import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.exposition.custom.CustomExpositionsService;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailsService;
import com.dataiku.dip.metrics.checks.CustomPythonChecksService;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginSetupPythonKernel;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.LoadedPluginDesc;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsService;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginsSetupService {
    @Autowired
    private IPluginsRegistryService pluginsService;
    @Autowired
    private CustomCodeRecipesService customCodeRecipesService;
    @Autowired
    private CustomPythonDatasetsService customPythonDatasetsService;
    @Autowired
    private CustomJavaDatasetsService customJavaDatasetsService;
    @Autowired
    private CustomPythonProbesService customPythonProbesService;
    @Autowired
    private CustomPythonExportersService customPythonExporterService;
    @Autowired
    private CustomJavaExportersService customJavaExporterService;
    @Autowired
    private CustomPythonChecksService customPythonChecksService;
    @Autowired
    private CustomSQLProbesService customSQLProbesService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    @Autowired
    private CustomJavaDialectsService customJavaDialectsService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private CustomExpositionsService customExpositionsService;
    @Autowired
    private CustomJythonProcessorsService customJythonProcessorsService;
    @Autowired
    private CustomPythonPredictionAlgoService customPythonPredictionAlgoService;
    @Autowired
    private PythonPluginClustersService customPythonClustersService;
    @Autowired
    private PythonPluginStepsService customPythonStepsService;
    @Autowired
    private PythonPluginTriggersService customPythonTriggersService;
    @Autowired
    private PluginParameterSetsService customParameterSetsService;
    @Autowired
    private PythonPluginCodeStudioTemplateService customPythonCodeStudioTemplateService;
    @Autowired
    private PythonPluginCodeStudioBlockService customPythonCodeStudioBlockService;
    @Autowired
    private PythonPluginProjectStandardsService customPythonProjectStandardsService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomAgentsService customAgentsService;
    @Autowired
    private CustomAgentToolsService customAgentToolsService;
    @Autowired
    private CustomBlocksGraphBlocksService customBlocksGraphBlocksService;
    @Autowired
    private CustomGuardrailsService customGuardrailsService;
    Cache<String, SetupSession> setupSessions = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new SetupSessionCloser()).build();
    private static Logger logger = Logger.getLogger((String)"dku.plugins.setup");

    PluginsSetupService() {
        Timer cacheExpirationTimer = new Timer("PluginSetupUI-cleanup", true);
        long delay = 300000L;
        cacheExpirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info((Object)("Perform routine cleanup on setup sessions cache (" + PluginsSetupService.this.setupSessions.size() + " sessions open)"));
                PluginsSetupService.this.setupSessions.cleanUp();
            }
        }, delay, delay);
    }

    private boolean isAppFakePluginId(String pluginId) {
        return StringUtils.isNotBlank((String)pluginId) && pluginId.startsWith("__dku_app_tile_");
    }

    private String getAppProjectKeyFromPluginId(String pluginId) {
        return pluginId.substring("__dku_app_tile_".length());
    }

    private boolean isAppRecipeFakePluginId(String pluginId) {
        return StringUtils.isNotBlank((String)pluginId) && pluginId.startsWith("__dku_app_as_recipe_tile_");
    }

    private String getAppRecipeAppIdFromPluginId(String pluginId) {
        return pluginId.substring("__dku_app_as_recipe_tile_".length());
    }

    private AppHomepageTile.ProjectVariablesTile getAppTileFromComponentId(AuthCtx authCtx, String projectKey, String componentId) throws IOException {
        AppManifest manifest = this.appsService.getAppInstanceManifestForProject_NT(authCtx, projectKey);
        assert (manifest != null);
        TileCoordsInManifest tileCoords = (TileCoordsInManifest)JSON.parse((String)componentId, TileCoordsInManifest.class);
        if (tileCoords.section < 0 || tileCoords.section >= manifest.homepageSections.size()) {
            throw new IllegalArgumentException("Incorrect tile coordinate in manifest: section " + tileCoords.section + " doesn't exist");
        }
        if (tileCoords.tile < 0 || tileCoords.tile >= manifest.homepageSections.get((int)tileCoords.section).tiles.size()) {
            throw new IllegalArgumentException("Incorrect tile coordinate in manifest: tile " + tileCoords.tile + " doesn't exist");
        }
        AppHomepageTile tile = manifest.homepageSections.get((int)tileCoords.section).tiles.get(tileCoords.tile);
        if (!(tile instanceof AppHomepageTile.ProjectVariablesTile)) {
            throw new IllegalArgumentException("Incorrect tile coordinate in manifest: tile at " + componentId + " isn't a form");
        }
        return (AppHomepageTile.ProjectVariablesTile)tile;
    }

    private AppHomepageTile.ProjectVariablesTile getAppTileFromAppId(AuthCtx authCtx, String appId) throws IOException {
        AppManifest manifest = this.appsService.getAppTemplateManifest_NT(appId);
        assert (manifest != null);
        return manifest.useAsRecipeSettings.variablesEditionTile;
    }

    private SetupableComponentLoadedDesc getComponentDesc(AuthCtx authCtx, final String pluginId, final String componentId, CallPythonDoContext pythonDoContext) throws IOException {
        if (this.isAppFakePluginId(pluginId)) {
            String projectKey = this.getAppProjectKeyFromPluginId(pluginId);
            final AppHomepageTile.ProjectVariablesTile tile = this.getAppTileFromComponentId(authCtx, projectKey, componentId);
            return new SetupableComponentLoadedDesc(){

                @Override
                public String getOwnerPluginId() {
                    return pluginId;
                }

                @Override
                public String getId() {
                    return componentId;
                }

                @Override
                public String getPythonSetupFileName() {
                    return StringUtils.isNotBlank((String)tile.python) ? "__dku_tile_python" : "";
                }
            };
        }
        if (this.isAppRecipeFakePluginId(pluginId)) {
            String appId = this.getAppRecipeAppIdFromPluginId(pluginId);
            final AppHomepageTile.ProjectVariablesTile tile = this.getAppTileFromAppId(authCtx, appId);
            return new SetupableComponentLoadedDesc(){

                @Override
                public String getOwnerPluginId() {
                    return pluginId;
                }

                @Override
                public String getId() {
                    return componentId;
                }

                @Override
                public String getPythonSetupFileName() {
                    return StringUtils.isNotBlank((String)tile.python) ? "__dku_tile_python" : "";
                }
            };
        }
        InstalledPluginDesc pluginDesc = this.pluginsService.getInstalledDesc(pluginId);
        if (pluginDesc == null) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin " + pluginId + " not found");
        }
        ArrayList componentDescs = Lists.newArrayList();
        componentDescs.addAll(this.customPythonRunnablesService.list());
        componentDescs.addAll(this.customJavaRunnablesService.list());
        componentDescs.addAll(this.customExpositionsService.list());
        componentDescs.addAll(this.customPythonClustersService.list());
        componentDescs.addAll(this.customParameterSetsService.list());
        componentDescs.addAll(this.customPythonCodeStudioTemplateService.list());
        componentDescs.addAll(this.customPythonCodeStudioBlockService.list());
        componentDescs.addAll(this.customPythonProjectStandardsService.list());
        componentDescs.addAll(this.customFieldsService.list());
        componentDescs.addAll(this.customGuardrailsService.list());
        switch (pythonDoContext) {
            case IN_PROJECT: {
                componentDescs.addAll(this.customCodeRecipesService.list());
                componentDescs.addAll(this.customPythonDatasetsService.list());
                componentDescs.addAll(this.customJavaDatasetsService.list());
                componentDescs.addAll(this.customPythonProbesService.list());
                componentDescs.addAll(this.customSQLProbesService.list());
                componentDescs.addAll(this.customPythonChecksService.list());
                componentDescs.addAll(this.customPythonExporterService.list());
                componentDescs.addAll(this.customPythonFormatsService.list());
                componentDescs.addAll(this.customJavaFormatsService.list());
                componentDescs.addAll(this.customJavaExporterService.list());
                componentDescs.addAll(this.customWebAppsService.list());
                componentDescs.addAll(this.customPythonFSProvidersService.list());
                componentDescs.addAll(this.customJavaFSProvidersService.list());
                componentDescs.addAll(this.customJavaDialectsService.list());
                componentDescs.addAll(this.customJythonProcessorsService.list());
                componentDescs.addAll(this.customPythonPredictionAlgoService.list());
                componentDescs.addAll(this.customPythonStepsService.list());
                componentDescs.addAll(this.customPythonTriggersService.list());
                componentDescs.addAll(this.customAgentsService.list());
                componentDescs.addAll(this.customAgentToolsService.list());
                componentDescs.addAll(this.customBlocksGraphBlocksService.list());
                break;
            }
        }
        return PluginsSetupService.getMatchingComponent(pluginId, componentId, componentDescs).orElse(null);
    }

    public static Optional<SetupableComponentLoadedDesc> getMatchingComponent(String pluginId, String componentId, List<SetupableComponentLoadedDesc> componentDescs) {
        ArrayList matchingComponentDescs = Lists.newArrayList();
        for (SetupableComponentLoadedDesc componentDesc : componentDescs) {
            if (!componentDesc.getOwnerPluginId().equals(pluginId) || !componentDesc.getId().equals(componentId)) continue;
            matchingComponentDescs.add(componentDesc);
        }
        if (matchingComponentDescs.size() > 1) {
            for (SetupableComponentLoadedDesc componentDesc : matchingComponentDescs) {
                logger.error((Object)("Component with id " + componentId + " : " + JSON.prettyLog((Object)componentDesc)));
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, String.format("Ambiguous componentId %s matches %s components", componentId, matchingComponentDescs.size()));
        }
        return matchingComponentDescs.stream().findFirst();
    }

    public void killSessions() {
        this.setupSessions.invalidateAll();
    }

    public SetupSession createSession(String pluginId, String componentId, AuthCtx user, String projectKey, SetupPart setupPart, CallPythonDoContext callPythonDoContext) throws Exception {
        SetupableComponentLoadedDesc loadedDesc;
        SetupableComponentLoadedDesc setupableComponentLoadedDesc = loadedDesc = StringUtils.isNotBlank((String)componentId) ? this.getComponentDesc(user, pluginId, componentId, callPythonDoContext) : new LoadedPluginDesc(this.pluginsService.getDesc(pluginId));
        if (loadedDesc == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Plugin component " + componentId + " in " + pluginId + " not found");
        }
        String pythonFileName = null;
        switch (setupPart) {
            case MAIN: {
                pythonFileName = loadedDesc.getPythonSetupFileName();
                break;
            }
            case TOPBAR: {
                pythonFileName = ((LoadedCustomWebApp)loadedDesc).desc.chart.topBarPythonSetup;
                break;
            }
            case LEFTBAR: {
                pythonFileName = ((LoadedCustomWebApp)loadedDesc).desc.chart.leftBarPythonSetup;
            }
        }
        if (StringUtils.isBlank(pythonFileName)) {
            throw new Exception("Plugin component " + componentId + " in " + pluginId + " doesn't declare python setup code");
        }
        SetupSession session = new SetupSession();
        session.loadedDesc = loadedDesc;
        session.id = SecretKeyGenerator.generate((int)8);
        session.user = user;
        session.projectKey = projectKey;
        session.startTime = DateTime.now().getMillis();
        session.ticket = this.apiTicketService.createTicket(user, "plugin_ui_setup:" + pluginId, (Object)session);
        String envName = null;
        if (!this.isAppFakePluginId(loadedDesc.getOwnerPluginId()) && !this.isAppRecipeFakePluginId(loadedDesc.getOwnerPluginId())) {
            envName = new CodeEnvSelector().getCodeEnvNameForPlugin(loadedDesc.getOwnerPluginId());
        }
        logger.info((Object)("Start new session for custom form " + session.id));
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        session.link = new ResponderKernelLink(session.id, dssPortRange);
        session.kernel = new PluginSetupPythonKernel(session.link, this.getResourceFolder(loadedDesc), this.getLibFolder(loadedDesc), session.ticket, session.projectKey, envName);
        try {
            PluginSetupPythonKernel.StartResponse started;
            session.kernel.start();
            String code = this.getCode(user, loadedDesc, pythonFileName);
            try {
                started = (PluginSetupPythonKernel.StartResponse)session.link.execute((Object)new PluginSetupPythonKernel.StartRequest(code), PluginSetupPythonKernel.StartResponse.class, "Failed to start python worker");
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail((IDSSKernelBase)session.kernel);
                throw session.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
            if (!started.ok) {
                logger.warn((Object)"Failed to start session");
                this.closeKernelLinkNoException(session);
                throw new Exception("Failed to start ui setup kernel: " + started.reason);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Kernel unable to start, kill it");
            this.closeKernelLinkNoException(session);
            throw e;
        }
        logger.info((Object)"Session ready");
        this.setupSessions.put((Object)session.id, (Object)session);
        return session;
    }

    private void closeKernelLinkNoException(SetupSession session) {
        try {
            session.link.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to close link setup kernel", (Throwable)ex);
        }
        try {
            session.kernel.killWithoutMercy();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to cleanup setup kernel", (Throwable)ex);
        }
        finally {
            this.apiTicketService.expireTicket(session.ticket);
        }
    }

    public List<PluginSetupPythonKernel.DoRequestInput> buildDoRequestInputs(@Nullable SerializedRecipe recipeConfig) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (recipeConfig != null) {
            for (Map.Entry<String, SerializedRecipe.InputRole> recipeInputRole : recipeConfig.getInputsUnsafe().entrySet()) {
                for (SerializedRecipe.RecipeInput recipeInput : recipeInputRole.getValue().items) {
                    FlowComputable computable = this.computableFromRefService.get(recipeConfig.projectKey, recipeInput.ref);
                    result.add(new PluginSetupPythonKernel.DoRequestInput(recipeInputRole.getKey(), computable.getType(), computable.getFullId()));
                }
            }
        }
        return result;
    }

    public Callable<SetupData> callPythonDo(String sessionId, JsonObject config, JsonObject payload, String pluginId, String componentId, AuthCtx user, String projectKey, List<PluginSetupPythonKernel.DoRequestInput> recipeRequestInputs, SetupPart setupPart, CallPythonDoContext callPythonDoContext) throws Exception {
        SetupSession session;
        boolean created = false;
        SetupSession setupSession = session = StringUtils.isNotBlank((String)sessionId) ? (SetupSession)this.setupSessions.getIfPresent((Object)sessionId) : null;
        if (session == null) {
            session = this.createSession(pluginId, componentId, user, projectKey, setupPart, callPythonDoContext);
            created = true;
        }
        return this.callPythonDo(session, created, config, payload, recipeRequestInputs);
    }

    private Callable<SetupData> callPythonDo(final SetupSession session, final boolean created, JsonObject config, final JsonObject payload, final List<PluginSetupPythonKernel.DoRequestInput> inputs) throws IOException, DKUSecurityException {
        final PluginSettingsResolver.ResolvedSettings resolvedConfig = this.getComponentSettings(session.user, session.projectKey, session.loadedDesc, config);
        return new Callable<SetupData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SetupData call() throws Exception {
                try {
                    JsonObject data;
                    ResponderKernelLink responderKernelLink = session.link;
                    synchronized (responderKernelLink) {
                        data = (JsonObject)session.link.execute((Object)new PluginSetupPythonKernel.DoRequest(payload, resolvedConfig, inputs), JsonObject.class, "Failed to call UI interactive code");
                    }
                    PluginsSetupService.this.setupSessions.getIfPresent((Object)session.id);
                    return new SetupData(session.id, created, data);
                }
                catch (SocketBlockLinkException e) {
                    PluginsSetupService.this.setupSessions.invalidate((Object)session.id);
                    e.withLogTail((IDSSKernelBase)session.kernel);
                    throw session.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
                }
                catch (IOException e) {
                    PluginsSetupService.this.setupSessions.invalidate((Object)session.id);
                    throw new SocketBlockLinkIOException("Failed to call UI interactive code", (Throwable)e).withLogTail((IDSSKernelBase)session.kernel);
                }
            }
        };
    }

    private PluginSettingsResolver.ResolvedSettings getComponentSettings(AuthCtx liu, String projectKey, SetupableComponentLoadedDesc componentDesc, JsonObject config) throws IOException, DKUSecurityException {
        boolean isAppAsRecipeOrDataikuApp;
        String pluginId = componentDesc.getOwnerPluginId();
        boolean bl = isAppAsRecipeOrDataikuApp = !(componentDesc instanceof IElementLoadedDesc);
        if (isAppAsRecipeOrDataikuApp) {
            assert (this.isAppRecipeFakePluginId(pluginId) || this.isAppFakePluginId(pluginId));
            return new PluginSettingsResolver.ResolvedSettings(config, new JsonObject());
        }
        List<ParamDesc> componentParams = ((IElementLoadedDesc)componentDesc).getParams();
        return new PluginSettingsResolver(liu, projectKey).getPluginSettings(componentParams, config, pluginId);
    }

    private String getCode(AuthCtx authCtx, SetupableComponentLoadedDesc loadedDesc, String pythonFileName) throws IOException {
        String pluginId = loadedDesc.getOwnerPluginId();
        if (this.isAppFakePluginId(pluginId)) {
            String projectKey = this.getAppProjectKeyFromPluginId(pluginId);
            AppHomepageTile.ProjectVariablesTile tile = this.getAppTileFromComponentId(authCtx, projectKey, loadedDesc.getId());
            return tile.python;
        }
        if (this.isAppRecipeFakePluginId(pluginId)) {
            String appId = this.getAppRecipeAppIdFromPluginId(pluginId);
            AppHomepageTile.ProjectVariablesTile tile = this.getAppTileFromAppId(authCtx, appId);
            return tile.python;
        }
        File resourceDir = this.pluginsService.getPluginResourceFolder(pluginId);
        return FileUtils.readFileToString((File)new File(resourceDir, pythonFileName), (String)"utf8");
    }

    private String getResourceFolder(SetupableComponentLoadedDesc loadedDesc) {
        String pluginId = loadedDesc.getOwnerPluginId();
        if (this.isAppFakePluginId(pluginId) || this.isAppRecipeFakePluginId(pluginId)) {
            return null;
        }
        File resourceDir = this.pluginsService.getPluginResourceFolder(pluginId);
        return resourceDir.getAbsolutePath();
    }

    private String getLibFolder(SetupableComponentLoadedDesc loadedDesc) {
        String pluginId = loadedDesc.getOwnerPluginId();
        if (this.isAppFakePluginId(pluginId) || this.isAppRecipeFakePluginId(pluginId)) {
            return null;
        }
        File libDir = this.pluginsService.getPluginPythonlibFolder(pluginId);
        return libDir.getAbsolutePath();
    }

    private class SetupSessionCloser
    implements RemovalListener<String, SetupSession> {
        private SetupSessionCloser() {
        }

        public void onRemoval(RemovalNotification<String, SetupSession> removed) {
            SetupSession session = (SetupSession)removed.getValue();
            logger.info((Object)("Destroy idle setup session " + session.id));
            try {
                session.link.sendNullCommand();
                session.link.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure during kernel shutdown", (Throwable)e);
            }
            try {
                session.kernel.killWithoutMercy();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure during kernel shutdown", (Throwable)e);
            }
            try {
                PluginsSetupService.this.apiTicketService.expireTicket(session.ticket);
            }
            catch (Exception e) {
                logger.warn((Object)"Failure when removing session ticket", (Throwable)e);
            }
        }
    }

    private static class TileCoordsInManifest {
        public int section;
        public int tile;

        private TileCoordsInManifest() {
        }
    }

    public static enum CallPythonDoContext {
        IN_PROJECT,
        IN_CLUSTER,
        IN_PROJECT_CREATOR,
        NONE;

    }

    public static interface SetupableComponentLoadedDesc {
        public String getOwnerPluginId();

        public String getId();

        public String getPythonSetupFileName();
    }

    public static enum SetupPart {
        MAIN,
        TOPBAR,
        LEFTBAR;

    }

    public static class SetupSession {
        SetupableComponentLoadedDesc loadedDesc;
        String id;
        long startTime;
        AuthCtx user;
        public ResponderKernelLink link;
        public PluginSetupPythonKernel kernel;
        public String projectKey;
        public APITicketService.Ticket ticket;
    }

    public static class SetupData {
        boolean sessionCreated;
        String sessionId;
        Object data;

        SetupData(String sessionId, boolean created, Object data) {
            this.sessionId = sessionId;
            this.sessionCreated = created;
            this.data = data;
        }
    }
}

