/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.hive.HiveGlobalMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveLocalMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.HiveValidationTools;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.code.hive.AbstractHiveRecipeRunner;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.hproxy.model.hive.ValidationResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveInternalRunner
extends AbstractHiveRecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    private JobActivity activity;
    private RecipeRunnableSubgraph subgraph;
    private boolean overwriteTargetSchema;
    private boolean dropOnPartitionedMismatch;
    private Map<String, String> extraHiveConf;
    private HiveRecipeMeta.HiveExecutionEngine executionEngine;
    private boolean addDkuUdf;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.internal.hive");

    public HiveInternalRunner(JobActivity activity, boolean overwriteTargetSchema, boolean dropOnPartitionedMismatch, HiveRecipeMeta.HiveExecutionEngine executionEngine, Map<String, String> extraHiveConf, boolean addDkuUdf) {
        this.executionEngine = executionEngine;
        this.addDkuUdf = addDkuUdf;
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.overwriteTargetSchema = overwriteTargetSchema;
        this.dropOnPartitionedMismatch = dropOnPartitionedMismatch;
        this.extraHiveConf = extraHiveConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String initialQuery) throws Exception {
        ArrayList extraConf = Lists.newArrayList();
        for (Map.Entry<String, String> e : this.extraHiveConf.entrySet()) {
            extraConf.add(new SimpleKeyValue(e.getKey(), e.getValue()));
        }
        if (this.overwriteTargetSchema) {
            this.handleSchemaOverwrite(initialQuery, extraConf);
        }
        for (FlowDataset fd : this.activity.getSubgraph().getTargetsDatasets()) {
            Partition p = this.activity.getSubgraph().getTargetPartition(fd);
            DatasetHandler dh = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), fd.getMandatory(this.datasetsDAO));
            try {
                dh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
            }
            finally {
                if (dh == null) continue;
                dh.close();
            }
        }
        MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtxService.getAuthCtx(), JobContext.getCurrentJobContext().projectKey);
        try {
            logger.info((Object)"Preprocessing");
            HiveMetastoreTablesHandler tablesHandler = null;
            String recipeProjectKey = this.subgraph.getRecipe().getProjectKey();
            switch (this.executionEngine) {
                case HIVECLI_LOCAL: {
                    tablesHandler = new HiveLocalMetastoreTablesHandler(recipeProjectKey, this.authCtxService.getAuthCtx(), false, inspector);
                    break;
                }
                case HIVECLI_GLOBAL: {
                    tablesHandler = new HiveGlobalMetastoreTablesHandler(this.authCtxService.getAuthCtx(), inspector, false);
                    break;
                }
                case HIVESERVER2: {
                    tablesHandler = new HiveGlobalMetastoreTablesHandler(this.authCtxService.getAuthCtx(), inspector, true);
                }
            }
            assert (tablesHandler != null);
            HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), recipeProjectKey).getHiveSettings();
            HiveScriptPreprocessor preprocessor = new HiveScriptPreprocessor(this.authCtxService.getAuthCtx(), this.datasetsDAO, this.variablesService.getForProject(recipeProjectKey), this.activity.getSubgraph(), initialQuery, tablesHandler, this.addDkuUdf, hiveSettings);
            preprocessor.setForceInsertOverwrite(true);
            preprocessor.setValidationMode(false);
            preprocessor.preprocess();
            extraConf.addAll(tablesHandler.getCollectedExtraConf());
            logger.info((Object)"Hive script preprocessed");
            tablesHandler.prepare();
            logger.info((Object)"Starting up Hive and executing the query");
            JobContext jta = JobContext.getCurrentJobContext();
            this.startAndWaitHive(this.activity, jta, preprocessor, this.makeListener(this.activity), this.subgraph.id(), extraConf, this.executionEngine, this.authCtxService.getAuthCtx(), recipeProjectKey);
            tablesHandler.postProcess();
        }
        finally {
            HiveInternalRunner hiveInternalRunner = this;
            synchronized (hiveInternalRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    private void handleSchemaOverwrite(String hiveQuery, List<SimpleKeyValue> extraConf) throws Exception {
        logger.info((Object)"Checking the Hive query and dataset compatibility");
        MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtxService.getAuthCtx(), JobContext.getCurrentJobContext().projectKey);
        HiveMetastoreTablesHandler tablesHandler = null;
        switch (this.executionEngine) {
            case HIVECLI_LOCAL: {
                tablesHandler = new HiveLocalMetastoreTablesHandler(this.subgraph.getRecipe().getProjectKey(), this.authCtxService.getAuthCtx(), false, inspector);
                break;
            }
            case HIVECLI_GLOBAL: {
                tablesHandler = new HiveGlobalMetastoreTablesHandler(this.authCtxService.getAuthCtx(), inspector, false);
                break;
            }
            case HIVESERVER2: {
                tablesHandler = new HiveGlobalMetastoreTablesHandler(this.authCtxService.getAuthCtx(), inspector, true);
            }
        }
        assert (tablesHandler != null);
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), this.subgraph.getRecipe().getProjectKey()).getHiveSettings();
        HiveScriptPreprocessor preprocessor = new HiveScriptPreprocessor(this.authCtxService.getAuthCtx(), this.datasetsDAO, this.variablesService.getForProject(this.subgraph.getRecipe().getProjectKey()), this.subgraph, hiveQuery, tablesHandler, this.addDkuUdf, hiveSettings);
        preprocessor.setForceInsertOverwrite(true);
        preprocessor.setValidationMode(true);
        tablesHandler.setHDFSPathPrefix("/dku_flow_hive_tmp/" + System.currentTimeMillis());
        preprocessor.preprocess();
        ValidationResult rawHiveResponse = KernelSession.doHiveCheck(this.subgraph.getRecipe().getProjectKey(), preprocessor.getInitQuery(), preprocessor.getQuery(), extraConf, false, this.executionEngine != HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL, true);
        logger.info((Object)("Got validation response: \n" + JSON.prettyLog((Object)rawHiveResponse)));
        List<HiveSchemaHandler.Suggestion> suggestions = HiveSchemaHandler.generateSuggestions(this.datasetsDAO, preprocessor.getTargetsByTableName(), rawHiveResponse.insertOverwrites);
        HiveValidationTools.removeIrrelevantMessages(rawHiveResponse, preprocessor);
        for (ValidationResult.ValidationMessage message : rawHiveResponse.messages) {
            if (message.severity == ValidationResult.ValidationMessage.Severity.ERROR) {
                throw ErrorContext.iae((String)("Could not execute Hive query, got error from Hive: " + message.errorMessage + " at line " + message.errorLineFrom));
            }
            if (message.severity != ValidationResult.ValidationMessage.Severity.WARNING) continue;
            logger.warn((Object)("Got a warning from Hive:" + message.errorMessage + " at line " + message.errorLineFrom));
        }
        for (HiveSchemaHandler.Suggestion sugg : suggestions) {
            logger.info((Object)("Will update schema of  " + sugg.dataset.name));
            logger.info((Object)("Because:\n " + StringUtils.join(sugg.reasons, (String)"\n")));
            String fullName = sugg.dataset.projectKey + "." + sugg.dataset.name;
            logger.info((Object)"Overriding the schema of the dataset");
            this.datasetWritingService.writeDatasetSchema(TransactionContext.retrieveWrite().getUser(), DatasetLocUtils.resolveFull(fullName), sugg.dataset.getSchema(), false, "hive");
            KernelSession.propagateSchemaToJekOrBackend(fullName, sugg.dataset.getSchema());
            this.datasetsDAO.save(sugg.dataset);
        }
    }

    @Override
    public void run() {
        throw new Error("unreachable");
    }
}

