/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.r.AbstractRRecipeRunner;
import com.dataiku.dip.recipes.code.spark.SparkBasedActivityHelper;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkRRecipeRunner
extends AbstractSparkBasedRecipeRunner
implements RecipeRunnerWithPayload {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private String code;
    private SparkRRecipeMeta.SparkRRecipeParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.code.sparkr");

    public SparkRRecipeRunner(JobActivity activity) {
        super(activity);
        this.params = RecipeRegistry.getParamsAs(activity, SparkRRecipeMeta.SparkRRecipeParams.class);
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }

    protected File prepareWrapper(File processRunDir) throws Exception {
        String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/R-exec-wrapper.R");
        File wrapperFile = new File(processRunDir, "r-exec-wrapper.R");
        DKUFileUtils.writeFileUTF8((File)wrapperFile, (String)wrapperContent);
        return wrapperFile;
    }

    @Override
    public void run() throws Exception {
        CodeEnvSelector envSelector = new CodeEnvSelector();
        String envName = envSelector.selectForRRecipe(this.recipe.getProjectKey(), RecipeRegistry.getParamsAs((JobActivity)this.activity, SparkRRecipeMeta.SparkRRecipeParams.class).envSelection);
        switch (this.params.recipeMode) {
            case SPARKR: {
                this.runUsingSparkR(envName);
                break;
            }
            case SPARKLYR: {
                File logFile = FlowJobUtils.getJobTouchedFile("sparklyr-recipe", "process-out.log");
                JobContext.getCurrentActivityObj().getStatus().addStatutOutput("R output", logFile, "text/plain");
                this.runUsingSparklyr(logFile, envName);
            }
        }
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUsingSparklyr(File targetLogFile, String envName) throws IOException, DKUSecurityException, InterruptedException, Exception {
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
        SparkSettings sparkSettings = clusterSettings.getSparkSettings();
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        List<SimpleKeyValue> confWithoutRBin = SparkJobHelper.composeConf(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), sparkSettings, this.params.sparkConfig, new HashMap<String, String>());
        SparkBasedActivityHelper helper = new SparkBasedActivityHelper(this.recipe.getProjectKey(), this.authCtxService.getAuthCtx(), (File)FlowJobUtils.getTmpFolder("sparkbased-recipe", "out"), null);
        helper.configure(this.recipe.getProjectKey(), this.activity, confWithoutRBin);
        try {
            File tmpScriptData = new File(helper.getProcessRunDir(), "recipe.R");
            FileUtils.writeStringToFile((File)tmpScriptData, (String)this.code);
            SparkSubmitHelper sparkSubmitHelper = SparkSubmitHelper.build(this.projectKey, this.authCtxService.getAuthCtx(), sparkSettings, hadoopSettings, null, sparkSettings.getByName(this.params.sparkConfig.inheritConf));
            sparkSubmitHelper.failIfUnsupportedSpark();
            helper.addExtraExtraEnv("DKU_SPARKLYR_CONFIG", JSON.json((Object)sparkSubmitHelper.getSparklyrConfig(this.params.sparkConfig)));
            helper.addExtraExtraEnv("SPARK_HOME", System.getenv("DKU_SPARK_HOME"));
            String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/R-exec-wrapper.R");
            List<String> cmd = AbstractRRecipeRunner.getRCmd(this.recipe.getProjectKey(), envName, Lists.newArrayList((Object[])new String[]{tmpScriptData.getAbsolutePath()}));
            this.activity.setStatusMessage("Executing Spark code");
            File tmpDir = helper.getProcessRunDir();
            EnvironmentStash stash = this.prepareEnvStash(tmpDir, helper.getProcessExtraEnv(), null, envName);
            RemoteRunEnvDef envResource = new RemoteRunEnvDef();
            envResource.runsRemotely = false;
            envResource.jobId = SecretKeyGenerator.generate((int)8);
            envResource.jobExecEnv = helper.getJobExecEnv();
            stash.env.put("DKU_BACKEND_HOST", RemoteRunNetworkingUtils.getBackendHost());
            stash.env.put("DKU_BACKEND_PORT", System.getenv("DKU_BACKEND_PORT"));
            stash.env.put("DKU_BASE_PORT", RemoteRunNetworkingUtils.getBasePort());
            stash.env.put("DKU_BASE_PROTOCOL", RemoteRunNetworkingUtils.getBaseProtocol());
            stash.env.put("DKU_SERVER_HOST", RemoteRunNetworkingUtils.getServerHost());
            stash.env.put("DKU_SERVER_PORT", String.valueOf(RemoteRunNetworkingUtils.getServerPort()));
            stash.env.put("DKU_SERVER_KIND", String.valueOf(RemoteRunNetworkingUtils.getServerKind()));
            stash.copyToRemoteRunEnvDef(envResource, false, true, false);
            logger.info((Object)"Store env def in local file for executions via sparklyr");
            FileUtils.write((File)new File(tmpDir, "remote-run-env-def.json"), (CharSequence)JSON.json((Object)envResource));
            logger.info((Object)("Execute activity command: " + JSON.log(cmd)));
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(tmpDir);
            builder.environment().putAll(stash.getAsEnvVariables(true, true, false));
            builder.command(cmd);
            this.execute(builder, targetLogFile, wrapperContent, "R", null, false);
        }
        finally {
            helper.close();
        }
    }

    private void runUsingSparkR(String envName) throws IOException, Exception {
        final CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
        ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).setupSparkRCmd(envName, this.projectKey, executionEnv);
        this.runSparkR("SparkR", envName, this.params.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File tmpScriptData = new File(runDir, "recipe.R");
                FileUtils.writeStringToFile((File)tmpScriptData, (String)SparkRRecipeRunner.this.code);
                File wrapperFile = SparkRRecipeRunner.this.prepareWrapper(runDir);
                T job = helper.makeRJob("DSS (R): " + SparkRRecipeRunner.this.activity.id(), effectiveConf, wrapperFile.getAbsolutePath(), tmpScriptData.getAbsolutePath());
                ((SparkJob)job).secretDriverFiles.add(tmpScriptData.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return SparkRRecipeRunner.this.params.sparkConfig;
            }

            @Override
            public Map<String, String> getContextOverrideConf() {
                return executionEnv.sparkConf;
            }
        }, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_SPARK_RECIPE);
    }
}

