/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.consistency;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.consistency.RecipeConsistencyCheckRequest;
import com.dataiku.dip.recipes.consistency.RecipeSchemaConsistencyChecker;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RecipeConsistencyCheckRunner {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private TransactionService transactionService;

    public RecipeConsistencyCheckRunner() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public GenericRecipesValidationService.RecipeValidationResult checkWithFlow_NT(AuthCtx authCtx, FlowRecipe fr, RecipeConsistencyCheckRequest request) throws Exception {
        SerializedRecipe sr = fr.getModel();
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr);
        GenericRecipesValidationService.RecipeValidationResult recipeCheckResult = new GenericRecipesValidationService.RecipeValidationResult();
        String payload = null;
        try (Transaction t = this.transactionService.beginRead();){
            payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name);
        }
        if (request.otherExpensiveChecks) {
            sc = recipeMeta.buildStatusComputer(sr, payload);
            RecipeStatus status = sc.getFullStatus_NT(authCtx, "");
            recipeCheckResult.mergeFrom(status.gatherAllMessages());
        } else {
            sc = recipeMeta.buildStatusComputer(sr, payload);
            try (Transaction t = this.transactionService.beginRead();){
                RecipeStatus status = sc.fastStatusIgnorePartitions(authCtx);
                recipeCheckResult.mergeFrom(status.gatherAllMessages());
            }
        }
        if (request.schemaConsistency) {
            RecipeSchemaConsistencyChecker schemaChecker = new RecipeSchemaConsistencyChecker();
            try {
                RecipeSchemaService.RecipeSchemaAutoupdateResult schemaUpdateResult = schemaChecker.checkRecipe(authCtx, fr, true);
                for (RecipeSchemaService.ComputableSchemaAutoupdateResult dr : schemaUpdateResult.computables) {
                    for (String message : dr.incompatibilities) {
                        recipeCheckResult.withFatal(RecipeCodes.ERR_RECIPE_INCOMPATIBLE_SCHEMA, message);
                    }
                }
            }
            catch (RecipeSchemaComputer.DontWantToCompute e) {
                if (e.getCode() != RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_ON_RECIPE_TYPE) {
                    recipeCheckResult.withWarning(e.getCode(), e.getMessage());
                }
            }
            catch (Exception e) {
                recipeCheckResult.withFatal(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY, "Failed to check schema consistency: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        recipeCheckResult.removeCode(RecipeCodes.WARN_RECIPE_CODE_NOT_CHECKED);
        return recipeCheckResult;
    }
}

