/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParamsWithAlternativeHypothesis;
import com.dataiku.dip.recipes.eda.stats.OneSampleTTestStat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class OneSampleTTestRecipePayloadParams
extends StatsTestRecipePayloadParams<OneSampleTTestStat>
implements StatsTestRecipePayloadParamsWithAlternativeHypothesis {
    public static final String TYPE = "recipe_one-sample-t-test";
    public AlternativeHypothesis[] alternatives = new AlternativeHypothesis[]{AlternativeHypothesis.TWO_SIDED};

    @Override
    public String getType() {
        return TYPE;
    }

    public OneSampleTTestRecipePayloadParams(OneSampleTTestStat stat, AlternativeHypothesis alternative, double confidenceLevel, @Nullable SplitBySpec splitBy) {
        super(stat, confidenceLevel, splitBy);
        this.alternatives = new AlternativeHypothesis[]{alternative};
    }

    public OneSampleTTestRecipePayloadParams() {
    }

    @Override
    public List<SchemaColumn> getSchemaColumns() {
        boolean containsZTest = this.stats.stream().anyMatch(s -> s.knownStdDev != null);
        ArrayList<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        columns.add(new SchemaColumn("variable", Type.STRING));
        columns.add(new SchemaColumn("hypothesized_mean", Type.DOUBLE));
        if (containsZTest) {
            columns.add(new SchemaColumn("known_std_dev", Type.DOUBLE));
        }
        columns.add(new SchemaColumn("sample_statistics", Type.STRING));
        columns.add(new SchemaColumn("sample_mean_confidence_interval", Type.STRING));
        columns.add(new SchemaColumn("t_statistic", Type.DOUBLE));
        if (containsZTest) {
            columns.add(new SchemaColumn("z_statistic", Type.DOUBLE));
        }
        columns.add(new SchemaColumn("degrees_of_freedom", Type.INT));
        columns.add(new SchemaColumn("significance_level", Type.DOUBLE));
        columns.add(new SchemaColumn("p_value", Type.DOUBLE));
        columns.add(new SchemaColumn("conclusion", Type.STRING));
        return columns;
    }

    @Override
    public AlternativeHypothesis[] getAlternatives() {
        return this.alternatives;
    }
}

