/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.evaluation.agent;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.nlp.evaluation.AbstractGenAIEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationRecipeParams;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationUtils;
import com.dataiku.dip.recipes.nlp.evaluation.agent.AgentEvaluationRecipeCreator;
import com.dataiku.dip.recipes.nlp.evaluation.agent.AgentEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.evaluation.agent.AgentEvaluationRecipeRunner;
import com.dataiku.dip.recipes.nlp.evaluation.agent.AgentEvaluationRecipeSchemaComputer;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AgentEvaluationRecipeMeta
extends RecipeMeta
implements MetaWithSelectableCodeEnv {
    public static final AgentEvaluationRecipeMeta META = new AgentEvaluationRecipeMeta();

    @Override
    public String getType() {
        return "nlp_agent_evaluation";
    }

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return GenAIEvaluationRecipeParams.class;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new AgentEvaluationRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) throws Exception {
        return new AgentEvaluationRecipeRunner(activity);
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new AgentEvaluationRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) throws Exception {
        return RecipeMeta.defaultStatusComputer("DSS", "DSS", "MEMORY", "In-memory", "DSS");
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = new RecipeDesc("Agent Evaluation", null);
        desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredDataset("main", "Evaluation Dataset"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("main", "Output Dataset"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("metrics", "Metrics"));
        RecipeDesc.IORoleDef aes = RecipeDesc.IORoleDef.newUnaryAgentEvaluationStore("evaluationStore", "Agent Evaluation Store");
        desc.outputRoles.add(aes);
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withNlp();
    }

    protected AgentEvaluationRecipePayloadParams loadPayload(String payload) {
        return (AgentEvaluationRecipePayloadParams)JSON.parse((String)payload, AgentEvaluationRecipePayloadParams.class);
    }

    @Override
    public String preparePayloadForSave(String payload) throws ParseException {
        AgentEvaluationRecipePayloadParams payloadParams = this.loadPayload(payload);
        if (payloadParams.inputFormat != AbstractGenAIEvaluationRecipePayloadParams.GenAiEvalInputFormat.PROMPT_RECIPE) {
            return JSON.pretty((Object)new JSONParser().parse(payload));
        }
        payloadParams.inputColumnName = PromptRecipeSchemaComputer.PromptRecipeColumn.LLM_RAW_QUERY.name;
        payloadParams.outputColumnName = PromptRecipeSchemaComputer.PromptRecipeColumn.LLM_RAW_OUTPUT.name;
        payloadParams.actualToolCallsColumnName = PromptRecipeSchemaComputer.PromptRecipeColumn.LLM_RAW_OUTPUT.name;
        return JSON.pretty((Object)payloadParams);
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        HashSet<String> ret = new HashSet<String>();
        AgentEvaluationRecipePayloadParams params = this.loadPayload(payload);
        GenAIEvaluationUtils.getLLMConnection(params.completionLLMId).ifPresent(ret::add);
        GenAIEvaluationUtils.getLLMConnection(params.embeddingLLMId).ifPresent(ret::add);
        return ret;
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, String payload, Map<String, String> replacements) {
        AgentEvaluationRecipePayloadParams params = this.loadPayload(payload);
        params.completionLLMId = GenAIEvaluationUtils.remapConnectionOfLLMId(params.completionLLMId, replacements);
        params.embeddingLLMId = GenAIEvaluationUtils.remapConnectionOfLLMId(params.embeddingLLMId, replacements);
        return params;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }
}

