/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.ShakerRecipePipelineHelper;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnvContainerPayload;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.shaker.ShakerRecipeCreator;
import com.dataiku.dip.recipes.shaker.ShakerRecipeHiveRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeImpalaRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.recipes.shaker.ShakerRecipeRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeSQLRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeSchemaComputer;
import com.dataiku.dip.recipes.shaker.ShakerRecipeStatusComputer;
import com.dataiku.dip.recipes.shaker.ShakerSparkRecipeRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.mrimpl.ShakerMRRecipeRunner;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShakerRecipeMeta
extends RecipeMeta
implements MetaWithSelectableCodeEnvContainerPayload,
IPluginifiedHolderMeta {
    public static final ShakerRecipeMeta META;
    private static final DKULogger logger;

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return ShakerRecipeParams.class;
    }

    @Override
    public String getType() {
        return "shaker";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) throws Exception {
        RecipeRunnableSubgraph rsubgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        FlowRecipe recipe = rsubgraph.getRecipe();
        ShakerRecipeParams params = (ShakerRecipeParams)recipe.getModel().params;
        if (params == null) {
            params = new ShakerRecipeParams();
        }
        String payload = ((RecipesDAO)SpringUtils.getBean(RecipesDAO.class)).getPayloadOrNull(recipe.getProjectKey(), recipe.getName());
        ShakerRecipeStatusComputer statusComputer = new ShakerRecipeStatusComputer(recipe.getModel(), payload);
        RecipeEngineStatus engine = statusComputer.selectEngine(((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx(), params.engineType, activity);
        logger.infoV("User-selected engine: %s - used engine: %s", new Object[]{params.engineType, engine.type});
        if (!engine.isSelectable) {
            throw ErrorContext.iae((String)(engine.label + " cannot be used as engine for this recipe. " + engine.statusMessage));
        }
        LicenseStatusService licenseStatusService = (LicenseStatusService)SpringUtils.getBean(LicenseStatusService.class);
        boolean isCE = licenseStatusService.getLicensingStatus().community;
        JobContext.getCurrentActivitySummary().engineType = engine.type;
        switch (engine.type) {
            case "SPARK": {
                if (isCE) {
                    throw new SecurityException("Running on Spark is not supported on DSS Free Edition");
                }
                return new ShakerSparkRecipeRunner(activity, params);
            }
            case "HADOOP_MAPREDUCE": {
                if (isCE) {
                    throw new SecurityException("Running on Hadoop is not supported on DSS Free Edition");
                }
                activity.warnContext.addWarning(WarningsContext.WarningType.ENGINE_DEPRECATED, "MR engine is deprecated for the Prepare recipe", logger);
                return new ShakerMRRecipeRunner(activity);
            }
            case "DSS": {
                return new ShakerRecipeRunner(activity);
            }
            case "SQL": {
                return new ShakerRecipeSQLRunner(activity);
            }
            case "HIVE": {
                return new ShakerRecipeHiveRunner(activity);
            }
            case "IMPALA": {
                return new ShakerRecipeImpalaRunner(activity);
            }
        }
        throw new Error();
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_DYNAMIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new ShakerRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new ShakerRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new ShakerRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc desc = RecipeDesc.newSisoDesc(ts.translateNoContext(lang, "RECIPE.SHAKER.NAME", "data preparation", new Object[0]), null);
        desc.inputRoles.get((int)0).saveAndReloadAfterEditInEditor = true;
        RecipeDesc.IORoleDef secondaryRole = new RecipeDesc.IORoleDef("scriptDeps", ts.translateNoContext(lang, "RECIPE.SHAKER.DESC.JOINED_DATASETS", "Joined datasets", new Object[0])).withEditable(false, false);
        secondaryRole.arity = RecipeDesc.IOArity.NARY;
        secondaryRole.description = ts.translateNoContext(lang, "RECIPE.SHAKER.DESC.JOINED_DATASETS.HELP", "These inputs are automatically added by 'join' steps.\nEdit the recipe to change them.", new Object[0]);
        desc.inputRoles.add(secondaryRole);
        RecipeDesc.IORoleDef replacementsRole = new RecipeDesc.IORoleDef("reference", ts.translateNoContext(lang, "RECIPE.SHAKER.DESC.REFERENCE_DATASETS", "Reference datasets", new Object[0])).withEditable(false, false);
        replacementsRole.arity = RecipeDesc.IOArity.NARY;
        replacementsRole.description = ts.translateNoContext(lang, "RECIPE.SHAKER.DESC.REFERENCE_DATASETS.HELP", "These inputs are automatically added by 'Find and replace' steps.\nEdit the recipe to change them.", new Object[0]);
        desc.inputRoles.add(replacementsRole);
        desc.isMultiEngine = true;
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        return params.engineParams.spark.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        params.engineParams.spark.sparkConfig = config;
        return payload;
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        params.engineType = engine;
        return payload;
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return payload;
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        params.engineParams.spark.executionEngine = executionEngine;
        return payload;
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return sr.getParamsAs(ShakerRecipeParams.class).engineParams.spark.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        ShakerRecipeParams params = sr.getParamsAs(ShakerRecipeParams.class);
        params.engineParams.spark.readParams = inputDatasetsReadParams;
        return payload;
    }

    @Override
    public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
        ArrayList components = Lists.newArrayList();
        if (sss != null) {
            for (ProcessorScriptStep processor : AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(sss)) {
                components.add(new IPluginifiedHolderMeta.Pluginifiable("processor", processor.type, processor));
            }
        }
        return components;
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new ShakerRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
        if (predecessors.datasetsByFullName.isEmpty() || successors.datasetsByFullName.isEmpty()) {
            return new RecipeLineage();
        }
        SerializedShakerScript script = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
        Preconditions.checkArgument((predecessors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Prepare recipe can have only one input dataset");
        Preconditions.checkArgument((successors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Prepare recipe can have only one output dataset");
        SerializedDataset inputDataset = predecessors.datasetsByFullName.values().stream().findFirst().get();
        SerializedDataset outputDataset = successors.datasetsByFullName.values().stream().findFirst().get();
        DatasetPairLineage datasetPairLineage = new DatasetPairLineage(inputDataset.getFullName(), inputDataset.getSchema(), outputDataset.getFullName(), outputDataset.getSchema());
        datasetPairLineage.initializeDirectColumnRelations();
        RecipeLineage recipeLineage = new RecipeLineage(inputDataset.getFullName(), outputDataset.getFullName(), datasetPairLineage);
        try {
            recipeLineage = this.getRecipeLineageFromSteps(script.steps, recipeLineage);
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Failed to get columns relations for prepare recipe: " + e.getMessage());
        }
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }

    public RecipeLineage getRecipeLineageFromSteps(List<ScriptStep> steps, RecipeLineage recipeLineage) {
        for (ScriptStep step : steps) {
            List<ProcessorScriptStep> processorScriptSteps;
            if (step.metaType.equals((Object)ScriptStep.MetaType.GROUP)) {
                GroupScriptStep gss = (GroupScriptStep)step;
                processorScriptSteps = gss.steps;
            } else if (step.metaType.equals((Object)ScriptStep.MetaType.PROCESSOR)) {
                ProcessorScriptStep pss = (ProcessorScriptStep)step;
                processorScriptSteps = Collections.singletonList(pss);
            } else {
                processorScriptSteps = Collections.emptyList();
            }
            for (ProcessorScriptStep pss : processorScriptSteps) {
                if (pss.disabled) continue;
                boolean isUncertain = recipeLineage.isUncertain();
                recipeLineage.setUncertain((recipeLineage = pss.getUpdatedRecipeLineage(recipeLineage)).isUncertain() || isUncertain);
            }
        }
        return recipeLineage;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    @Override
    public Class<? extends SelectableCodeEnvContainer> getCodeEnvBearingParamsClass() {
        return SerializedShakerScript.class;
    }

    static {
        ScriptStep.loadClass();
        META = new ShakerRecipeMeta();
        logger = DKULogger.getLogger((String)"dku.recipes.shaker");
    }
}

