/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.ExceptionWithDebuggingHint;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class RMarkdownReportRunner {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    private final Report report;
    private final String script;
    private final Report.ReportOutputFormat format;
    private final File outputFile;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.reports.builder");

    public RMarkdownReportRunner(Report report, String script, Report.ReportOutputFormat format, File outputFile, AuthCtx authCtx) {
        SpringUtils.getInstance().autowire((Object)this);
        this.report = report;
        this.script = script;
        this.format = format;
        this.outputFile = outputFile;
        this.authCtx = authCtx;
    }

    /*
     * Loose catch block
     */
    public ReportBuildResponse build(DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"code-reports-build", (String)"report-");){
            File scriptFile = this.writeScriptFile((File)tmpDir);
            File outputTmpFile = new File((File)tmpDir, "built-report." + this.format.getExtension());
            logger.infoV("Start RMarkdown build tmpDir=%s scriptFile=%s outputTmp=%s outputFile=%s", new Object[]{tmpDir, scriptFile, outputTmpFile, this.outputFile});
            ProcessBuilder builder = new ProcessBuilder(this.getRCmd(scriptFile, (File)tmpDir, outputTmpFile));
            APITicketService.Ticket ticket = this.apiTicketService.createTicket(this.authCtx, "RMarkdown report builder: " + this.report.getFullId(), null);
            builder.environment().put("DKU_API_TICKET", ticket.getSecret());
            builder.environment().put("DKU_CURRENT_PROJECT_KEY", this.report.projectKey);
            DKUtils.ExecOutputConsumer outputConsumer = new DKUtils.ExecOutputConsumer().withThreadsBaseName("report-build-" + this.report.id);
            outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
            outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder));
            outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
            outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder));
            ReportBuildResponse ret = new ReportBuildResponse();
            try {
                final IsolableProcess process = this.insecureProcessesLaunchService.launch(this.authCtx, this.report.projectKey, GeneralSettingsDAO.CGrouppableProcessType.RMARKDOWN_BUILDER, (File)tmpDir, builder);
                try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            process.niceThenEvilKill();
                        }
                        catch (IOException e) {
                            logger.error((Object)"Failed to stop report build", (Throwable)e);
                        }
                    }
                });){
                    outputConsumer.start(process.getInputStream(), process.getErrorStream(), process.getOutputStream());
                    int rv = process.waitFor();
                    logger.info((Object)("Process done with code " + rv));
                    outputConsumer.finish();
                    if (rv != 0) {
                        throw new ProcessDiedException("RMarkdown build process failed (return code " + rv + ")", smartLogTailBuilder.get(), ExceptionWithDebuggingHint.DebuggingHint.CHECK_JOB_LOG, rv);
                    }
                    DKUFileUtils.mkdirsParent((File)this.outputFile);
                    FileUtils.copyFile((File)outputTmpFile, (File)this.outputFile);
                }
                ReportBuildResponse reportBuildResponse = ret;
                return reportBuildResponse;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to build RMarkdown report", (Throwable)e);
                throw e;
            }
            finally {
                this.apiTicketService.expireTicket(ticket);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private File writeScriptFile(File tmpDir) throws IOException {
        File scriptFile = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{this.report.id + ".Rmd"});
        Map variables = this.variablesService.getForProject(this.report.projectKey).getAllVariables();
        String expanded = StrSubstitutor.replace((Object)this.script, (Map)variables);
        FileUtils.write((File)scriptFile, (CharSequence)expanded, (String)"utf8");
        return scriptFile;
    }

    private List<String> getRCmd(File scriptFile, File tmpDir, File outputFile) throws IOException {
        String envName = new CodeEnvSelector().selectForRRecipe(this.report.getProjectKey(), this.report.params.getCodeEnvSelection());
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-e");
        cmd.add("rmarkdown::render('" + scriptFile.getAbsolutePath().replace('\\', '/') + "', output_file = '" + outputFile.getAbsolutePath().replace('\\', '/') + "', intermediates_dir = '" + tmpDir.getAbsolutePath().replace('\\', '/') + "', output_format = '" + this.format.name + "')");
        return ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getRCmd(envName, this.report.getProjectKey(), cmd);
    }

    public static class ReportBuildResponse {
    }
}

