/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.JupyterExportService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateJupyterExportStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CreateJupyterExportStepParams.class;
        }

        @Override
        public String getType() {
            return "create_jupyter_export";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CreateJupyterExportStepRunner(scenario, step, step.getParamsAs(CreateJupyterExportStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            CreateJupyterExportStepParams params = step.getParamsAs(CreateJupyterExportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("export");
            if (params != null) {
                sb.append(" ");
                sb.append(params.notebookId);
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            CreateJupyterExportStepParams params = step.getParamsAs(CreateJupyterExportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("create_jupyter_export");
            if (params != null) {
                sb.append("_");
                sb.append(params.executeNotebook);
                sb.append("_");
                sb.append(params.notebookId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final CreateJupyterExportStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private JupyterExportService jupyterExportService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.refreshinsight");

    CreateJupyterExportStepRunner(Scenario scenario, Step step, CreateJupyterExportStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        if (!StringUtils.isBlank((String)this.params.notebookId)) {
            ReportItem.CreatedJupyterExport reportItem = (ReportItem.CreatedJupyterExport)new ReportItem.CreatedJupyterExport(new ReportTargetItem.JupyterNotebookItem(projectKey, this.params.notebookId)).withStart(System.currentTimeMillis());
            reportItem = reportItem.withExecutedNotebook(this.params.executeNotebook);
            try {
                logger.info((Object)("Start insight refresh" + (this.params.executeNotebook ? " with notebook execution" : "")));
                this.jupyterExportService.create_NT(stepRun.getScenarioRun().getRunAsUser(), projectKey, this.params.notebookId, this.params.executeNotebook, this.params.cellTimeout);
                logger.info((Object)"Refresh done");
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
            catch (JupyterExportService.PythonExecutionException ex) {
                SmartLogTail smartLogTail = new SmartLogTail();
                smartLogTail.lines.addAll(Arrays.asList(ex.getErrorLog().split("\n")));
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withLogTail(smartLogTail);
            }
            catch (InterruptedException iex) {
                throw iex;
            }
            catch (Throwable ex) {
                logger.error((Object)"Failed to export notebook", ex);
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(ex);
            }
            finally {
                this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, this.params.notebookId), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
            }
            stepReportItem.withOutcome(reportItem.getOutcome());
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class CreateJupyterExportStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String notebookId;
        public int cellTimeout = 0;
        public boolean executeNotebook;

        public CreateJupyterExportStepParams withNotebookId(String notebookId) {
            this.notebookId = notebookId;
            return this;
        }

        public CreateJupyterExportStepParams withExecuteNotebook(boolean executeNotebook) {
            this.executeNotebook = executeNotebook;
            return this;
        }
    }
}

