/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.scheduler.model.FlowItemsToCompare;
import com.dataiku.dip.scheduler.model.FlowItemsToSwap;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.steps.AbstractFlowItemBuildingStepRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.scheduler.utils.FlowTestUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FlowTestStepRunner
extends AbstractFlowItemBuildingStepRunner<FlowTestStepParams> {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "flow_test";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return FlowTestStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new FlowTestStepRunner(scenario, step, step.getParamsAs(FlowTestStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            FlowTestStepParams stepParams = step.getParamsAs(FlowTestStepParams.class);
            if (stepParams == null) {
                return "Flow Test";
            }
            StringBuilder sb = new StringBuilder("Flow Test: ");
            sb.append("Build: ");
            stepParams.getBuilds().forEach(build -> sb.append(String.format(" %s", build.getItemName())));
            sb.append(" Swap:");
            stepParams.getSwaps().stream().filter(swap -> swap.sourceSmartName != null && swap.targetSmartName != null).findFirst().ifPresent(swap -> sb.append(String.format(" (%s, %s)", swap.sourceSmartName, swap.targetSmartName)));
            sb.append(" Compare:");
            stepParams.getCompares().stream().filter(comparison -> comparison.resultSmartName != null && comparison.expectedSmartName != null).findFirst().ifPresent(comparison -> sb.append(String.format("(%s, %s)", comparison.resultSmartName, comparison.expectedSmartName)));
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            FlowTestStepParams stepParams = step.getParamsAs(FlowTestStepParams.class);
            if (stepParams == null) {
                return META.getType();
            }
            StringBuilder sb = new StringBuilder(String.format("%s__", META.getType()));
            sb.append("build_");
            stepParams.getBuilds().stream().findFirst().ifPresent(build -> sb.append(String.format("_%s", build.getPartitionInvariantId())));
            sb.append("__swap");
            stepParams.getSwaps().stream().filter(swap -> swap.sourceSmartName != null && swap.targetSmartName != null).findFirst().ifPresent(swap -> sb.append(String.format("_(%s,%s)", swap.sourceSmartName, swap.targetSmartName)));
            sb.append("__compare");
            stepParams.getCompares().stream().filter(comparison -> comparison.resultSmartName != null && comparison.expectedSmartName != null).findFirst().ifPresent(comparison -> sb.append(String.format("_(%s,%s)", comparison.resultSmartName, comparison.expectedSmartName)));
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            FlowTestStepParams stepParams = step.getParamsAs(FlowTestStepParams.class);
            if (stepParams != null && stepParams.builds != null) {
                return StepMeta.UnavailableStepInfo.checkFlowComputableSpecs(scenario, step, pluginUsagesInspector, stepParams.builds, logger);
            }
            return null;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.flowTestStepRunner");

    public FlowTestStepRunner(Scenario scenario, Step step, FlowTestStepParams params) {
        super(scenario, step, params);
    }

    protected void assertValidParams(AuthCtx authCtx) throws IOException {
        Preconditions.checkArgument((!((FlowTestStepParams)this.params).getBuilds().isEmpty() ? 1 : 0) != 0, (Object)"No builds specified");
        String contextProjectKey = this.scenario.getProjectKey();
        ((FlowTestStepParams)this.params).getBuilds().forEach(build -> this.validateBuildSpec(contextProjectKey, (FlowComputableSpecification)build));
        FlowTestUtils.validateSwapParams(((FlowTestStepParams)this.params).getSwaps(), contextProjectKey);
        this.checkSourcesInBuilds(contextProjectKey);
        FlowTestUtils.assertValidCompareParams(authCtx, ((FlowTestStepParams)this.params).getCompares(), contextProjectKey);
    }

    private void validateBuildSpec(String contextProjectKey, FlowComputableSpecification spec) {
        SmartObjectRef ref = SmartObjectRef.fromResolved(spec.type.toTaggableType(), spec.projectKey, spec.itemId, contextProjectKey);
        if (ref.isForeign()) {
            throw new IllegalArgumentException("All build targets for the Flow Test step must belong to the same project as the scenario");
        }
    }

    private void checkSourcesInBuilds(String contextProjectKey) {
        List buildSmartNames = ((FlowTestStepParams)this.params).getBuilds().stream().map(d -> this.getSpecSmartName((FlowComputableSpecification)d, contextProjectKey)).collect(Collectors.toList());
        List sourceSmartNames = ((FlowTestStepParams)this.params).getSwaps().stream().map(d -> d.sourceSmartName).collect(Collectors.toList());
        Set intersectionSet = sourceSmartNames.stream().distinct().filter(buildSmartNames::contains).collect(Collectors.toSet());
        if (!intersectionSet.isEmpty()) {
            logger.warnV("The following build targets: %s are also swap sources. This may lead to unexpected behaviour", new Object[]{String.join((CharSequence)", ", intersectionSet)});
        }
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        AbstractFlowItemBuildingStepRunner.BuildJobInfo buildJobInfo;
        logger.infoV("Start step %s", new Object[]{this.step.getName()});
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        DSSAuthCtx authCtx = scenarioRun.getRunAsUser();
        String contextProjectKey = scenarioRun.getScenario().getProjectKey();
        this.assertValidParams(authCtx);
        logger.infoV("Will swap %d flow items with their target mapping", new Object[]{((FlowTestStepParams)this.params).getSwaps().size()});
        Map<SerializedRecipe, List<FlowItemsToSwap>> toSwapBack = FlowTestUtils.swapInputDatasets(authCtx, ((FlowTestStepParams)this.params).getSwaps(), stepRun, contextProjectKey);
        try {
            JobDef buildJobDef = this.buildJobDef(stepRun);
            buildJobInfo = this.runBuildJob(buildJobDef);
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Error while building target elements in step %s, reverting to initial state", new Object[]{this.step.getName()});
            FlowTestUtils.restoreInitialState(authCtx, stepRun, toSwapBack);
            throw e;
        }
        ReportItem.JobExecuted jobItem = buildJobInfo.jobItem;
        stepReportItem = this.updateStepReportItemWithJobResult(stepReportItem, jobItem);
        if (ImmutableList.of((Object)((Object)ReportItem.Outcome.FAILED), (Object)((Object)ReportItem.Outcome.ABORTED)).contains((Object)jobItem.getOutcome())) {
            logger.warnV("Build job gave outcome %s, reverting to initial state", new Object[]{jobItem.getOutcome()});
            FlowTestUtils.restoreInitialState(authCtx, stepRun, toSwapBack);
            return;
        }
        EnhancedSerializedJobStatus sjs = buildJobInfo.jobStatus;
        stepRun.payload = this.getSafeJobStatus(sjs);
        try {
            FlowTestUtils.compareDatasets(authCtx, ((FlowTestStepParams)this.params).getCompares(), contextProjectKey, stepReportItem, stepRun);
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Exception e) {
            FlowTestUtils.restoreInitialState(authCtx, stepRun, toSwapBack);
            throw e;
        }
        logger.infoV("Completed dataset comparisons, restoring initial state", new Object[0]);
        FlowTestUtils.restoreInitialState(authCtx, stepRun, toSwapBack);
        logger.infoV("End step %s", new Object[]{this.step.getName()});
        if (Objects.isNull((Object)stepReportItem.getOutcome())) {
            throw new IllegalStateException("Step outcome is null");
        }
    }

    private String getSpecSmartName(FlowComputableSpecification spec, String contextProjectKey) {
        return spec.getLoc(contextProjectKey).getSmartName(contextProjectKey);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    public static class FlowTestStepParams
    extends AbstractFlowItemBuildingStepRunner.FlowItemBuildingStepParams {
        private final List<FlowItemsToSwap> swaps = Lists.newArrayList();
        private final List<FlowItemsToCompare> compares = Lists.newArrayList();

        @Nonnull
        public List<FlowItemsToSwap> getSwaps() {
            return this.swaps;
        }

        @Nonnull
        public List<FlowItemsToCompare> getCompares() {
            return this.compares;
        }

        public static class Builder
        extends AbstractFlowItemBuildingStepRunner.FlowItemBuildingStepParams.Builder<FlowTestStepParams> {
            @Override
            protected FlowTestStepParams instantiateParams() {
                return new FlowTestStepParams();
            }

            @Override
            public FlowTestStepParams build() {
                return (FlowTestStepParams)this.params;
            }
        }
    }
}

