/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.objectweb.asm.ClassReader;
import com.dataiku.dss.shadelib.org.objectweb.asm.ClassVisitor;
import com.dataiku.dss.shadelib.org.objectweb.asm.ClassWriter;
import com.dataiku.dss.shadelib.org.objectweb.asm.commons.ClassRemapper;
import com.dataiku.dss.shadelib.org.objectweb.asm.commons.Remapper;
import com.dataiku.dss.shadelib.org.objectweb.asm.commons.SimpleRemapper;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.generated.BPClassificationTemplate;
import com.dataiku.scoring.generated.MPClassificationTemplate;
import com.dataiku.scoring.generated.NPClassificationTemplate;
import com.dataiku.scoring.generated.RegressionTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JarScoring
implements ScoringExporter.ScoringWriter {
    public static final String CONTENT_TYPE = "application/java-archive";
    public static final Pattern FULLY_QUALIFIED_CLASS_NAME = Pattern.compile("^((?:[a-z]\\w*+\\.)++)?([A-Z]\\w*+)$");
    private final boolean includeLibs;
    private final FullModelId fullModelId;
    private final String fullClassName;

    public JarScoring() {
        this.includeLibs = false;
        this.fullModelId = null;
        this.fullClassName = null;
    }

    public JarScoring(boolean includeLibs, FullModelId fullModelId, String fullClassName) {
        this.includeLibs = includeLibs;
        this.fullModelId = fullModelId;
        this.fullClassName = fullClassName;
    }

    @Override
    public CompatibilityWithReason getCompatibility() throws IOException {
        if (this.fullModelId == null) {
            return CompatibilityWithReason.ok();
        }
        return PredictionResultsReader.makeDetails((FullModelId)this.fullModelId).javaExportCompatibility;
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    public static String makeJarName(FullModelId fmi, boolean fat) throws IOException {
        return "dataiku-model-" + PathUtils.slugify((String)fmi.getHeadMLTask().name) + (fat ? "-assembly" : "") + ".jar";
    }

    public static String makeLibJarName() {
        return PathUtils.slugify((String)("dataiku-scoring-libs_" + ApplicationConfigurator.getDSSVersion().product_version)) + ".jar";
    }

    @Override
    public void writeTo(OutputStream os) throws Exception {
        if (this.fullModelId == null) {
            this.makeLibJar(os);
        } else if (this.includeLibs) {
            this.makeFatJar(os);
        } else {
            this.makeThinJar(os);
        }
    }

    private void makeThinJar(OutputStream out) throws IOException, CodedException {
        JarOutputStream jar = (JarOutputStream)this.makeScoringJar((OutputStream)out).first;
        jar.flush();
        jar.close();
    }

    private void makeFatJar(OutputStream out) throws IOException, CodedException {
        Pair<JarOutputStream, Set<String>> pair = this.makeScoringJar(out);
        JarOutputStream jar = (JarOutputStream)pair.first;
        HashSet<String> entries = new HashSet<String>((Collection)pair.second);
        JarScoring.mergeLibJars(jar, entries);
        jar.flush();
        jar.close();
    }

    private void makeLibJar(OutputStream out) throws IOException {
        JarOutputStream jar = new JarOutputStream(out);
        HashSet<String> entries = new HashSet<String>();
        JarScoring.mergeLibJars(jar, entries);
        jar.flush();
        jar.close();
    }

    @Override
    public String makeFileName() throws IOException {
        return this.fullModelId == null ? JarScoring.makeLibJarName() : JarScoring.makeJarName(this.fullModelId, this.includeLibs);
    }

    private static void mergeLibJars(JarOutputStream jar, Set<String> entries) throws IOException {
        JarScoring.mergeJar(new File(ApplicationConfigurator.getInstallFolder(), "dist/dataiku-scoring.jar"), jar, entries, new String[0]);
        JarScoring.mergeJar(new File(ApplicationConfigurator.getInstallFolder(), "lib/shadelib/dss-shadelib-assembly.jar"), jar, entries, "com/dataiku/dss/shadelib/com/google/gson/", "com/dataiku/dss/shadelib/org/joda/time/");
    }

    private static void mergeJar(File from, JarOutputStream into, Set<String> entries, String ... allowedPrefixes) throws IOException {
        try (JarFile in = new JarFile(from);){
            Enumeration<JarEntry> inEntries = in.entries();
            while (inEntries.hasMoreElements()) {
                JarEntry entry = inEntries.nextElement();
                if (allowedPrefixes.length > 0) {
                    boolean allowed = false;
                    for (String prefix : allowedPrefixes) {
                        if (!entry.getName().startsWith(prefix)) continue;
                        allowed = true;
                        break;
                    }
                    if (!allowed) continue;
                }
                if (!entries.add(entry.getName())) continue;
                into.putNextEntry(new JarEntry(entry));
                IOUtils.copy((InputStream)in.getInputStream(entry), (OutputStream)into);
                into.flush();
                into.closeEntry();
            }
        }
    }

    private Pair<JarOutputStream, Set<String>> makeScoringJar(OutputStream out) throws IOException, CodedException {
        Object packagePath;
        boolean isAnalysisModel;
        boolean bl = isAnalysisModel = this.fullModelId.type == FullModelId.Type.ANALYSIS;
        if (isAnalysisModel) {
            PredictionSMMgmtService.fillPipelineMeta(this.fullModelId);
        }
        if (!this.fullModelId.getModelFile("dss_pipeline_meta.json").isFile()) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INCOMPATIBLE_MODEL_ENGINE, "Model meta file does not exist, model is probably not Java-compatible");
        }
        File resources = this.fullModelId.getModelFolder();
        byte[] scoringClass = JarScoring.makeScoringClass(this.fullClassName, resources);
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.fullClassName);
        JarOutputStream jar = new JarOutputStream(out, manifest);
        HashSet<String> entries = new HashSet<String>();
        entries.add("META-INF/");
        entries.add("META-INF/MANIFEST.MF");
        Pair<String, String> packageAndClass = JarScoring.splitPackageClass(this.fullClassName);
        String packageName = (String)packageAndClass.first;
        String className = (String)packageAndClass.second;
        if (packageName == null) {
            packagePath = "";
        } else {
            packagePath = packageName.replace('.', '/') + "/";
            int pos = ((String)packagePath).indexOf(47);
            while (pos != -1) {
                JarEntry packageEntry = new JarEntry(((String)packagePath).substring(0, pos + 1));
                packageEntry.setTime(resources.lastModified());
                jar.putNextEntry(packageEntry);
                jar.flush();
                jar.closeEntry();
                entries.add(packageEntry.getName());
                pos = ((String)packagePath).indexOf(47, pos + 1);
            }
        }
        JarEntry clazz = new JarEntry((String)packagePath + className + ".class");
        clazz.setTime(resources.lastModified());
        jar.putNextEntry(clazz);
        jar.write(scoringClass);
        jar.flush();
        jar.closeEntry();
        entries.add(clazz.getName());
        String resourcePrefix = (String)packagePath + "_" + className + "/";
        JarEntry root = new JarEntry(resourcePrefix);
        root.setTime(resources.lastModified());
        jar.putNextEntry(root);
        jar.flush();
        jar.closeEntry();
        entries.add(resourcePrefix);
        try (AutoDelete tmpResources = DSSTempUtils.getTempFolder((String)"model-export", (String)"model");){
            ScoringExporter.copyResourcesFromFMI((File)tmpResources, this.fullModelId);
            JarScoring.putResourcesInJar((File)tmpResources, resourcePrefix, jar, entries);
        }
        return new Pair((Object)jar, entries);
    }

    private static void putResourcesInJar(File resources, String resourcePrefix, JarOutputStream jar, Set<String> entries) throws IOException {
        List<String> paths = JarScoring.prepareJarPaths(resources);
        entries.addAll(paths);
        for (String path : paths) {
            File f = new File(resources, path);
            JarEntry entry = new JarEntry(resourcePrefix + path);
            entry.setTime(f.lastModified());
            jar.putNextEntry(entry);
            if (f.isFile()) {
                try (FileInputStream fis = new FileInputStream(f);){
                    IOUtils.copy((InputStream)fis, (OutputStream)jar);
                }
            }
            jar.flush();
            jar.closeEntry();
        }
    }

    static List<String> prepareJarPaths(File root) {
        assert (root.isDirectory());
        return JarScoring.prepareJarPaths(root, "");
    }

    private static List<String> prepareJarPaths(File dir, String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        File[] files = dir.listFiles();
        if (files == null) {
            return ret;
        }
        for (File f : files) {
            String path = prefix + f.getName();
            if (f.isFile()) {
                if (!JarScoring.authorizedFileInJar(f.getName())) continue;
                ret.add(path);
                continue;
            }
            if (!f.isDirectory()) continue;
            path = path + "/";
            ret.add(path);
            ret.addAll(JarScoring.prepareJarPaths(f, path));
        }
        return ret;
    }

    private static boolean authorizedFileInJar(String fileName) {
        return fileName.endsWith(".json") || fileName.equals("dss_pipeline_model.gz") || fileName.equals("dss_prediction_intervals_model.gz");
    }

    static Pair<String, String> splitPackageClass(String fullyQualifiedClassName) {
        Matcher matcher = FULLY_QUALIFIED_CLASS_NAME.matcher(fullyQualifiedClassName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid fully-qualified class name: " + fullyQualifiedClassName);
        }
        String packageName = matcher.group(1);
        String className = matcher.group(2);
        if (packageName != null) {
            packageName = packageName.length() <= 1 ? null : packageName.substring(0, packageName.length() - 1);
        }
        return new Pair((Object)packageName, (Object)className);
    }

    static byte[] makeScoringClass(String fullClassName, File resources) throws IOException, CodedException {
        Build.DssPipelineMeta meta = Build.pipelineMeta((URL)resources.toURI().toURL());
        if (meta == null || meta.type == null) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INCOMPATIBLE_MODEL_ENGINE, "Model is not java-compatible, can't make Jar");
        }
        String oldClassName = (switch (meta.type) {
            case Build.DssPipelineMeta.ModelType.REGRESSION -> RegressionTemplate.class;
            case Build.DssPipelineMeta.ModelType.CLASSIFICATION_ONLY -> NPClassificationTemplate.class;
            case Build.DssPipelineMeta.ModelType.BINARY_PROBABILISTIC -> BPClassificationTemplate.class;
            case Build.DssPipelineMeta.ModelType.MULTICLASS_PROBABILISTIC -> MPClassificationTemplate.class;
            default -> throw new IllegalStateException("Unrecognized model type " + String.valueOf(meta.type));
        }).getCanonicalName();
        ClassReader cr = new ClassReader(oldClassName);
        ClassWriter cw = new ClassWriter(cr, 0);
        ClassRemapper rca = new ClassRemapper((ClassVisitor)cw, (Remapper)new SimpleRemapper(oldClassName.replace('.', '/'), fullClassName.replace('.', '/')));
        cr.accept((ClassVisitor)rca, 8);
        return cw.toByteArray();
    }
}

