/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.helpers;

import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLDerivedField;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLThresholdFunctions;
import com.dataiku.scoring.models.DecisionTreeModel;
import java.util.ArrayList;
import java.util.List;

class PMMLSubtractedDerivedFieldGenerator<T> {
    private final DecisionTreeModel<T> tree;
    private final String treeName;
    private final String[] colNames;

    public PMMLSubtractedDerivedFieldGenerator(DecisionTreeModel<T> tree, String treeName, String[] colNames) {
        this.tree = tree;
        this.treeName = treeName;
        this.colNames = colNames;
    }

    public List<PMMLDerivedField> generateDerivedFields() {
        ArrayList<DecisionTreeModel.Node> nodesToVisit = new ArrayList<DecisionTreeModel.Node>();
        nodesToVisit.add(this.tree.getRoot());
        ArrayList<PMMLDerivedField> derivedFields = new ArrayList<PMMLDerivedField>();
        while (!nodesToVisit.isEmpty()) {
            DecisionTreeModel.Node node = (DecisionTreeModel.Node)nodesToVisit.remove(0);
            if (node.isLeaf) continue;
            PMMLDerivedField derivedField = this.generateDerivedField(node);
            derivedFields.add(derivedField);
            nodesToVisit.add(node.leftSon);
            nodesToVisit.add(node.rightSon);
        }
        return derivedFields;
    }

    private PMMLDerivedField generateDerivedField(DecisionTreeModel.Node<T> node) {
        String originalFieldName = this.colNames[node.variable];
        String derivedFieldName = String.format("%s:%s:%d", originalFieldName, this.treeName, node.id);
        PMMLThresholdFunctions.PMMLApplySubtraction subtraction = this.tree.variant.expectsThresholdAsDouble ? PMMLThresholdFunctions.PMMLApplySubtraction.from(originalFieldName, node.threshold) : PMMLThresholdFunctions.PMMLApplySubtraction.from(originalFieldName, (float)node.threshold);
        return new PMMLDerivedField.SubtractedDerivedField(derivedFieldName, subtraction, "double");
    }
}

