/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.insights.article.ArticleInsightParams;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightParams;
import com.dataiku.dip.dashboards.insights.dataset.DatasetTableInsightParams;
import com.dataiku.dip.dashboards.insights.discussions.DiscussionsInsightParams;
import com.dataiku.dip.dashboards.insights.eda.EdaInsightParams;
import com.dataiku.dip.dashboards.insights.folder.FolderContentInsightParams;
import com.dataiku.dip.dashboards.insights.jupyter.JupyterInsightParams;
import com.dataiku.dip.dashboards.insights.metrics.MetricsInsightParams;
import com.dataiku.dip.dashboards.insights.model.SavedModelReportInsightParams;
import com.dataiku.dip.dashboards.insights.report.ReportInsightParams;
import com.dataiku.dip.dashboards.insights.scenario.ScenarioInsightParams;
import com.dataiku.dip.dashboards.insights.webapp.WebAppInsightParams;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.ConfigurablePublicAPIKey;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesDAO;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.cache.Cache;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkspacePermissionsService
implements IWorkspacePermissionsService {
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private WorkspacesDAO workspacesDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private PubSubService pubSub;
    private final Cache<CacheKey, CacheValue> permissionsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).expireAfterAccess(1L, TimeUnit.DAYS).build();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.workspaces.security");

    public static boolean permissionItemIncludes(BasePermissions.PermissionItem item, Privileges.WorkspaceLevelPrivilegeType privilege) {
        switch (privilege) {
            case ADMIN: {
                return item.admin;
            }
            case WRITE: {
                return item.admin || item.write;
            }
            case READ: {
                return item.admin || item.write || item.read;
            }
        }
        throw new Error("forbidden");
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init workspace permission service");
        this.pubSub.subscribe("workspace-created", evt -> this.invalidateCache());
        this.pubSub.subscribe("workspace-updated", evt -> this.invalidateCache());
        this.pubSub.subscribe("workspace-item-changed", evt -> this.invalidateCache());
        this.pubSub.subscribe("workspace-deleted", evt -> this.invalidateCache());
        this.pubSub.subscribe("object-change", evt -> {
            if (evt.objectType == ITaggingService.TaggableType.DASHBOARD) {
                this.invalidateCache();
            }
        });
        this.pubSub.subscribe("project-settings-changed", evt -> this.invalidateCache());
        logger.debug((Object)"Done init workspace permission service");
    }

    private void invalidateCache() {
        logger.debug((Object)"Invalid workspace permission cache");
        this.permissionsCache.invalidateAll();
    }

    @Override
    public boolean hasWorkspacePrivileges(AuthCtx authCtx, String workspaceKey, Privileges.WorkspaceLevelPrivilegeType ... privileges) throws DKUSecurityException {
        return this.hasWorkspacePrivileges(authCtx, this.getWorkspaceUnsafe(workspaceKey), privileges);
    }

    @Override
    public void checkWorkspacePrivileges(AuthCtx authCtx, String workspaceKey, Privileges.WorkspaceLevelPrivilegeType ... privileges) throws DKUSecurityException {
        this.checkWorkspacePrivileges(authCtx, this.getWorkspaceUnsafe(workspaceKey), privileges);
    }

    @Override
    public boolean hasWorkspacePrivileges(AuthCtx u, Workspace workspace, Privileges.WorkspaceLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.WorkspaceLevelPrivilegeType privilege : privileges) {
            if (this.hasWorkspacePrivilege(u, workspace, privilege)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkWorkspacePrivileges(AuthCtx authCtx, Workspace workspace, Privileges.WorkspaceLevelPrivilegeType ... privileges) throws DKUSecurityException {
        if (!this.hasWorkspacePrivileges(authCtx, workspace, privileges)) {
            throw new UnauthorizedException("Action forbidden", "workspace-authorization-failure").with("requiredPrivileges", StringUtils.join((Object[])privileges));
        }
    }

    @Override
    public boolean isObjectReadableViaSomeWorkspace(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, String objectId) throws DKUSecurityException {
        CacheKey key = new CacheKey(projectKey, objectType, objectId);
        CacheValue value = (CacheValue)this.permissionsCache.getIfPresent((Object)key);
        if (value == null) {
            value = new CacheValue(this.listWorkspacesContainingObjectUnsafe(projectKey, objectType, objectId));
            this.permissionsCache.put((Object)key, (Object)value);
        }
        for (String workspaceKey : value.workspaceKeys) {
            if (!this.hasWorkspacePrivileges(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWorkspacePrivilege(AuthCtx u, Workspace workspace, Privileges.WorkspaceLevelPrivilegeType privilege) throws DKUSecurityException {
        assert (u != null);
        if (workspace == null) {
            return false;
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.isGlobalAdmin();
            }
            case CONFIGURABLE_API_KEY_PROJECT: {
                return false;
            }
            case GLOBAL_API_KEY_WITH_GROUPS: 
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (u.isAdmin()) {
                    return true;
                }
                if (u.getAssociatedDSSUser() != null) {
                    String dssUser = u.getAssociatedDSSUserMand();
                    for (BasePermissions.PermissionItem pi : workspace.permissions) {
                        if (!dssUser.equals(pi.user) || !WorkspacePermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                HashSet<String> groups = new HashSet<String>(u.getGroups());
                groups.add("$$ALL_USERS$$");
                for (String gid : groups) {
                    for (BasePermissions.PermissionItem pi : workspace.permissions) {
                        if (!gid.equals(pi.group) || !WorkspacePermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    private ImmutableList<String> listWorkspacesContainingObjectUnsafe(String projectKey, ITaggingService.TaggableType objectType, String objectId) {
        return (ImmutableList)this.listWorkspacesUnsafe().stream().filter(wks -> this.isObjectAccessibleViaWorkspace(projectKey, objectType, objectId, (Workspace)wks)).map(wks -> wks.workspaceKey).collect(ImmutableList.toImmutableList());
    }

    private boolean isObjectAccessibleViaWorkspace(String objectProjectKey, ITaggingService.TaggableType objectType, String objectId, Workspace workspace) {
        if (workspace.contains(objectProjectKey, objectType, objectId)) {
            if ((objectType == ITaggingService.TaggableType.ARTICLE || objectType == ITaggingService.TaggableType.WEB_APP || objectType == ITaggingService.TaggableType.DATASET) && objectId != null) {
                return this.hasObjectAuthorization(objectProjectKey, objectType, objectId);
            }
            return true;
        }
        if (objectType != null && objectType != ITaggingService.TaggableType.DASHBOARD) {
            for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
                if (workspaceObject.reference == null || workspaceObject.reference.type != ITaggingService.TaggableType.DASHBOARD) continue;
                try {
                    Dashboard dashboard = (Dashboard)this.dashboardsDAO.getOrNullUnsafe(workspaceObject.reference.projectKey, workspaceObject.reference.id);
                    if (!this.dashboardContainsObject(dashboard, objectProjectKey, objectType, objectId)) continue;
                    return true;
                }
                catch (Exception e) {
                    logger.infoV("Unable to read dashboard %s to check its content. Reason: %s", new Object[]{workspaceObject.reference, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        return false;
    }

    private boolean dashboardContainsObject(Dashboard dashboard, String objectProjectKey, ITaggingService.TaggableType objectType, String objectId) {
        if (dashboard == null) {
            return false;
        }
        for (DashboardPage page : dashboard.pages) {
            for (Tile tile : page.getFlattenedTileList()) {
                if (!this.tileContainsObject(tile, dashboard.projectKey, objectProjectKey, objectType, objectId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tileContainsObject(Tile tile, String dashboardProjectKey, String objectProjectKey, ITaggingService.TaggableType objectType, String objectId) {
        if (tile == null || tile.tileType != Tile.TileType.INSIGHT) {
            return false;
        }
        String smartObjectId = new AnyLoc(objectProjectKey, objectId).getSmartName(dashboardProjectKey);
        switch (objectType) {
            case INSIGHT: {
                return tile.insightId != null && tile.insightId.equals(smartObjectId);
            }
            case ARTICLE: {
                Insight insight;
                if (!"article".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                ArticleInsightParams insightParams = (ArticleInsightParams)insight.params;
                return insightParams.articleId.equals(smartObjectId);
            }
            case WEB_APP: {
                Insight insight;
                if (!"web_app".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                WebAppInsightParams insightParams = (WebAppInsightParams)insight.params;
                return insightParams.webAppSmartId.equals(smartObjectId);
            }
            case DATASET: {
                Insight insight;
                if ("dataset_table".equals(tile.insightType)) {
                    Insight insight2 = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId);
                    if (insight2 == null) break;
                    DatasetTableInsightParams insightParams = (DatasetTableInsightParams)insight2.params;
                    return insightParams.datasetSmartName.equals(smartObjectId);
                }
                if ("chart".equals(tile.insightType)) {
                    Insight insight3 = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId);
                    if (insight3 == null) break;
                    ChartInsightParams insightParams = (ChartInsightParams)insight3.params;
                    return insightParams.datasetSmartName.equals(smartObjectId);
                }
                if ("eda".equals(tile.insightType)) {
                    Insight insight4 = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId);
                    if (insight4 == null) break;
                    EdaInsightParams insightParams = (EdaInsightParams)insight4.params;
                    if (insightParams.dataSpec == null) break;
                    return insightParams.dataSpec.inputDatasetSmartName.equals(smartObjectId);
                }
                if (!"metrics".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                MetricsInsightParams insightParams = (MetricsInsightParams)insight.params;
                if (insightParams.objectType != ITaggingService.TaggableType.DATASET) break;
                return insightParams.objectSmartId.equals(smartObjectId);
            }
            case SAVED_MODEL: {
                Insight insight;
                if (!"saved-model_report".equalsIgnoreCase(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                SavedModelReportInsightParams insightParams = (SavedModelReportInsightParams)insight.params;
                return insightParams.savedModelSmartId.equals(smartObjectId);
            }
            case SCENARIO: {
                Insight insight;
                if (!"scenario_last_runs".equals(tile.insightType) && !"scenario_run_button".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                ScenarioInsightParams insightParams = (ScenarioInsightParams)insight.params;
                return insightParams.scenarioSmartId.equals(smartObjectId);
            }
            case MANAGED_FOLDER: {
                Insight insight;
                if (!"managed-folder_content".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                FolderContentInsightParams insightParams = (FolderContentInsightParams)insight.params;
                return insightParams.folderSmartId.equals(smartObjectId);
            }
            case REPORT: {
                Insight insight;
                if (!"report".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                ReportInsightParams insightParams = (ReportInsightParams)insight.params;
                return insightParams.reportSmartId.equals(smartObjectId);
            }
            case JUPYTER_NOTEBOOK: {
                Insight insight;
                if (!"jupyter".equals(tile.insightType) || (insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId)) == null) break;
                JupyterInsightParams insightParams = (JupyterInsightParams)insight.params;
                return insightParams.notebookSmartName.equals(smartObjectId);
            }
        }
        return this.tileContainsDiscussion(tile, dashboardProjectKey, objectProjectKey, objectType, objectId);
    }

    private boolean tileContainsDiscussion(Tile tile, String dashboardProjectKey, String objectProjectKey, ITaggingService.TaggableType objectType, String objectId) {
        if ("discussions".equals(tile.insightType)) {
            String smartObjectId = new AnyLoc(objectProjectKey, objectId).getSmartName(dashboardProjectKey);
            Insight insight = this.getOrNullUnsafeInsight_cannotFail(dashboardProjectKey, tile.insightId);
            if (insight != null) {
                DiscussionsInsightParams insightParams = (DiscussionsInsightParams)insight.params;
                if (insightParams.objectType == objectType) {
                    return insightParams.objectId.equals(smartObjectId);
                }
            }
        }
        return false;
    }

    private List<Workspace> listWorkspacesUnsafe() {
        try {
            return this.workspacesDAO.listWorkspacesUnsafe();
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to read workspaces list", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Workspace getWorkspaceUnsafe(String workspaceKey) throws UnauthorizedException {
        Workspace workspace;
        try {
            workspace = this.workspacesDAO.getMandatoryUnsafe(workspaceKey);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read workspace permissions", (Throwable)e);
            throw new UnauthorizedException("Failed to read workspace permissions", "check-failed", (Throwable)e);
        }
        return workspace;
    }

    private boolean hasObjectAuthorization(String projectKey, ITaggingService.TaggableType objectType, String objectId) {
        try {
            SerializedProject project = this.projectsDAO.getMandatoryUnsafe(projectKey);
            return project.dashboardAuthorizations.hasObjectAuthorization(new SmartObjectRef(objectType, objectId), SerializedProject.ReaderAuthorization.Mode.READ);
        }
        catch (IOException e) {
            logger.info((Object)("Unable to retrieve the requested project to check its permissions: " + projectKey), (Throwable)e);
            return false;
        }
    }

    @Nullable
    private Insight getOrNullUnsafeInsight_cannotFail(String dashboardProjectKey, String insightId) {
        try {
            return (Insight)this.insightsDAO.getOrNullUnsafe(dashboardProjectKey, insightId);
        }
        catch (Exception e) {
            logger.infoV("Unable to read insight %s.%s to check its content. Reason: %s", new Object[]{dashboardProjectKey, insightId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return null;
        }
    }

    private static class CacheKey {
        private final String projectKey;
        private final ITaggingService.TaggableType objectType;
        private final String objectId;

        public CacheKey(String projectKey, ITaggingService.TaggableType objectType, String objectId) {
            this.projectKey = projectKey;
            this.objectType = objectType;
            this.objectId = objectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.projectKey, cacheKey.projectKey) && this.objectType == cacheKey.objectType && Objects.equals(this.objectId, cacheKey.objectId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.projectKey, this.objectType, this.objectId});
        }
    }

    private static class CacheValue {
        private final ImmutableList<String> workspaceKeys;

        public CacheValue(ImmutableList<String> workspaceKeys) {
            Preconditions.checkNotNull(workspaceKeys);
            this.workspaceKeys = workspaceKeys;
        }
    }
}

