/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.jwt.JwtVerificationService;
import com.dataiku.dip.security.sso.OpenIDHelper;
import com.dataiku.dip.security.sso.SAMLHelper;
import com.dataiku.dip.security.sso.SpnegoHelper;
import com.dataiku.dip.security.sso.UserMapper;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSSSOService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth.sso");
    private JwtVerificationService jwtVerificationService;
    private PasswordEncryptionService passwordEncryptionService;
    private GeneralSettingsDAO.GeneralSettings generalSettings;
    private SpnegoHelper spnegoHelper;
    private SAMLHelper samlHelper;
    private OpenIDHelper openIDHelper;
    private UserMapper userMapper;

    @Autowired
    public DSSSSOService(GeneralSettingsDAO gsDAO, PubSubService pubSub, JwtVerificationService jwtVerificationService, PasswordEncryptionService passwordEncryptionService) throws IOException {
        this.jwtVerificationService = jwtVerificationService;
        this.passwordEncryptionService = passwordEncryptionService;
        this.generalSettings = gsDAO.getUnsafeAutoTXN();
        this.refreshClients(this.generalSettings);
        pubSub.subscribe("general-settings-changed", evt -> {
            try {
                this.generalSettings = gsDAO.getUnsafeAutoTXN();
                this.refreshClients(this.generalSettings);
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }

    @VisibleForTesting
    public void refreshClients(GeneralSettingsDAO.GeneralSettings gs) {
        try {
            this.samlHelper = null;
            this.openIDHelper = null;
            this.spnegoHelper = null;
            if (gs.ssoSettings.enabled) {
                this.userMapper = new UserMapper(gs.ssoSettings);
                switch (gs.ssoSettings.protocol) {
                    case SAML: {
                        logger.info((Object)"Initializing SAML login client");
                        this.samlHelper = new SAMLHelper(gs.ssoSettings, this.passwordEncryptionService);
                        break;
                    }
                    case OPENID: {
                        logger.info((Object)"Initializing OpenID login client");
                        this.openIDHelper = new OpenIDHelper(gs.ssoSettings, this.jwtVerificationService, this.passwordEncryptionService, gs.proxySettings);
                        break;
                    }
                    case SPNEGO: {
                        this.spnegoHelper = new SpnegoHelper(gs.ssoSettings, ApplicationConfigurator.getFile((String[])new String[]{"privtmp", "login.conf"}));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("SSO protocol " + String.valueOf(this.generalSettings.ssoSettings.protocol) + " mis-configured. Go to /login/ to login without SSO and fix the SSO settings"), (Throwable)e);
        }
    }

    public OpenIDHelper openid() {
        if (this.openIDHelper == null) {
            throw new IllegalStateException("OpenID should be setup correctly at this point. Please verify your SSO settings and logs.");
        }
        return this.openIDHelper;
    }

    public SAMLHelper saml() {
        if (this.samlHelper == null) {
            throw new IllegalStateException("SAML should be setup correctly at this point. Please verify your SSO settings and logs.");
        }
        return this.samlHelper;
    }

    public SpnegoHelper spnego() {
        if (this.spnegoHelper == null) {
            throw new IllegalStateException("SPNEGO should be setup correctly at this point. Please verify your SSO settings and logs.");
        }
        return this.spnegoHelper;
    }

    public UserMapper userMapper() {
        if (this.userMapper == null) {
            throw new IllegalStateException("User mapping should be setup correctly at this point. Please verify your SSO settings and logs.");
        }
        return this.userMapper;
    }
}

