/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticmodels;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.semanticmodels.SemanticModel;
import com.dataiku.dip.semanticmodels.SemanticModelsDAO;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SemanticModelsCRUDService {
    @Autowired
    private SemanticModelsDAO dao;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private TaggableObjectDiffService taggableObjectDiffService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private PubSubService pubSubService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.semanticmodels.crud");

    public String create(AuthCtx user, String projectKey, String name) throws Exception {
        StringTransmogrifier transmogrifier = new StringTransmogrifier(" ");
        for (SemanticModel head : this.dao.list(projectKey)) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        String id = SecretKeyGenerator.generateSmall();
        SemanticModel model = new SemanticModel();
        model.projectKey = projectKey;
        model.id = id;
        model.creationTag = new VersionTag(user.getIdentifier());
        model.versionTag = new VersionTag(user.getIdentifier());
        if (StringUtils.isBlank((String)name)) {
            name = "Untitled semantic model";
        }
        model.name = transmogrifier.transmogrify(name);
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(model);
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, model);
        this.dao.save(model);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", model.name);
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEMANTIC_MODEL, projectKey, id, user, TaggableObjectChangedEvent.ActionType.SEMANTIC_MODEL_CREATE).withDetails(details));
        return id;
    }

    public SemanticModel save(SemanticModel semanticModel, boolean summaryOnly) throws IOException, CodedException {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)semanticModel.projectKey);
        Preconditions.checkNotNull((Object)semanticModel.id);
        SemanticModel semanticModelToSave = (SemanticModel)JSON.deepCopy((Object)semanticModel);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SemanticModel preExisting = (SemanticModel)this.dao.getOrNullUnsafe(semanticModel.projectKey, semanticModel.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(semanticModelToSave, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", semanticModelToSave.name);
        if (semanticModelToSave.name != null && preExisting != null && !semanticModelToSave.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.SEMANTIC_MODEL_RENAME;
            details.addProperty("newName", semanticModelToSave.name);
            details.addProperty("oldName", preExisting.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.SEMANTIC_MODEL_EDIT;
            diff = this.taggableObjectDiffService.diff(preExisting, semanticModelToSave, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(semanticModel.projectKey, semanticModel.id), semanticModelToSave);
        this.dao.save(semanticModelToSave);
        if (diff.metadataChanged()) {
            this.taggableObjectDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEMANTIC_MODEL, semanticModelToSave.projectKey, semanticModelToSave.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(semanticModelToSave.projectKey, semanticModelToSave.tags);
        return semanticModelToSave;
    }

    public void delete(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SemanticModel semanticModel = (SemanticModel)this.dao.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, semanticModel);
        JsonObject details = new JsonObject();
        if (semanticModel != null) {
            details.addProperty("objectDisplayName", semanticModel.name);
        }
        this.dao.delete(projectKey, id);
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEMANTIC_MODEL, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.SEMANTIC_MODEL_DELETE).withDetails(details));
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws IOException {
        return new TaggableObjectsDeletionService.DeletionImpact();
    }
}

