/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.codestudio.CodeStudioCodes;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.component.LoadedPythonPluginCodeStudioTemplate;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateService;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.RunLogsUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class CodeStudiosController
extends DIPInternalControllerBase {
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;
    @Autowired
    private CodeStudioRuntimeManager codeStudioRuntimeManager;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private DevPluginsService devPluginsService;
    @Autowired
    private PythonPluginCodeStudioTemplateService pythonPluginCodeStudioTemplateService;
    private static Logger logger = Logger.getLogger((String)"dku.codestudio.controller");

    @AuditedCall(value={"msgType", "code-studio-blocks-list-types"})
    @RequestMapping(value={"/api/code-studio-blocks/list-types"})
    public void listBlockTypes(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplateId);
            }
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioTemplatesService.listBlockTypes());
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-list"})
    @RequestMapping(value={"/api/code-studio-templates/list"})
    public void listTemplates(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioTemplatesService.listUnsafe());
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-list-types"})
    @RequestMapping(value={"/api/code-studio-templates/list-types"})
    public void listTemplateTypes(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String all) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCreateCodeStudioTemplatePrivilege(user);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioTemplatesService.listTypes("true".equalsIgnoreCase(all)));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-templates-list"})
    @RequestMapping(value={"/api/code-studio-templates/list-heads"})
    public void listTemplateHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String tagFilter) throws Exception {
        CodeStudioTemplate.FilteredListItems heads = new CodeStudioTemplate.FilteredListItems();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            for (CodeStudioTemplate.ListItem head : this.codeStudioTemplatesService.listHeads()) {
                if (!this.permissionsService.hasCodeStudioTemplatePrivilege(user, head.id, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                    ++heads.notAccessible;
                    continue;
                }
                if (!TagFilterUtils.matches(tf, head.tags)) {
                    ++heads.filteredOut;
                    continue;
                }
                heads.items.add(head);
            }
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)heads);
    }

    @AuditedCall(value={"msgType", "code-studio-templates-can-edit"})
    @RequestMapping(value={"api/code-studio-templates/can-edit-in-code-studio"})
    public void canEditInCodeStudio(HttpServletRequest req, HttpServletResponse resp, String projectKey) throws Exception {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            if (this.projectsService.hasPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                ret.put("canEdit", this.codeStudioTemplatesService.canEditInCodeStudio());
            } else {
                ret.put("canEdit", false);
            }
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, ret);
    }

    @AuditedCall(value={"msgType", "code-studio-template-get", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/get-full-info"})
    public void getTemplateFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasAnyCodeStudioTemplateAccess(u, codeStudioTemplateId)) {
                throw new DKUSecurityException("User is not allowed to access Code Studio template " + codeStudioTemplateId);
            }
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioTemplatesService.getFullInfo(u, codeStudioTemplateId));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-templates/create"})
    public void createTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String label, @RequestParam String type) throws Exception {
        CodeStudioTemplate codeStudioTemplate;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCreateCodeStudioTemplatePrivilege(authCtx);
            codeStudioTemplate = this.codeStudioTemplatesService.create(authCtx, type, label);
            t.commitV("Created Code Studio template %s (%s)", new Object[]{codeStudioTemplate.getLabel(), codeStudioTemplate.id});
            this.auditTrailService.generic("code-studio-template-create").with("codeStudioTemplateId", codeStudioTemplate.id).emit();
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)codeStudioTemplate);
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-templates/save"})
    public void saveTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioData, @RequestParam(required=false) String commitMessage) throws Exception {
        CodeStudioTemplate codeStudioTemplate = (CodeStudioTemplate)JSON.parse((String)codeStudioData, CodeStudioTemplate.class);
        VariablesContext templateVariablesContext = CodeStudioTemplatesService.getTemplateVariablesContext(codeStudioTemplate.id);
        codeStudioTemplate.params.checkParamsValid(templateVariablesContext);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplate.id, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to update Code Studio template " + codeStudioTemplate.id);
            }
            this.codeStudioTemplatesService.getMandatoryUnsafe(codeStudioTemplate.id);
            if (codeStudioTemplate.label == null) {
                codeStudioTemplate.label = "";
            }
            codeStudioTemplate = this.codeStudioTemplatesService.save(codeStudioTemplate);
            t.commit(String.format("Saved Code Studio template %s (%s)", codeStudioTemplate.label, codeStudioTemplate.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("code-studio-template-save").with("codeStudioTemplateId", codeStudioTemplate.id).emit();
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)codeStudioTemplate);
    }

    @AuditedCall(value={"msgType", "code-studio-template-delete", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/delete"})
    public void deleteTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam boolean deleteRuntimes, @RequestParam boolean deleteImages) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to delete Code Studio template " + codeStudioTemplateId);
            }
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioTemplatesService.delete(authCtx, codeStudioTemplateId, deleteRuntimes, deleteImages));
    }

    @AuditedCall(value={"msgType", "code-studio-template-delete", "codeStudioTemplateIds", "${codeStudioTemplateIds}"})
    @RequestMapping(value={"/api/code-studio-templates/mass-delete"})
    public void massDeleteTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> codeStudioTemplateIds, @RequestParam boolean deleteRuntimes, @RequestParam boolean deleteImages) throws Exception {
        AuthCtx authCtx = null;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPrivilegeOnAllTemplates(codeStudioTemplateIds, authCtx, "delete", Privileges.CodeStudioTemplatePrivilegeType.UPDATE);
        }
        for (String codeStudioTemplateId : codeStudioTemplateIds) {
            try {
                InfoMessage.InfoMessages messages = this.codeStudioTemplatesService.delete(authCtx, codeStudioTemplateId, deleteRuntimes, deleteImages);
                ret.mergeFrom(messages);
            }
            catch (Exception e) {
                ret.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_TEMPLATE_DELETE_FAILED, "Failed to delete template " + codeStudioTemplateId + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        ret.summarize();
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private void checkPrivilegeOnAllTemplates(List<String> codeStudioTemplateIds, AuthCtx authCtx, String action, Privileges.CodeStudioTemplatePrivilegeType privilege) throws DKUSecurityException {
        ArrayList missingPrivilegeTemplateIds = Lists.newArrayList();
        for (String codeStudioTemplateId : codeStudioTemplateIds) {
            if (this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, privilege)) continue;
            missingPrivilegeTemplateIds.add(codeStudioTemplateId);
        }
        if (!missingPrivilegeTemplateIds.isEmpty()) {
            throw new DKUSecurityException("User is not allowed to " + action + " Code Studio templates " + Joiner.on((String)",").join((Iterable)missingPrivilegeTemplateIds));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-build", "codeStudioTemplateId", "${codeStudioTemplateId}", "withNoCache", "${withNoCache}"})
    @RequestMapping(value={"/api/code-studio-templates/build"})
    public void buildTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam(required=false, defaultValue="false") boolean withNoCache) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("User is not allowed to build Code Studio template " + codeStudioTemplateId);
            }
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioTemplatesService.startBuild(authCtx, codeStudioTemplateId, withNoCache));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-build", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/mass-build"})
    public void massBuildTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> codeStudioTemplateIds) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPrivilegeOnAllTemplates(codeStudioTemplateIds, authCtx, "build", Privileges.CodeStudioTemplatePrivilegeType.UPDATE);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioTemplatesService.startMassBuild(authCtx, codeStudioTemplateIds));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-logs", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/list-logs"})
    public void listTemplateLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("Insufficient permissions on template " + codeStudioTemplateId);
            }
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioTemplatesService.listLogs(codeStudioTemplateId));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-logs", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/get-log-info"})
    public void getTemplateLogInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String buildId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("Insufficient permissions on template " + codeStudioTemplateId);
            }
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioTemplatesService.getLogInfo(codeStudioTemplateId, buildId));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-logs", "codeStudioTemplateId", "${codeStudioTemplateId}", "buildId", "${buildId}"})
    @RequestMapping(value={"/api/code-studio-templates/download-build-diagnosis"})
    public void downloadBuildTemplateDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String buildId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("Insufficient permissions on template " + codeStudioTemplateId);
            }
        }
        this.codeStudioTemplatesService.sendBuildDiagnostic(resp, codeStudioTemplateId, buildId);
    }

    @AuditedCall(value={"msgType", "code-studio-template-logs", "codeStudioTemplateId", "${codeStudioTemplateId}", "buildId", "${buildId}"})
    @RequestMapping(value={"/api/code-studio-templates/build-log"})
    public void downloadBuildLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String buildId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("Insufficient permissions on template " + codeStudioTemplateId);
            }
        }
        File logFile = new File(CodeStudioTemplatesService.getBuildDir(codeStudioTemplateId, buildId), "build.log");
        this.writeLog(resp, logFile, codeStudioTemplateId + "_" + buildId + ".log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(HttpServletResponse resp, File logFile, String filename) throws IOException {
        block10: {
            if (logFile.isFile() && logFile.canRead()) {
                resp.setContentType("text/plain; charset=UTF-8");
                resp.setHeader("Content-Disposition", "inline; filename=\"" + filename + ".log\"");
                resp.setStatus(200);
                try (FileInputStream input = null;
                     BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                    input = new FileInputStream(logFile);
                    IOUtils.copy((InputStream)input, (OutputStream)bos);
                    break block10;
                }
            }
            resp.setStatus(404);
            resp.getWriter().write("run log not found " + logFile.getAbsolutePath());
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-usage", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/get-usage"})
    public void getTemplateUsage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam(required=false, defaultValue="false") boolean withCurrentUses) throws Exception {
        List<String> projectKeys;
        CodeStudioTemplate template;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(u, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.USE)) {
                throw new DKUSecurityException("Cannot list usages of Code Studio template " + codeStudioTemplateId);
            }
            template = this.codeStudioTemplatesService.getMandatoryUnsafe(codeStudioTemplateId);
            projectKeys = this.projectsService.listProjectKeys();
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioTemplatesService.listUsages_NT(u, template, projectKeys, withCurrentUses));
    }

    @AuditedCall(value={"msgType", "code-studio-template-usage", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/mass-get-usage"})
    public void massGetTemplateUsage(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) List<String> codeStudioTemplateIds, @RequestParam(required=false, defaultValue="false") boolean withCurrentUses) throws Exception {
        List<String> projectKeys;
        AuthCtx u;
        ArrayList codeStudioTemplates = Lists.newArrayList();
        ArrayList nonCheckableCodeStudioTemplateIds = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            List<CodeStudioTemplate> requestedTemplates = this.codeStudioTemplatesService.listUnsafe();
            if (codeStudioTemplateIds != null && codeStudioTemplateIds.size() > 0) {
                requestedTemplates = requestedTemplates.stream().filter(cst -> codeStudioTemplateIds.contains(cst.id)).collect(Collectors.toList());
            }
            for (CodeStudioTemplate codeStudioTemplate : requestedTemplates) {
                if (!this.permissionsService.hasCodeStudioTemplatePrivilege(u, codeStudioTemplate, Privileges.CodeStudioTemplatePrivilegeType.USE)) {
                    nonCheckableCodeStudioTemplateIds.add(codeStudioTemplate.id);
                    continue;
                }
                codeStudioTemplates.add(codeStudioTemplate);
            }
            projectKeys = this.projectsService.listProjectKeys();
        }
        List<CodeStudioTemplatesService.Usages> usagesList = this.codeStudioTemplatesService.massListUsages_NT(u, codeStudioTemplates, projectKeys, withCurrentUses);
        for (String codeStudioTemplateId : nonCheckableCodeStudioTemplateIds) {
            CodeStudioTemplatesService.Usages usages = new CodeStudioTemplatesService.Usages();
            usages.codeStudioTemplateId = codeStudioTemplateId;
            usages.cannotCheckUsages = true;
            usagesList.add(usages);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, usagesList);
    }

    @AuditedCall(value={"msgType", "code-studio-template-save", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/mass-set-container-conf"})
    public void massSetContainerConf(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> codeStudioTemplateIds, @RequestParam(value="codeStudioTemplate") String codeStudioTemplateStr) throws Exception {
        CodeStudioTemplate codeStudioTemplate = (CodeStudioTemplate)JSON.parse((String)codeStudioTemplateStr, CodeStudioTemplate.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPrivilegeOnAllTemplates(codeStudioTemplateIds, authCtx, "change container config on", Privileges.CodeStudioTemplatePrivilegeType.UPDATE);
            List<CodeStudioTemplate> saved = this.codeStudioTemplatesService.massSave(codeStudioTemplateIds, x -> {
                x.defaultContainerConf = codeStudioTemplate.defaultContainerConf;
                x.allowContainerConfOverride = codeStudioTemplate.allowContainerConfOverride;
                x.allContainerConfs = codeStudioTemplate.allContainerConfs;
                x.containerConfs = codeStudioTemplate.containerConfs;
            });
            String nameList = saved.stream().limit(5L).map(x -> x.getLabel()).collect(Collectors.joining(", ")) + (String)(saved.size() <= 5 ? "" : ", (" + (saved.size() - 5) + " more)");
            t.commit(String.format("Updated Code Studio templates %s", nameList), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-export", "codeStudioTemplateId", "${codeStudioTemplateId}"})
    @RequestMapping(value={"/api/code-studio-templates/export"})
    public void exportTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId) throws Exception {
        CodeStudioTemplate template;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("Insufficient permissions on template " + codeStudioTemplateId);
            }
            template = this.codeStudioTemplatesService.getMandatoryUnsafe(codeStudioTemplateId);
        }
        this.codeStudioTemplatesService.exportTemplate(authCtx, resp, template);
    }

    @AuditedCall(value={"msgType", "code-studio-template-import"})
    @RequestMapping(value={"/api/code-studio-templates/import"})
    public void importTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart, @RequestParam String label, @RequestParam(required=false, value="importSpec") String importSpecStr) throws Exception {
        AuthCtx authCtx;
        logger.info((Object)("Uploading new template from file " + filePart.getOriginalFilename()));
        CodeStudioMeta.TemplateImportSpec importSpec = (CodeStudioMeta.TemplateImportSpec)JSON.parse((String)StringUtils.defaultIfBlank((String)importSpecStr, (String)"{}"), CodeStudioMeta.TemplateImportSpec.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkCreateCodeStudioTemplatePrivilege(authCtx);
        }
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"code-studio-template-import-upload", (String)filePart.getOriginalFilename());){
            File zipFile = new File((File)tmpDir, "template.zip");
            FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)zipFile);
            logger.info((Object)"Template received, importing it");
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioTemplatesService.importTemplate(authCtx, zipFile, label, importSpec));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-template-import", "codeStudioTemplateId", "${codeStudioTemplateId}", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/code-studio-templates/export-to-plugin"}, method={RequestMethod.POST})
    public void exportToPlugin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioTemplateId, @RequestParam String pluginId, @RequestParam String label, @RequestParam(required=false, defaultValue="false") boolean overwrite) throws Exception {
        CodeStudioTemplate template;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                throw new DKUSecurityException("Insufficient permissions on template " + codeStudioTemplateId);
            }
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            template = this.codeStudioTemplatesService.getMandatoryUnsafe(codeStudioTemplateId);
        }
        if (!this.pluginsRegistryService.getLoadedPluginIds().contains(pluginId)) {
            this.devPluginsService.createEmptyPluginAndWait(pluginId, authCtx);
        } else if (!this.pluginsRegistryService.isPluginInstalledAsDev(pluginId)) {
            throw new IllegalArgumentException("Cannot create template in non-dev plugin");
        }
        LoadedPythonPluginCodeStudioTemplate loadedDesc = (LoadedPythonPluginCodeStudioTemplate)this.pythonPluginCodeStudioTemplateService.getLoadedDescById(label);
        if (loadedDesc != null && !overwrite) {
            throw new IllegalArgumentException("Template already exists in plugin " + pluginId + " with name " + label);
        }
        try (AutoDelete resourcesStageDir = DSSTempUtils.getTempFolder((String)"code-studio-template-export-to-plugin", (String)template.id);){
            template = this.codeStudioTemplatesService.prepareForPlugin(authCtx, label, template, (File)resourcesStageDir);
            DevPluginsService.RecipeConversionResult result = this.devPluginsService.addNewCodeStudioTemplateToDevPlugin(pluginId, label, authCtx, template, (File)resourcesStageDir);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)result);
        }
    }

    @AuditedCall(value={"msgType", "code-studio-objects-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/code-studio-objects/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioObjectsService.listUnsafe(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-objects-list-types"})
    @RequestMapping(value={"/api/code-studio-objects/list-types"})
    public void listTypes(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioObjectsService.listTypes(user));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-objects-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/code-studio-objects/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        List<CodeStudioObject.ListItem> allHeads;
        AuthCtx user;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            allHeads = this.codeStudioObjectsService.listHeads(user, projectKey);
        }
        for (CodeStudioObject.ListItem head : allHeads) {
            if (!TagFilterUtils.matches(tf, head.tags)) {
                ++heads.filteredOut;
                continue;
            }
            head.uiState = this.codeStudioRuntimeManager.getState(user, head.projectKey, head.id);
            heads.items.add(head);
        }
        this.interestsService.enrichHeads(user.getAssociatedDSSUser(), projectKey, heads.items);
        CodeStudiosController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "code-studio-object-get", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        NavigatorService.CodeStudioObjectFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(u, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            info = this.navigatorService.getCodeStudioFullInfo(projectKey, codeStudioObjectId);
        }
        this.navigatorService.addInfo_NT(info, u);
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "code-studio-object-get", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        AuthCtx authCtx;
        CodeStudioObject.ObjectSummary summary = new CodeStudioObject.ObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            CodeStudioObject codeStudioObject = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, codeStudioObjectId);
            summary.object = codeStudioObject;
            CodeStudioTemplate codeStudioTemplate = this.codeStudioTemplatesService.getOrNullUnsafe(codeStudioObject.templateId);
            if (codeStudioTemplate != null) {
                summary.templateType = codeStudioTemplate.type;
                if (CodeStudioRegistry.hasMeta(codeStudioTemplate)) {
                    summary.desc = CodeStudioRegistry.getMeta(codeStudioTemplate).getCodeStudioType(codeStudioTemplate);
                }
            } else {
                summary.templateWasDeleted = true;
            }
        }
        summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-objects/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam String templateId) throws Exception {
        AuthCtx authCtx;
        CodeStudioObjectCreateResponse ret = new CodeStudioObjectCreateResponse();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx.failIfNoSafeCode("Code Studios");
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, templateId, Privileges.CodeStudioTemplatePrivilegeType.USE)) {
                throw new UnauthorizedException("User is not allowed to use template " + templateId, "code-studio-template-use");
            }
            CodeStudioObject codeStudioObject = this.codeStudioObjectsService.createNoSave(authCtx, projectKey, null, name, templateId);
            ret.codeStudio = this.codeStudioObjectsService.save(codeStudioObject, true);
            t.commitV("Created Code Studio %s (%s.%s)", new Object[]{codeStudioObject.name, codeStudioObject.projectKey, codeStudioObject.id});
            this.auditTrailService.generic("code-studio-object-create").with("projectKey", projectKey).with("codeStudioObjectId", codeStudioObject.id).emit();
        }
        this.codeStudioObjectsService.postCreate_NT(authCtx, ret.codeStudio, ret.messages);
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-objects/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String codeStudioData) throws Exception {
        CodeStudioObject codeStudioObject = (CodeStudioObject)JSON.parse((String)codeStudioData, CodeStudioObject.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, codeStudioObject.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx.failIfNoSafeCode("Code Studios");
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, codeStudioObject.projectKey, codeStudioObject.id)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            this.codeStudioObjectsService.getMandatoryUnsafe(codeStudioObject.projectKey, codeStudioObject.id);
            codeStudioObject = this.codeStudioObjectsService.save(codeStudioObject, false);
            t.commit(String.format("Saved Code Studio %s (%s.%s)", codeStudioObject.name, codeStudioObject.projectKey, codeStudioObject.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("code-studio-object-save").with("projectKey", codeStudioObject.projectKey).with("codeStudioObjectId", codeStudioObject.id).emit();
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)codeStudioObject);
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-objects/change-owner"})
    public void changeOwner(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String newOwner) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            CodeStudioObject codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            if (!StringUtils.equals((String)codeStudio.getOwner(), (String)authCtx.getAssociatedDSSUser())) {
                this.permissionsService.checkAdmin(authCtx, "You need to be either admin or owner of the Code Studio to change its owner.");
            }
            CodeStudioObject codeStudioObject = this.codeStudioObjectsService.changeOwner(authCtx, projectKey, codeStudioObjectId, newOwner);
            t.commit(String.format("Saved Code Studio %s (%s.%s)", codeStudioObject.name, codeStudioObject.projectKey, codeStudioObject.id));
            this.auditTrailService.generic("code-studio-object-change-owner").with("projectKey", codeStudioObject.projectKey).with("codeStudioObjectId", codeStudioObject.id).with("newOwner", newOwner).emit();
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)codeStudioObject);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-objects/save-metadata"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void saveMetadata(HttpServletRequest req, @RequestParam String codeStudioData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            CodeStudioObject codeStudioObject = (CodeStudioObject)JSON.parse((String)codeStudioData, CodeStudioObject.class);
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, codeStudioObject.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user.failIfNoSafeCode("Code Studios");
            if (!this.codeStudioObjectsService.hasPartialAccess(user, codeStudioObject.projectKey, codeStudioObject.id)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            this.codeStudioObjectsService.getMandatoryUnsafe(codeStudioObject.projectKey, codeStudioObject.id);
            this.codeStudioObjectsService.save(codeStudioObject, false);
            t.commit(String.format("Saved Code Studio %s (%s.%s)", codeStudioObject.name, codeStudioObject.projectKey, codeStudioObject.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("code-studio-object-save").with("projectKey", codeStudioObject.projectKey).with("codeStudioObjectId", codeStudioObject.id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/code-studio-objects/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String newCodeStudioName) throws Exception {
        CodeStudioObject codeStudioObject;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user.failIfNoSafeCode("Code Studios");
            if (!this.codeStudioObjectsService.hasPartialAccess(user, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            CodeStudioObject originalCodeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            if (!this.permissionsService.hasCodeStudioTemplatePrivilege(user, originalCodeStudio.templateId, Privileges.CodeStudioTemplatePrivilegeType.USE)) {
                throw new UnauthorizedException("User is not allowed to use template " + originalCodeStudio.templateId, "code-studio-template-use");
            }
            codeStudioObject = this.codeStudioObjectsService.copy(user, projectKey, codeStudioObjectId, newCodeStudioName);
            t.commitV("Copied Code Studio %s into %s (%s.%s into %s.%s)", new Object[]{originalCodeStudio.name, newCodeStudioName, projectKey, codeStudioObjectId, projectKey, codeStudioObject.id});
            this.auditTrailService.generic("code-studio-object-create").with("projectKey", projectKey).with("codeStudioObjectId", codeStudioObject.id).with("fromProjectKey", projectKey).with("fromCodeStudioObjectId", codeStudioObjectId).emit();
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)codeStudioObject);
    }

    @AuditedCall(value={"msgType", "code-studio-object-state", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-state"})
    public void getState(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.getState(authCtx, codeStudio));
    }

    @AuditedCall(value={"msgType", "code-studio-object-try-restart-server", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/try-restart-server"})
    public void tryRestartServer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam(required=true) String exposedLabel) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.tryRestartServer(authCtx, codeStudio, exposedLabel));
    }

    @AuditedCall(value={"msgType", "code-studio-object-open-file", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/open-file"})
    public void openfile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam(required=true) String zone, @RequestParam(required=true) String fileToOpen) throws Exception {
        CodeStudioRuntime runtime;
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            runtime = this.codeStudioRuntimeManager.getRuntimeOrNull(authCtx, codeStudio);
            if (runtime == null) {
                throw new IllegalStateException("Code Studio is not running");
            }
            fileToOpen = runtime.getUserFacingFileName(fileToOpen, zone);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.openFile(authCtx, runtime, codeStudio, zone, fileToOpen));
    }

    @AuditedCall(value={"msgType", "code-studio-object-restart", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/restart"})
    public void restart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authCtx.failIfNoSafeCode("Code Studios");
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            CodeStudioObject codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioRuntimeManager.restart(authCtx, codeStudio));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-object-stop", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/stop"})
    public void stop(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            CodeStudioObject codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioRuntimeManager.stop(authCtx, codeStudio, null));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-object-command", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/issue-command"})
    public void issueCommand(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String commandType, @RequestParam(required=false) String commandParams, @RequestParam(required=false, defaultValue="FIRE_AND_FORGET") CodeStudioMeta.CodeStudioCommandBehavior behavior) throws Exception {
        CodeStudioRuntime runtime;
        AuthCtx authCtx;
        JsonObject params = StringUtils.isNotBlank((String)commandParams) ? (JsonObject)JSON.parse((String)commandParams, JsonObject.class) : null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            authCtx.failIfNoSafeCode("Code Studios");
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            CodeStudioObject codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            runtime = this.codeStudioRuntimeManager.getRuntimeOrNull(authCtx, codeStudio);
            if (runtime == null) {
                throw new IllegalStateException("Code Studio is not running");
            }
            CodeStudioMeta.CodeStudioCustomCommand customAction = runtime.getCustomCommand(commandType);
            if (customAction == null) {
                this.codeStudioObjectsService.checkCommandPerm(authCtx, codeStudio, commandType);
            } else {
                commandType = "run_command_line";
                params = new JsonObject();
                params.addProperty("useShell", Boolean.valueOf(true));
                params.addProperty("commandString", customAction.command);
            }
        }
        if (behavior.shouldWait()) {
            CodeStudiosController.writeJSON((HttpServletResponse)resp, runtime.enqueueCommandAndWait(authCtx, commandType, params));
        } else {
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)runtime.enqueueCommand(commandType, params));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-object-state", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-run-info"})
    public void getRunInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            CodeStudioObject codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.getRunInfo(authCtx, codeStudio));
        }
    }

    @AuditedCall(value={"msgType", "code-studio-object-list-logs", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/list-logs"})
    public void listLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        RunLogsUtils.RunLogsList runs;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            runs = this.codeStudioObjectsService.listLogs(authCtx, projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)runs);
    }

    @AuditedCall(value={"msgType", "code-studio-object-log", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-log-tail"})
    public void getCodeStudioLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String runId, @RequestParam String logFilename) throws Exception {
        SmartLogTail logTail;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
        }
        File workingDir = CodeStudioRuntime.getCodeStudioRunWorkingDir(projectKey, codeStudioObjectId, runId);
        File logFile = DKUFileUtils.getWithin((File)workingDir, (String[])new String[]{logFilename});
        if (logFile.exists() && logFile.length() > 0L) {
            logTail = DKUtils.smartTailFile((File)logFile, (int)500);
        } else {
            logTail = new SmartLogTail();
            logTail.appendLine("Empty file");
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().withJSON("logTail", (Object)logTail).get());
    }

    @AuditedCall(value={"msgType", "code-studio-object-log", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-raw-log"})
    public void getCodeStudioRawLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String runId, @RequestParam String logFilename) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
        }
        File workingDir = CodeStudioRuntime.getCodeStudioRunWorkingDir(projectKey, codeStudioObjectId, runId);
        File logFile = DKUFileUtils.getWithin((File)workingDir, (String[])new String[]{logFilename});
        this.writeLog(resp, workingDir, logFile, logFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(HttpServletResponse resp, File runDir, File logFile, String filename) throws IOException {
        block10: {
            if (DKUFileUtils.isWithin((File)runDir, (File)logFile) && logFile.isFile() && logFile.canRead()) {
                resp.setContentType("text/plain; charset=UTF-8");
                resp.setHeader("Content-Disposition", "inline; filename=\"" + filename + ".log\"");
                resp.setStatus(200);
                try (FileInputStream input = null;
                     BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                    input = new FileInputStream(logFile);
                    IOUtils.copy((InputStream)input, (OutputStream)bos);
                    break block10;
                }
            }
            resp.setStatus(404);
            resp.getWriter().write("run log not found " + logFile.getAbsolutePath());
        }
    }

    @AuditedCall(value={"msgType", "code-studio-object-files", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/list-container-files"})
    public void listContainerFiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String path) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.listContainerFiles(authCtx, codeStudio, path));
    }

    @AuditedCall(value={"msgType", "code-studio-object-files", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/preview-container-file"})
    public void previewContainerFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam String path) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.previewContainerFile(authCtx, codeStudio, path));
    }

    @AuditedCall(value={"msgType", "code-studio-current-users", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-current-usage"})
    public void getCurrentUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        CodeStudioObjectsService.CodeStudioObjectUsage usage;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasPartialAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            usage = this.codeStudioObjectsService.getCurrentUsage(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)usage);
    }

    @AuditedCall(value={"msgType", "code-studio-files", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/pull/{zone:.+}"})
    public void pullBundleFromCodeStudio(HttpServletRequest req, HttpServletResponse resp, @PathVariable String zone, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam(required=false, defaultValue="false") boolean force) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, this.codeStudioRuntimeManager.pullBundleFromCodeStudio(authCtx, zone, codeStudio, force));
    }

    @AuditedCall(value={"msgType", "code-studio-files", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/check-conflicts"})
    public void checkConflictsFromCodeStudio(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam(value="zones", defaultValue="[]") String zonesStr) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        List zones = (List)JSON.parse((String)zonesStr, (TypeToken)new TypeToken<List<String>>(){});
        logger.info((Object)("Check conflicts on " + zonesStr));
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            authCtx.failIfNoSafeCode("Code Studio");
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.checkConflictsFromCodeStudio(authCtx, codeStudio, zones));
    }

    @AuditedCall(value={"msgType", "code-studio-files", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/get-changes"})
    public void getChangesFromCodeStudio(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId) throws Exception {
        CodeStudioObject codeStudio;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudio = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
        }
        CodeStudiosController.writeJSON((HttpServletResponse)resp, (Object)this.codeStudioRuntimeManager.getChangesFromCodeStudio(authCtx, codeStudio));
    }

    @AuditedCall(value={"msgType", "code-studio-protected-view"})
    @RequestMapping(value={"/api/code-studio-objects/check-access/{projectKey}/{codeStudioObjectId}/"})
    public void checkAccess(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioObjectId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getUserNoXSRF(req);
            if (authCtx == null) {
                resp.setHeader("X-DKU-studioUrl", RemoteRunNetworkingUtils.getStudioExternalURL());
                resp.setHeader("X-DKU-accessForbiddenReason", "The Code Studio cannot be accessed without being logged into <a target=\"_parent\" href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS</a>.");
                throw new NotLoggedInException("Not logged in DSS");
            }
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                resp.setHeader("X-DKU-studioUrl", RemoteRunNetworkingUtils.getStudioExternalURL());
                resp.setHeader("X-DKU-accessForbiddenReason", "The Code Studio cannot be accessed with the current credentials. Use a different <a target=\"_parent\" href=\"" + RemoteRunNetworkingUtils.getStudioExternalURL() + "\">DSS login</a>");
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
        }
    }

    @AuditedCall(value={"msgType", "code-studio-standalone-view", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/standalone-view/{projectKey}/{codeStudioObjectId}/{exposedPort}/"})
    public void standaloneView(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String codeStudioObjectId, @PathVariable int exposedPort) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getUserNoXSRF(req);
            if (authCtx == null) {
                throw new NotLoggedInException("Not logged in DSS");
            }
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
        }
        String template = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"code-studios", "standalone_view.html"}));
        CodeStudiosController codeStudiosController = this;
        String html = template.replaceAll("__DKU_PROJECT_KEY__", projectKey).replaceAll("__DKU_CODE_STUDIO_ID__", codeStudioObjectId).replaceAll("__DKU_CODE_STUDIO_EXPOSED_PORT__", Integer.toString(exposedPort)).replaceAll("__DKU_XSRF_COOKIE_NAME__", codeStudiosController.authService.getXSRFCookieName());
        CodeStudiosController.writeHTML((HttpServletResponse)resp, (String)html);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AuditedCall(value={"msgType", "code-studio-objects-diagnostic", "projectKey", "${projectKey}", "codeStudioObjectId", "${codeStudioObjectId}"})
    @RequestMapping(value={"/api/code-studio-objects/download-diagnosis"})
    public void downloadRuntimeDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String codeStudioObjectId, @RequestParam(required=false) String runId) throws Exception {
        File runDir;
        CodeStudioObject codeStudioObject;
        CodeStudioTemplatesService.CodeStudioTemplateFullInfo codeStudioTemplate = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!this.codeStudioObjectsService.hasFullAccess(authCtx, projectKey, codeStudioObjectId)) {
                throw new UnauthorizedException("Not owner of the Code Studio", "code-studio-object-read");
            }
            codeStudioObject = this.codeStudioObjectsService.getMandatory(projectKey, codeStudioObjectId);
            if (this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioObject.templateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE)) {
                codeStudioTemplate = this.codeStudioTemplatesService.getFullInfo(authCtx, codeStudioObject.templateId);
            }
        }
        File file = runDir = StringUtils.isBlank((String)runId) ? CodeStudioRuntime.getLatestCodeStudioRunWorkingDir(projectKey, codeStudioObjectId) : CodeStudioRuntime.getCodeStudioRunWorkingDir(projectKey, codeStudioObjectId, runId);
        if (runDir == null) {
            resp.setStatus(404);
            resp.getWriter().write("no runs found");
            return;
        }
        if (runDir.exists()) {
            String runDirName = runDir.getName();
            String filename = "dss-csio-diag-" + projectKey + "-" + codeStudioObjectId + "_" + runDirName;
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + ".zip\"");
            resp.setStatus(200);
            try (ZipUnzipDir.ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(new BufferedOutputStream((OutputStream)resp.getOutputStream()));){
                zipBuilder.addDirectoryIfExists(runDirName + "/", runDir, true);
                File runtimeDefFile = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", projectKey, "code_studios", codeStudioObjectId + ".json"});
                zipBuilder.addFile(runtimeDefFile.getName(), runtimeDefFile);
                if (codeStudioTemplate == null) return;
                File templateDefFile = ApplicationConfigurator.getFile((String[])new String[]{"config", "code_studio_templates", codeStudioObject.templateId + ".json"});
                zipBuilder.addFile("template/" + templateDefFile.getName(), templateDefFile);
                File templateBuildDir = ApplicationConfigurator.getFile((String[])new String[]{"tmp", "code-studio-build", codeStudioObject.templateId, codeStudioTemplate.latestBuild.buildId.replaceFirst("_[0-9]*$", "")});
                File templateBuildLogFile = DKUFileUtils.getWithin((File)templateBuildDir, (String[])new String[]{"build.log"});
                zipBuilder.addFileIfExists("template/" + templateBuildLogFile.getName(), templateBuildLogFile);
                File templateDockerFile = DKUFileUtils.getWithin((File)templateBuildDir, (String[])new String[]{"docker-build", "Dockerfile"});
                zipBuilder.addFileIfExists("template/" + templateDockerFile.getName(), templateDockerFile);
                File templateDockerLogFile = DKUFileUtils.getWithin((File)templateBuildDir, (String[])new String[]{"docker-build", "docker.log"});
                zipBuilder.addFileIfExists("template/" + templateDockerLogFile.getName(), templateDockerLogFile);
                return;
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("run dir not found");
        }
    }

    public static class CodeStudioObjectCreateResponse {
        public CodeStudioObject codeStudio;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }
}

