/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.dev.PluginsGitService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.git.jgit.DSSVersionForCommitResponse;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DevPluginsGitController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PluginsGitService pluginsGitService;
    @Autowired
    private FutureService futureService;
    private static Logger logger = Logger.getLogger((String)"dku.controllers.devplugins.git");

    @AuditedCall(value={"msgType", "plugins-git-commit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/commit"})
    public void commit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String commitMessage) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        if (!ApplicationConfigurator.getGeneralSettings().pluginDevExplicitCommit) {
            throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_COMMIT_FAILED, "Explicit commits for plugin development are not enabled.");
        }
        this.pluginsGitService.commit_NT(authCtx, pluginId, commitMessage);
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugins-git-prepare-commit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/prepare-commit"})
    public void prepareCommit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.getCommitDiff(pluginId));
    }

    @AuditedCall(value={"msgType", "plugins-git-log", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-log"})
    public void gitLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String since, @RequestParam(required=false) String count) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.getLog_NT(pluginId, since, count != null ? Integer.valueOf(count) : -1));
    }

    @AuditedCall(value={"msgType", "plugins-git-pull", "pluginId", "${pluginId}", "remoteName", "${remoteName}"})
    @RequestMapping(value={"/api/plugins-git/git-pull"})
    public void gitPull(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String pluginId, final @RequestParam(required=false, defaultValue="origin") String remoteName, final @RequestParam(required=false, defaultValue="") String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<GitRemoteCommands.GitCommandResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected GitRemoteCommands.GitCommandResult compute() throws Exception {
                return DevPluginsGitController.this.pluginsGitService.pullRebase_NT(pluginId, remoteName, branchName, authCtx, this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"plugin_git_pull", (String)"Git pull - plugin changes");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<GitRemoteCommands.GitCommandResult>>(){}));
    }

    @AuditedCall(value={"msgType", "plugins-git-fetch", "pluginId", "${pluginId}", "remoteName", "${remoteName}"})
    @RequestMapping(value={"/api/plugins-git/git-fetch"})
    public void gitPull(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String pluginId, final @RequestParam(required=false, defaultValue="origin") String remoteName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<GitRemoteCommands.GitCommandResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected GitRemoteCommands.GitCommandResult compute() throws Exception {
                return DevPluginsGitController.this.pluginsGitService.fetch_NT(pluginId, remoteName, authCtx, this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"plugin_git_fetch", (String)"Git fetch - plugin changes");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<GitRemoteCommands.GitCommandResult>>(){}));
    }

    @AuditedCall(value={"msgType", "plugins-git-push", "pluginId", "${pluginId}", "remoteName", "${remoteName}"})
    @RequestMapping(value={"/api/plugins-git/git-push"})
    public void gitPush(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String pluginId, final @RequestParam(required=false, defaultValue="origin") String remoteName, final @RequestParam(required=false, defaultValue="") String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<GitRemoteCommands.GitCommandResult>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected GitRemoteCommands.GitCommandResult compute() throws Exception {
                return DevPluginsGitController.this.pluginsGitService.push_NT(authCtx, pluginId, remoteName, branchName, this.logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"plugin_git_push", (String)"Git push - plugin changes");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<GitRemoteCommands.GitCommandResult>>(){}));
    }

    @AuditedCall(value={"msgType", "dss-version-commit", "pluginId", "${pluginId}", "hash", "${hash}"})
    @RequestMapping(value={"/api/plugins-git/dss-version-commit"})
    public void getDSSVersionForASpecificCommit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String hash) throws GitAPIException, IOException, UnauthorizedException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)new DSSVersionForCommitResponse(null, false));
    }

    @AuditedCall(value={"msgType", "plugins-git-full-status", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-full-status"})
    public void getFullStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.getFullStatus_NT(pluginId));
    }

    @AuditedCall(value={"msgType", "plugins-git-reset-to-upstream", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-reset-to-upstream"})
    public void resetToUpstream(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String remoteName, @RequestParam String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.pluginsGitService.resetToUpstream_NT(authCtx, pluginId, remoteName, branchName);
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugins-git-reset-to-head", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-reset-to-head"})
    public void resetToHead(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.pluginsGitService.resetToHead_NT(pluginId);
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugins-git-list-branches", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-list-branches"})
    public void listBranches(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, this.pluginsGitService.listAvailableBranches_NT(pluginId));
    }

    @AuditedCall(value={"msgType", "plugins-git-delete-branches", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-delete-branches"})
    public void deleteBranches(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam List<String> branchNames, @RequestParam boolean forceDelete, @RequestParam(defaultValue="origin") String remoteName, @RequestParam boolean remoteDelete) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        GitModel.GitBranches existingBranches = this.pluginsGitService.listBranches_NT(pluginId);
        for (String branchName : branchNames) {
            if (existingBranches.local.contains(branchName)) {
                try {
                    this.pluginsGitService.deleteLocalBranch_NT(pluginId, branchName, forceDelete);
                }
                catch (NotMergedException e) {
                    logger.info((Object)"Cannot delete branch as it contains unmerged changes", (Throwable)e);
                    throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_DELETE_UNMERGED_BRANCH_FAILED, String.format("To delete '%s', select the option to delete branches even if they have not been merged, and try again.", branchName));
                }
            }
            if (!StringUtils.isNotBlank((String)remoteName) || !existingBranches.remote.contains(remoteName + "/" + branchName)) continue;
            this.pluginsGitService.deleteRemoteBranch_NT(authCtx, pluginId, branchName, forceDelete, remoteDelete, remoteName);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugins-git-create-branch", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-create-branch"})
    public void createBranch(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String branchName, @RequestParam(required=false) String commitId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.createBranch_NT(authCtx, pluginId, branchName, commitId));
    }

    @AuditedCall(value={"msgType", "plugins-git-switch-branch", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-switch-branch"})
    public void switchBranch(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String branchName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.checkoutBranch_NT(authCtx, pluginId, branchName));
    }

    @AuditedCall(value={"msgType", "plugins-git-set-remote-repository", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-set-remote"}, method={RequestMethod.POST})
    public void setRemote(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String remoteName, @RequestParam String remoteUrl) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        String result = this.pluginsGitService.addOrSetRepository_NT(pluginId, remoteName, remoteUrl, authCtx);
        this.pluginsGitService.setUpstreamForLocalBranches_NT(authCtx, remoteName, pluginId);
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "plugins-git-rm-remote-repository", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/api/plugins-git/git-rm-remote"})
    public void rmRemote(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String remoteName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.removeRemoteRepository_NT(pluginId, remoteName, authCtx));
    }

    @AuditedCall(value={"msgType", "plugin-get-commit-diff", "pluginId", "${pluginId}", "commitId", "${commitId}"})
    @RequestMapping(value={"/api/plugins-git/get-commit-diff"})
    public void getObjectLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String commitId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.getSingleCommitDiff(pluginId, commitId));
    }

    @AuditedCall(value={"msgType", "plugin-get-revision-diff", "pluginId", "${pluginId}", "commitFrom", "${commitFrom}", "commitTo", "${commitTo}"})
    @RequestMapping(value={"/api/plugins-git/get-revisions-diff"})
    public void getRevisionsDiff(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String commitFrom, @RequestParam String commitTo) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.getObjectDiff(pluginId, commitFrom, commitTo));
    }

    @AuditedCall(value={"msgType", "plugin-revert", "pluginId", "${pluginId}", "toRevision", "${hash}"})
    @RequestMapping(value={"/api/plugins-git/revert-plugin-to-revision"})
    public void revertPluginToRevision(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String hash) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.pluginsGitService.revertPluginToRevision_NT(authCtx, pluginId, hash);
    }

    @AuditedCall(value={"msgType", "plugin-revert-commit", "pluginId", "${pluginId}", "commitId", "${hash}"})
    @RequestMapping(value={"/api/plugins-git/revert-single-commit"})
    public void revertSingleCommit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String hash) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        DevPluginsGitController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.revertSingleCommit_NT(authCtx, pluginId, hash));
    }

    @AuditedCall(value={"msgType", "plugin-add-git-tag", "pluginId", "${pluginId}", "reference", "${reference}", "name", "${name}"})
    @RequestMapping(value={"/api/plugins-git/tag"}, method={RequestMethod.POST})
    public void addObjectTag(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam(required=false) String reference, @RequestParam String name, @RequestParam(required=false) String message) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(user);
        }
        if (GitModel.GitTag.isReadOnly((String)name)) {
            throw new IllegalArgumentException("You can't add a tag beginning with 'dss-'");
        }
        this.pluginsGitService.addTag_NT(user, pluginId, name, message, reference);
    }

    @AuditedCall(value={"msgType", "plugin-remove-git-tag", "pluginId", "${pluginId}", "name", "${name}"})
    @RequestMapping(value={"/api/plugins-git/remove-tag"}, method={RequestMethod.POST})
    public void removeObjectTag(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkDevelopPluginPrivilege(user);
        }
        if (GitModel.GitTag.isReadOnly((String)name)) {
            throw new IllegalArgumentException("You can't remove a read-only tag");
        }
        this.pluginsGitService.removeTag_NT(pluginId, name);
    }
}

