/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.SerializedExportOption;
import com.dataiku.dip.export.input.BindableExportInput;
import com.dataiku.dip.export.input.ExportUIDataInput;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.AvroFormatMeta;
import com.dataiku.dip.formats.custom.CustomFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.excel.ExcelFormatExtractor;
import com.dataiku.dip.formats.geo.GeoJSONFormatExtractor;
import com.dataiku.dip.formats.geo.ShapefileFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ExportController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private CustomPythonExportersService customPythonExportersService;
    @Autowired
    private CustomJavaExportersService customJavaExportersService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static final Logger logger = Logger.getLogger((String)"dssplugin.qvx.output");

    @AuditedCall(value={"msgType", "exports-list"})
    @RequestMapping(value={"/api/exports/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String userFilter;
        try (Transaction t = this.transactionService.beginRead();){
            userFilter = this.authService.getMandatoryUser(req).getIdentifier();
        }
        ExportController.writeJSON((HttpServletResponse)resp, this.exportService.listExports(userFilter));
    }

    @AuditedCall(value={"msgType", "exports-clear"})
    @RequestMapping(value={"/api/exports/clear"})
    public void clear(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="CURRENT_USER", required=false) String user) throws Exception {
        String userFilter = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            userFilter = this.authService.getMandatoryUser(req).getIdentifier();
            if ("CURRENT_USER".equals(user)) {
            } else if ("ALL_USERS".equals(user)) {
                this.authService.failIfNotAdmin(req);
                userFilter = null;
            } else {
                userFilter = user;
            }
        }
        for (ExportStatus s : this.exportService.listExports(userFilter)) {
            if (s.state != JobState.FAILED && s.state != JobState.DONE && s.state != JobState.ABORTED) continue;
            this.exportService.removeExport(s.exportId);
        }
    }

    @AuditedCall(value={"msgType", "export-remove", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/exports/remove"})
    public void remove(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportId) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
        }
        this.exportService.removeExport(exportId);
    }

    @AuditInline
    @RequestMapping(value={"/api/exports/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="Unbound") String name, @RequestParam String params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            BindableExportInput input = new BindableExportInput(name, 30000L);
            ExportStatus ret = this.exportService.handleExportRequest(this.authService.getUser(req), input, exportParams);
            ExportController.writeJSON((HttpServletResponse)resp, (Object)ret);
            this.auditTrailService.generic("export-create").with("inputName", input.describe().name).with("inputProjectKey", input.describe().projectKey).with("exportId", ret.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("export-create", (Throwable)e).with("name", name).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/exports/download"})
    public void download(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            ExportStatus status = this.exportService.getExport(exportId);
            if (!StringUtils.equals((String)user.getIdentifier(), (String)status.userId) && !user.isAdmin()) {
                throw ErrorContext.iae((String)"You're not allowed to download this export, sorry");
            }
            t.close();
            long downloadSize = this.exportService.handleDownloadRequest(exportId, resp, user);
            this.auditTrailService.generic("export-download").with("exportId", exportId).with("downloadSize", (Number)downloadSize).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("export-download", (Throwable)e).with("exportId", exportId).emit();
            throw e;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/exports/get-export-options"})
    public void getExportOptions(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        SerializedExportOptions ret = new SerializedExportOptions();
        ret.options.addAll(this.getBuiltinFormatExportOptions());
        this.getStream(this.customPythonFormatsService.list(), this.customJavaFormatsService.list()).filter(format -> ((CustomFormatDesc)format.desc).exportOptions != null).filter(format -> ((CustomFormatDesc)format.desc).canWrite).flatMap(format -> ((CustomFormatDesc)format.desc).exportOptions.stream().map(exportOption -> new SerializedExportOption.FromFormat(format.id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)exportOption)), exportOption.label, SerializedExportOption.ExportOptionType.CUSTOM_FORMAT, format.getType(), exportOption.canStream, exportOption.predefinedConfig, format.getOwnerPluginId()))).forEach(ret.options::add);
        this.getStream(this.customPythonExportersService.list(), this.customJavaExportersService.list()).filter(exporter -> ((CustomExporterDesc)exporter.desc).exportOptions != null).flatMap(exporter -> ((CustomExporterDesc)exporter.desc).exportOptions.stream().map(exportOption -> {
            SerializedExportOption.ExportOptionType exportOptionType = switch (((CustomExporterDesc)exporter.desc).exportBehavior) {
                default -> throw new IncompatibleClassChangeError();
                case CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE -> SerializedExportOption.ExportOptionType.CUSTOM_TO_FILE;
                case CustomExporterDesc.ExportBehavior.MANAGES_OUTPUT -> SerializedExportOption.ExportOptionType.CUSTOM_MANAGED;
            };
            return new SerializedExportOption.FromExporter(exporter.id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)exportOption)), exportOption.label, exportOptionType, exporter.getType(), exportOption.canStream, exportOption.predefinedConfig, exporter.getOwnerPluginId());
        })).forEach(ret.options::add);
        ExportController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/exports/export-ui-data"})
    public void exportUIData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ExportUIDataInput.ExportableUIData euid = (ExportUIDataInput.ExportableUIData)JSON.parse((String)data, ExportUIDataInput.ExportableUIData.class);
            ExportUIDataInput input = new ExportUIDataInput(euid);
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            exportParams.filenameBase = euid.name;
            ExportStatus ret = this.exportService.handleExportRequest(this.authService.getUser(req), input, exportParams);
            ExportController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @SafeVarargs
    @NotNull
    private <T> Stream<T> getStream(Collection<? extends T> ... collections) {
        return Arrays.stream(collections).flatMap(Collection::stream);
    }

    private List<SerializedExportOption> getBuiltinFormatExportOptions() {
        ArrayList<SerializedExportOption> builtinExportOptions = new ArrayList<SerializedExportOption>();
        CSVFormatConfig csvFormatConfig = CSVFormatConfig.getStandardTabExcelFormat();
        csvFormatConfig.parseHeaderRow = true;
        csvFormatConfig.setSeparatorStr(",");
        builtinExportOptions.add(new SerializedExportOption.FromFormat("tsv-excel-header", "CSV (*.csv)", SerializedExportOption.ExportOptionType.BUILTIN_FORMAT, CSVFormatExtractor.META.getType(), true, csvFormatConfig));
        if (BuiltinsLoader.apachePoiAvailable()) {
            builtinExportOptions.add(new SerializedExportOption.FromFormat("excel", "Excel (*.xlsx)", SerializedExportOption.ExportOptionType.BUILTIN_FORMAT, ExcelFormatExtractor.META.getType(), false, new ExcelFormatExtractor.Config()));
        }
        CSVFormatConfig csvFormatConfigGzip = CSVFormatConfig.getStandardTabExcelFormat();
        csvFormatConfig.parseHeaderRow = true;
        csvFormatConfigGzip.setSeparatorStr(",");
        csvFormatConfigGzip.compress = "gz";
        builtinExportOptions.add(new SerializedExportOption.FromFormat("tsv-excel-header-gz", "Compressed CSV (*.csv.gz)", SerializedExportOption.ExportOptionType.BUILTIN_FORMAT, CSVFormatExtractor.META.getType(), true, csvFormatConfigGzip));
        builtinExportOptions.add(new SerializedExportOption.FromFormat("avro", "AVRO (*.avro)", SerializedExportOption.ExportOptionType.BUILTIN_FORMAT, AvroFormatMeta.META.getType(), true, new AvroFormatConfig()));
        builtinExportOptions.add(new SerializedExportOption.FromFormat("geojson", "GeoJSON (*.geojson)", SerializedExportOption.ExportOptionType.BUILTIN_FORMAT, GeoJSONFormatExtractor.META.getType(), true, new GeoJSONFormatExtractor.Config()));
        builtinExportOptions.add(new SerializedExportOption.FromFormat("shapefile", "Shapefile (*.shp)", SerializedExportOption.ExportOptionType.BUILTIN_FORMAT, ShapefileFormatExtractor.META.getType(), false, new ShapefileFormatExtractor.Config()));
        return builtinExportOptions;
    }

    public static class SerializedExportOptions {
        List<SerializedExportOption> options = Lists.newArrayList();
    }
}

