/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.semanticmodels.SemanticModel;
import com.dataiku.dip.semanticmodels.SemanticModelsCRUDService;
import com.dataiku.dip.semanticmodels.SemanticModelsDAO;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.Id;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SemanticModelsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SemanticModelsDAO semanticModelsDAO;
    @Autowired
    private SemanticModelsCRUDService semanticModelsCRUDService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;

    @AuditedCall(value={"msgType", "semantic-models-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/semantic-models/list"})
    @ResponseBody
    public List<SemanticModel> list(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<SemanticModel> list = this.semanticModelsDAO.listUnsafe(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "semantic-models-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/semantic-models/list-heads"})
    @ResponseBody
    public List<SemanticModel.SemanticModelListItem> listHeads(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<SemanticModel.SemanticModelListItem> heads = new ArrayList<SemanticModel.SemanticModelListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List list = this.semanticModelsDAO.listUnsafe(projectKey);
            for (SemanticModel semanticModel : list) {
                SemanticModel.SemanticModelListItem item = new SemanticModel.SemanticModelListItem(semanticModel);
                this.taggableObjectsService.setEditionInfoFromTags(semanticModel, item);
                heads.add(item);
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        return heads;
    }

    @AuditedCall(value={"msgType", "semantic-model-get", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/semantic-models/get"}, method={RequestMethod.GET})
    @ResponseBody
    public SemanticModel get(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws IOException, DKUSecurityException, CodedException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SemanticModel semanticModel = (SemanticModel)this.semanticModelsDAO.getMandatory(projectKey, id);
            return semanticModel;
        }
    }

    @AuditedCall(value={"msgType", "semantic-model-get-metadata", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/semantic-models/get-full-info"})
    @ResponseBody
    public NavigatorService.SemanticModelFullInfo getFullInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.SemanticModelFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoTaggableObjectReadUseAccess(u, ITaggingService.TaggableType.SEMANTIC_MODEL, loc, projectKey);
            info = this.navigatorService.getSemanticModelFullInfo(loc, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditInline
    @RequestMapping(value={"/api/semantic-models/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Id create(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        Id newId;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            newId = new Id(this.semanticModelsCRUDService.create(user, projectKey, name));
            t.commit("Created semantic model " + projectKey + "." + name + " (id: " + newId.id + ")");
            this.auditTrailService.generic("semantic-model-create").with("projectKey", projectKey).with("semanticModelId", newId.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("semantic-model-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
        return newId;
    }

    @AuditInline
    @RequestMapping(value={"/api/semantic-models/save"}, method={RequestMethod.POST})
    @ResponseBody
    public SemanticModel save(HttpServletRequest req, @RequestParam SemanticModel semanticModel, @RequestParam(required=false) String commitMessage, @RequestParam(required=false) String saveInfo) throws Exception {
        SemanticModel savedSemanticModel;
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), semanticModel.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            savedSemanticModel = this.semanticModelsCRUDService.save(semanticModel, si.summaryOnly);
            if (si.summaryOnly) {
                t.commit("Updated summary for semantic model " + savedSemanticModel.projectKey + "." + savedSemanticModel.name + " (id: " + savedSemanticModel.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage);
            } else {
                t.commit("Saved semantic model " + savedSemanticModel.projectKey + "." + savedSemanticModel.name + " (id: " + savedSemanticModel.id + ")");
            }
            this.auditTrailService.generic("semantic-model-save").with("projectKey", savedSemanticModel.projectKey).with("semanticModelId", savedSemanticModel.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("semantic-model-save", (Throwable)e).with("projectKey", semanticModel.projectKey).with("semanticModelId", semanticModel.id).emit();
            throw e;
        }
        return savedSemanticModel;
    }
}

