/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMAllocationTagsUtils;
import com.dataiku.dip.llm.LLMAuditHelper;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.LLMMeshClientFactory;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ReflectedEventEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CodeAssistantIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/api/tintercom/code-assistant/chat-completion"}, method={RequestMethod.POST})
    public LLMClient.SimpleCompletionResponseOrError chatCompletion(HttpServletRequest req, HttpServletResponse resp, @RequestBody CompletionRequest completionRequest, @RequestParam(required=false) String userLlmId) throws Exception {
        String llmId;
        GeneralSettingsDAO.GeneralSettings generalSettings;
        try (Transaction ignored = this.transactionService.beginRead();){
            generalSettings = this.generalSettingsService.read();
        }
        if (!generalSettings.codeAssistantSettings.codeAssistantEnabled) {
            throw new UnauthorizedException("AI Code Assistant: Feature is not enabled in your Dataiku instance. Contact your instance administrator.", "denied");
        }
        String string = llmId = userLlmId == null || userLlmId.isEmpty() ? generalSettings.codeAssistantSettings.codeAssistantDefaultLlmId : userLlmId;
        if (StringUtils.isEmpty((CharSequence)llmId)) {
            throw new IllegalArgumentException("AI Code Assistant: no connection set. Contact your instance administrator.");
        }
        try (APITicketService.TicketUsage authCtxUsage = this.authService.getAndUseMandTicket(req);){
            LLMClient.SimpleCompletionResponseOrError simpleCompletionResponseOrError;
            block24: {
                AuthCtx authCtx = authCtxUsage.getAuthCtx();
                ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsage(req, (AuthCtxUsage)authCtxUsage);
                String ticketId = authCtxUsage.getTicket().id;
                String projectKey = ticketId.substring(ticketId.indexOf(":") + 1, ticketId.indexOf("."));
                if (projectKey.startsWith("Code Studio ")) {
                    projectKey = projectKey.substring(12);
                }
                LLMStructuredRef llmRef = LLMStructuredRef.decodeId(llmId);
                GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, projectKey, llmRef);
                GuardrailsPipelineSettings usageTimeGuardrailsPipelineSettings = null;
                GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, usageTimeGuardrailsPipelineSettings);
                LLMMeshClient llmMeshClient = LLMMeshClientFactory.get(authCtx, projectKey, llmRef, guardrailsPipelineSettings, null, 1);
                try {
                    ComputeResourceUsage cru;
                    EnrichedLLMStructuredRef enrichedLLMRef = llmMeshClient.getEnrichedRef();
                    LLMClient.SingleCompletionQuery query = completionRequest.query;
                    List<LLMClient.SimpleCompletionResponseOrError> responses = llmMeshClient.completeQueries(Collections.singletonList(query), completionRequest.settings);
                    LLMClient.SimpleCompletionResponseOrError response = responses.get(0);
                    if (ticketId.startsWith("Code Studio")) {
                        CodeStudioObject codeStudioObject = authCtxUsage.getTicket().payload != null && authCtxUsage.getTicket().payload instanceof CodeStudioObject ? (CodeStudioObject)authCtxUsage.getTicket().payload : null;
                        CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forCodeStudio((AuthCtx)authCtx, (String)projectKey, (String)(codeStudioObject == null ? null : codeStudioObject.id), (String)(codeStudioObject == null ? null : codeStudioObject.templateId)));
                    }
                    if ((cru = llmMeshClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION)) != null) {
                        LLMAllocationTagsUtils.addAllocationTagsToCRU(query, cru);
                        this.cruReportingService.reportComplete(cru);
                    }
                    LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded(this.auditTrailService, enrichedLLMRef, llmMeshClient.getConnection(), query, response);
                    IReflectedEventsService.ReflectedEvent event = new IReflectedEventsService.ReflectedEvent("code_assistant_llm_query", JSON.toJsonObject((Object)ImmutableMap.of((Object)"llmType", (Object)enrichedLLMRef.type.toString(), (Object)"clientType", (Object)(ticketId.startsWith("jupyter") ? "Jupyter Notebook" : "Code Studio")), (String[])new String[0]));
                    this.pubSubService.publish((DSSEvent)new ReflectedEventEvent(event));
                    simpleCompletionResponseOrError = response;
                    if (llmMeshClient == null) break block24;
                }
                catch (Throwable throwable) {
                    if (llmMeshClient != null) {
                        try {
                            llmMeshClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                llmMeshClient.close();
            }
            return simpleCompletionResponseOrError;
        }
    }

    @RequestMapping(value={"/api/code-assistant/list-available-llms"})
    @ResponseBody
    public PretrainedModelsService.ModelsList listAvailableLLMs(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.uiAuthService.getMandatoryUser(req);
            PretrainedModelsService.ModelsList modelsList = this.pretrainedModelsService.listAvailableLLMs(authCtx, "fakeProject", AbstractLLMConnection.LLMUsagePurpose.valueOf("GENERIC_COMPLETION"));
            return modelsList;
        }
    }

    public static class CompletionRequest {
        public LLMClient.SingleCompletionQuery query;
        public LLMClient.CompletionSettings settings;
    }
}

