/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.SlowBackendCodeContext;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.UserEditable;
import com.dataiku.dip.transactions.impl.YOLOTransactionImpl;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.utils.SlowCodeReporter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackendTransactionService
implements TransactionService {
    @Autowired
    private SpringUtils unused;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private MetaAuthService metaAuthService;
    private TransactionProvider provider;
    private final File configDir;
    public static final String[] DKU_CONFIG_COMMON_FILES = new String[]{"public-apikeys.json", "personal-apikeys.json", "users.json", "connections.json", "general-settings.json", "users.json", "internal-apikeys.json", "configkey.json"};
    private final SlowCodeReporter slowCodeReporter = new SlowCodeReporter().withEventLogging();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.transactions.service");

    public BackendTransactionService() throws IOException {
        logger.info((Object)"Instantiating backend transaction service");
        this.configDir = new File(ApplicationConfigurator.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(true, false, true, false));
        this.provider.registerMetrics("dku.transactions.fs.cache", DSSMetrics.registry());
        logger.info((Object)"Backend transaction service created");
        PerfUtils.registerSlowCodeHandler(() -> {
            TransactionRef t;
            if (TransactionContext.hasAttachedTransaction() && !((t = TransactionContext.retrieveRead()) instanceof YOLOTransactionImpl)) {
                SlowBackendCodeContext context = SlowBackendCodeContext.capture((TransactionRef)t);
                this.slowCodeReporter.report((SlowCodeReporter.SlowCodeContext)context);
            }
        });
    }

    @PostConstruct
    public void postConstruct() {
        logger.info((Object)"Init backend transaction service");
        assert (SpringUtils.getInstance() != null);
        assert (this.provider != null);
        SpringUtils.getInstance().registerSingletonBean(DebugTransactionRegistry.class, (Object)this.provider.getDebugRegistry());
        this.provider.getGitManager().postInit();
        logger.info((Object)"Done init backend transaction service");
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req, boolean checkXSRF) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        RWTransaction rw = this.provider.beginWrite(null);
        try {
            TransactionContext.attach((TransactionRef)rw);
            AuthCtx usr = checkXSRF ? this.authService.getMandatoryUser(req) : this.authService.getMandatoryUserNoXSRF(req);
            ((UserEditable)rw).setUser(usr);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req) throws IOException {
        return this.beginWriteForUI(req, true);
    }

    public RWTransaction beginWriteAsLoggedInUser(AuthCtx usr, boolean committable) {
        assert (usr != null) : "User cannot be null";
        TransactionContext.assertNoAttachedTransaction();
        RWTransaction rw = this.provider.beginWrite(usr, committable);
        try {
            ((UserEditable)rw).setUser(usr);
            TransactionContext.attach((TransactionRef)rw);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public RWTransaction beginWriteAsDSS(boolean committable) {
        DSSAuthCtx dss = DSSAuthCtx.newNone();
        return this.beginWriteAsLoggedInUser(dss, committable);
    }

    public RWTransaction beginWriteForAPI(HttpServletRequest req) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        RWTransaction rw = this.provider.beginWrite(null);
        try {
            TransactionContext.attach((TransactionRef)rw);
            AuthCtx authCtx = this.metaAuthService.getTicketOrKey(req);
            assert (authCtx != null);
            ((UserEditable)rw).setUser(authCtx);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public RWTransaction beginWriteForTicket(HttpServletRequest req) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        RWTransaction rw = this.provider.beginWrite(null);
        try {
            TransactionContext.attach((TransactionRef)rw);
            AuthCtx authCtx = this.ticketAuthService.getMandTicketAuthCtx(req);
            assert (authCtx != null);
            ((UserEditable)rw).setUser(authCtx);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public void clearCache() {
        this.provider.clearCache();
    }

    public void invalidateCache(RelFile file) {
        this.provider.invalidateCache(file);
    }

    public CachedReadFS getCache() {
        return this.provider.getCache();
    }

    public Transaction beginRead(IsolationLevel isolationLevel, @Nullable String fakeStack) {
        TransactionContext.assertNoAttachedTransaction();
        Transaction t = this.provider.beginRead(isolationLevel, fakeStack);
        TransactionContext.attach((TransactionRef)t);
        return t;
    }

    public File resolve(RelFile file) {
        return file.resolve(this.configDir);
    }

    public IGitManager getGitManager() {
        return this.provider.getGitManager();
    }

    public void performDirectCommit(DSSCommitDef def) throws IOException {
        this.provider.performDirectCommit((CommitDef)def);
    }

    public void flushPendingCommits(String projectKey) throws IOException {
        this.provider.flushPendingCommits(projectKey);
    }
}

