/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface ITaggingService {
    public TaggingService.TagsFile listTags(String var1) throws Exception;

    public Map<String, List<String>> getTagNodeMap(String var1) throws Exception;

    public Map<String, TaggingService.TagsFile> listAllTags(AuthCtx var1) throws Exception;

    public Map<String, TaggingService.TagsFile> listAllTags(AuthCtx var1, boolean var2) throws Exception;

    public TaggingService.TagsFile setTags(String var1, TaggingService.TagsFile var2, AuthCtx var3) throws Exception;

    public Boolean onObjectSaved(String var1, List<String> var2) throws IOException;

    public void executeTaggingRequest(List<TaggableObjectsService.TaggableObjectRef> var1, TaggingService.TaggingOperation var2);

    public TaggingService.TagsFile listTagsUnsafe(String var1) throws IOException;

    public static enum TaggableType {
        PROJECT,
        FLOW_ZONE,
        DATASET,
        RECIPE,
        SQL_NOTEBOOK,
        SEARCH_NOTEBOOK,
        JUPYTER_NOTEBOOK,
        ANALYSIS,
        SAVED_MODEL,
        MODEL_EVALUATION_STORE,
        INSIGHT,
        MANAGED_FOLDER,
        LAMBDA_SERVICE,
        SCENARIO,
        DASHBOARD,
        WEB_APP,
        CODE_STUDIO,
        REPORT,
        STREAMING_ENDPOINT,
        ARTICLE,
        STATISTICS_WORKSHEET,
        WORKSPACE,
        MODEL_COMPARISON,
        LABELING_TASK,
        RETRIEVABLE_KNOWLEDGE,
        PROMPT_STUDIO,
        SEMANTIC_MODEL,
        AGENT_TOOL,
        DATA_COLLECTION,
        AGENT_REVIEW,
        API_DEPLOYER_INFRA,
        API_DEPLOYER_SERVICE,
        API_DEPLOYER_DEPLOYMENT,
        PROJECT_DEPLOYER_INFRA,
        PROJECT_DEPLOYER_PROJECT,
        PROJECT_DEPLOYER_DEPLOYMENT,
        WORKSPACE_LINK,
        CODE_STUDIO_TEMPLATE,
        WORKSPACE_STORY,
        GENAI_EVALUATION_STORE,
        GENAI_COMPARISON,
        ENTERPRISE_ASSET_COLLECTION,
        ENTERPRISE_ASSET;


        public String toHumanReadableString() {
            if (this == RETRIEVABLE_KNOWLEDGE) {
                return "knowledge bank";
            }
            return this.toString().toLowerCase().replace("_", " ");
        }

        public boolean isFakeType() {
            return ImmutableList.of((Object)((Object)API_DEPLOYER_INFRA), (Object)((Object)API_DEPLOYER_SERVICE), (Object)((Object)API_DEPLOYER_DEPLOYMENT), (Object)((Object)PROJECT_DEPLOYER_INFRA), (Object)((Object)PROJECT_DEPLOYER_PROJECT), (Object)((Object)PROJECT_DEPLOYER_DEPLOYMENT), (Object)((Object)CODE_STUDIO_TEMPLATE)).contains((Object)this);
        }

        public boolean isFlowItem() {
            return ImmutableList.of((Object)((Object)DATASET), (Object)((Object)RECIPE), (Object)((Object)SAVED_MODEL), (Object)((Object)RETRIEVABLE_KNOWLEDGE), (Object)((Object)MODEL_EVALUATION_STORE), (Object)((Object)MANAGED_FOLDER), (Object)((Object)STREAMING_ENDPOINT), (Object)((Object)LABELING_TASK)).contains((Object)this);
        }

        public void assertNotFakeType() {
            if (this.isFakeType()) {
                throw new IllegalStateException("Unreachable");
            }
        }
    }
}

