/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.mail.MailIntegrationParams;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.BuildFlowItemStepRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.triggers.TemporalTriggerRunner;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScenarioScheduleService {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private TransactionService transactionService;

    public Scenario createScheduledScenario(String projectKey, ScheduleScenarioOptions options) throws Exception {
        Scenario scenario = new Scenario();
        scenario.withProjectKey(projectKey);
        scenario.withType("step_based");
        scenario.withActive(true);
        scenario.withName(options.scenarioName);
        scenario.withReporters(this.createReporters(projectKey, options));
        scenario.withTriggers(this.createScenarioTriggers(options));
        StepBasedScenarioRunner.StepBasedScenarioParams params = new StepBasedScenarioRunner.StepBasedScenarioParams();
        Step step = new Step();
        step.withType("build_flowitem");
        step.withParams(this.createBuildStepParams(projectKey, options));
        params.addSteps(step);
        scenario.withParams(params);
        return scenario;
    }

    private List<Trigger> createScenarioTriggers(ScheduleScenarioOptions options) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        if (options.triggerParams != null) {
            Trigger trigger = new Trigger();
            trigger.withType("temporal");
            trigger.withActive(true);
            trigger.withName("Time based");
            trigger.withDelay(5);
            trigger.withParams(options.triggerParams);
            triggers.add(trigger);
        }
        return triggers;
    }

    private List<ScenarioReporter> createReporters(String projectKey, ScheduleScenarioOptions options) throws Exception {
        ArrayList<ScenarioReporter> reporters = new ArrayList<ScenarioReporter>();
        if (options.mail != null) {
            ScenarioReporter reporter = new ScenarioReporter();
            IntegrationHook messaging = new IntegrationHook();
            messaging.withType("mail-scenario");
            options.mail.subject = options.scenarioName + ": ${outcome}";
            options.mail.messageSource = TemplatedContent.MessageSource.TEMPLATE_FILE;
            options.mail.templateFormat = TemplatedContent.TemplateFormat.FREEMARKER;
            options.mail.templateName = "default.ftl";
            options.mail.attachments = this.createAttachments(projectKey, options);
            messaging.withConfiguration(options.mail);
            reporter.withActive(true);
            reporter.withName("Email Notification");
            reporter.withMessaging(messaging);
            reporter.phase = ScenarioReporter.Phase.END;
            reporters.add(reporter);
        }
        return reporters;
    }

    private List<TaggableObjectsService.TaggableObjectRef> getSelectedObjects(String projectKey, ScheduleScenarioOptions options) throws Exception {
        ArrayList<TaggableObjectsService.TaggableObjectRef> selectedObjects = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        if (options.selectedObjects != null && !options.selectedObjects.isEmpty()) {
            selectedObjects.addAll(options.selectedObjects);
        } else if (options.flowZone != null && !options.flowZone.isBlank()) {
            Collection<FlowComputable> downstreamComputables;
            try (Transaction t = this.transactionService.beginRead();){
                downstreamComputables = this.graphService.getFinalComputablesOfFlow(projectKey, options.flowZone);
            }
            for (FlowComputable computable : downstreamComputables) {
                selectedObjects.add(new TaggableObjectsService.TaggableObjectRef(projectKey, computable.getType().toTaggableType(), computable.getFullId().substring(computable.getFullId().lastIndexOf(".") + 1), null));
            }
        }
        return selectedObjects;
    }

    private List<AttachmentService.MailScenarioAttachment> createAttachments(String projectKey, ScheduleScenarioOptions options) throws Exception {
        ArrayList<AttachmentService.MailScenarioAttachment> attachments = new ArrayList<AttachmentService.MailScenarioAttachment>();
        for (TaggableObjectsService.TaggableObjectRef taggableObject : this.getSelectedObjects(projectKey, options)) {
            AttachmentService.MailScenarioAttachment attachment;
            AttachmentService.AttachmentParams attachmentParams;
            if (taggableObject.type == ITaggingService.TaggableType.DATASET) {
                attachmentParams = new AttachmentService.DatasetExportAttachment();
                attachmentParams.attachedDataset = taggableObject.id;
                attachmentParams.isInline = false;
                attachment = new AttachmentService.MailScenarioAttachment();
                attachment.type = AttachmentService.AttachmentType.DATASET;
                attachment.params = JSON.toJsonObject((Object)attachmentParams, (String[])new String[0]);
                attachments.add(attachment);
                continue;
            }
            if (taggableObject.type != ITaggingService.TaggableType.MANAGED_FOLDER) continue;
            attachmentParams = new AttachmentService.FolderAttachment();
            ((AttachmentService.FolderAttachment)attachmentParams).attachedFolderId = taggableObject.id;
            attachment = new AttachmentService.MailScenarioAttachment();
            attachment.type = AttachmentService.AttachmentType.FOLDER;
            attachment.params = JSON.toJsonObject((Object)attachmentParams, (String[])new String[0]);
            attachments.add(attachment);
        }
        return attachments;
    }

    private BuildFlowItemStepRunner.BuildFlowItemStepParams createBuildStepParams(String projectKey, ScheduleScenarioOptions options) throws Exception {
        BuildFlowItemStepRunner.BuildFlowItemStepParams stepParams = new BuildFlowItemStepRunner.BuildFlowItemStepParams();
        stepParams.refreshHiveMetastore = true;
        stepParams.jobType = options.stepJob.type;
        stepParams.handleWarningsAs = ReportItem.Outcome.WARNING;
        stepParams.builds = new ArrayList();
        for (TaggableObjectsService.TaggableObjectRef object : this.getSelectedObjects(projectKey, options)) {
            if (object.type == ITaggingService.TaggableType.RECIPE) {
                Transaction t = this.transactionService.beginRead();
                try {
                    SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, object.id);
                    List<SerializedRecipe.RecipeOutput> outputs = recipe.getFlatOutputs();
                    for (SerializedRecipe.RecipeOutput output : outputs) {
                        FlowComputable computable = this.computableFromRefService.get(projectKey, output.ref);
                        TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(projectKey, computable.getType().toTaggableType(), output.ref);
                        FlowComputableSpecification spec = FlowComputableSpecification.make(projectKey, ref);
                        stepParams.builds.add(spec);
                    }
                    continue;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                    continue;
                }
            }
            if (!FlowComputable.FCType.isFlowComputable(object.type)) continue;
            FlowComputableSpecification spec = new FlowComputableSpecification();
            spec.type = FlowComputable.FCType.fromTaggableType(object.type);
            spec.itemId = object.id;
            if (!StringUtils.equals((String)projectKey, (String)object.projectKey)) {
                spec.projectKey = object.projectKey;
            }
            stepParams.builds.add(spec);
        }
        return stepParams;
    }

    public static class ScheduleScenarioOptions {
        public String scenarioName;
        public TemporalTriggerRunner.TemporalTriggerParams triggerParams;
        public MailIntegrationParams.MailScenarioIntegrationParams mail;
        public JobDef stepJob;
        public BuildFlowItemStepRunner.BuildFlowItemStepParams stepParams;
        public List<TaggableObjectsService.TaggableObjectRef> selectedObjects;
        public String flowZone;
    }
}

