/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class WorkloadFoldersService {
    private static final Logger logger = Logger.getLogger((String)"dku.workloads.folders");

    private File getFolderLocation(APITicketService.LocalFolderAwareWorkload workload) {
        assert (workload.type != null);
        String typeFragment = switch (workload.type) {
            default -> throw new IncompatibleClassChangeError();
            case APITicketService.LocalFolderAwareWorkloadType.WEBAPP -> "webapps";
            case APITicketService.LocalFolderAwareWorkloadType.AGENT -> "agents";
            case APITicketService.LocalFolderAwareWorkloadType.AGENT_TOOL -> "agent-tools";
        };
        return DKUApp.getFile((String[])new String[]{"workload-folders", typeFragment, workload.projectKey, workload.workloadId});
    }

    private File getProjectScopeFolderLocation(String projectKey, String prefix) {
        assert (StringUtils.isNotBlank((CharSequence)prefix));
        return DKUApp.getFile((String[])new String[]{"workload-folders", "project-scope", projectKey, prefix});
    }

    public File getOrCreateWorkloadFolder(AuthCtx authCtx, @Nonnull String projectKey, APITicketService.Ticket ticket) throws Exception {
        if (!ticket.getOriginalUser().getIdentifier().equals(authCtx.getIdentifier())) {
            throw new DKUSecurityException("Unexpected ticket user mismatch");
        }
        if (ticket.localFolderAwareWorkload == null) {
            throw new DKUSecurityException("Ticket does not accept workload folders");
        }
        if (!projectKey.equals(ticket.localFolderAwareWorkload.projectKey)) {
            throw new DKUSecurityException("Project key mismatch");
        }
        File location = this.getFolderLocation(ticket.localFolderAwareWorkload);
        if (!location.isDirectory()) {
            DKUFileUtils.mkdirs711((File)location.getParentFile());
            DKUFileUtils.mkdirs700((File)location);
        }
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(location);
        FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, location);
        return location;
    }

    public File getOtherWorkloadFolder(AuthCtx authCtx, String projectKey, APITicketService.LocalFolderAwareWorkload workload) throws Exception {
        if (!projectKey.equals(workload.projectKey)) {
            throw new DKUSecurityException("Forbidden cross-project workload folder access");
        }
        File location = this.getFolderLocation(workload);
        if (!location.isDirectory()) {
            logger.warn((Object)("Workload folder " + String.valueOf(location) + " does not exist"));
            throw new IOException("Workload folder for this workload does not exist");
        }
        FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, location);
        return location;
    }

    public File getOrCreateProjectScopeFolder(AuthCtx authCtx, @Nonnull String projectKey, @Nonnull String prefix) throws Exception {
        File location = this.getProjectScopeFolderLocation(projectKey, prefix);
        if (!location.isDirectory()) {
            DKUFileUtils.mkdirs711((File)location.getParentFile());
            DKUFileUtils.mkdirs700((File)location);
        }
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(location);
        FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, location);
        return location;
    }
}

