/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistrationService {
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static Logger logger = Logger.getLogger((String)"dss.saas");

    public static String parseLicense(String license) {
        if ((license = license.trim()).contains("{")) {
            return license;
        }
        try {
            String l2 = new String(Base64.decodeBase64((String)license), "utf8");
            if (l2.contains("{")) {
                return l2;
            }
            throw new IOException("");
        }
        catch (Exception e) {
            throw new ApplicativeException("Invalid license", "This does not look like a valid DSS license");
        }
    }

    private void fillLoginDetails(RegistrationStatus status) {
        status.initialLogin = "admin";
        status.initialPassword = ApplicationConfigurator.getParams().getParam("dku.registration.initialPassword", "admin");
        status.displayPassword = ApplicationConfigurator.getParams().getBoolParam("dku.registration.displayPassword", status.initialPassword.equals("admin"));
        status.initialPasswordHint = ApplicationConfigurator.getParams().getParam("dku.registration.initialPasswordHint", null);
    }

    public RegistrationStatus initialRegisterCommunity(String userFirstname, String userLastname, String userEmail, String instanceId, License license) throws Exception {
        if (ApplicationConfigurator.getLicensingMode() != DKUApp.LicensingMode.ON_PREMISE_DISCONNECTED || this.licenseStatusService.getLicensingStatus().hasLicense) {
            throw new IllegalArgumentException("DSS is already registered");
        }
        LicenseUtils.verify((License)license);
        if (!LicenseUtils.verifyNode((List)license.content.allowedNodes)) {
            throw new IllegalArgumentException("The community license is not allowed on your host");
        }
        JSON.prettyToFile((Object)license, (File)ApplicationConfigurator.getFile((String)"config/license.json"));
        ApplicationConfigurator.invalidateCachedLicenseInstanceId();
        DKUFileUtils.writeFileUTF8((File)ApplicationConfigurator.getFile((String)"instance-id.txt"), (String)instanceId);
        RegistrationStatus rs2 = new RegistrationStatus();
        rs2.community = true;
        this.usersDAO.forceDeleteUser("admin");
        this.usersDAO.forceDeleteUser("viewer");
        this.fillLoginDetails(rs2);
        this.usersDAO.forceDeleteUser(rs2.initialLogin);
        UsersDAO.User u = this.usersDAO.addUser(rs2.initialLogin, rs2.initialPassword);
        u.groups.add(this.usersDAO.getDefaultAdminGroup((boolean)true).name);
        u.displayName = userFirstname + " " + userLastname;
        u.userProfile = "DESIGNER";
        u.email = userEmail;
        UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildInstanceInit();
        this.usersService.saveUser(u, true, usc, null);
        try {
            this.timelinesDB.deleteForProject("FIRST");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GeneralSettingsService.setJustAfterRegister(true);
        if (!rs2.displayPassword) {
            rs2.initialPassword = null;
        }
        return rs2;
    }

    public RegistrationStatus postInitialRegisterLicensed(License license) throws Exception {
        if (ApplicationConfigurator.getLicensingMode() != DKUApp.LicensingMode.ON_PREMISE_DISCONNECTED) {
            throw new IllegalArgumentException("DSS cannot be registered");
        }
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        if (ls.hasLicense && !ls.community) {
            throw new IllegalArgumentException("DSS is already registered");
        }
        LicenseUtils.verify((License)license);
        if (!LicenseUtils.verifyNode((List)license.content.allowedNodes)) {
            throw new IllegalArgumentException("The community license is not allowed on your host");
        }
        JSON.prettyToFile((Object)license, (File)ApplicationConfigurator.getFile((String)"config/license.json"));
        ApplicationConfigurator.invalidateCachedLicenseInstanceId();
        if (license.content.instanceId != null) {
            DKUFileUtils.writeFileUTF8((File)ApplicationConfigurator.getFile((String)"instance-id.txt"), (String)license.content.instanceId);
        }
        RegistrationStatus rs2 = new RegistrationStatus();
        this.fillLoginDetails(rs2);
        if (license.content.licensee != null && license.content.licensee.firstName != null) {
            this.usersDAO.deleteUser(rs2.initialLogin);
            UsersDAO.User u = this.usersDAO.addUser(rs2.initialLogin, rs2.initialPassword);
            u.groups.add(this.usersDAO.getDefaultAdminGroup((boolean)true).name);
            u.displayName = license.content.licensee.firstName + " " + license.content.licensee.lastName;
            u.email = license.content.licensee.email;
            UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildInstanceInit();
            this.usersService.saveUser(u, true, usc, null);
            try {
                this.timelinesDB.deleteForProject("FIRST");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GeneralSettingsService.setJustAfterRegister(true);
        if (!rs2.displayPassword) {
            rs2.initialPassword = null;
        }
        return rs2;
    }

    public void setOfflineLicense(License license) throws Exception {
        LicenseUtils.verify((License)license);
        if (!LicenseUtils.verifyNode((List)license.content.allowedNodes)) {
            throw new IllegalArgumentException("This license is not allowed on your host");
        }
        if (license.content.instanceId != null) {
            DKUFileUtils.writeFileUTF8((File)ApplicationConfigurator.getFile((String)"instance-id.txt"), (String)license.content.instanceId);
        }
        JSON.prettyToFile((Object)license, (File)ApplicationConfigurator.getFile((String)"config/license.json"));
        ApplicationConfigurator.invalidateCachedLicenseInstanceId();
    }

    static class RegistrationStatus {
        boolean community;
        boolean displayPassword;
        String initialLogin;
        String initialPassword;
        String initialPasswordHint;

        RegistrationStatus() {
        }
    }
}

