/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.hive.DummyReporter;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.dataiku.dip.input.formats.hive.HiveFormatExtractor;
import com.dataiku.dip.input.formats.hive.SerdeAccessUtils;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatExtractor;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatExtractor;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatExtractor;
import com.dataiku.dip.input.formats.hive.serde.DSSRowConverter;
import com.dataiku.dip.input.formats.hive.serde.ObjectInspectorBuilder;
import com.dataiku.dip.shaker.mrimpl.compat.InputSplitConverter;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class HiveInputFormatAdapter
extends FileInputFormat<Void, RowWithFactories> {
    private final InputFormat<Writable, Writable> mapredInputFormat;
    private final DatasetConfig inputConf;
    private final HiveFileFormatConfig formatParams;
    private final ColumnFactory columnFactory;
    private final RowFactory rowFactory;
    private final ArrayList<Object> columns = new ArrayList();
    private final HiveFormatExtractor<? extends HiveFileFormatConfig> formatExtractor;
    private final Schema outputSchema;
    private final WarningsContext warningsContext;
    private final SerdeAccessUtils serdeAccessUtils;

    public HiveInputFormatAdapter(ColumnFactory cf, RowFactory rf, DatasetConfig inputConf, WarningsContext warningsContext) {
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
        this.inputConf = inputConf;
        this.rowFactory = rf;
        this.columnFactory = cf;
        this.formatParams = (HiveFileFormatConfig)inputConf.dataset.getFormatParams();
        this.outputSchema = inputConf.dataset.getSchema();
        this.formatExtractor = this.createFormatExtractor();
        this.mapredInputFormat = this.formatExtractor.createInputFormat();
        for (SchemaColumn sc : inputConf.dataset.getSchema().getColumns()) {
            this.columns.add(this.columnFactory.column(sc.getName()));
        }
        this.serdeAccessUtils = new SerdeAccessUtils();
    }

    private HiveFormatExtractor<? extends HiveFileFormatConfig> createFormatExtractor() {
        if (this.formatParams instanceof RCFileFormatConfig) {
            return new RCFileFormatExtractor((RCFileFormatConfig)this.formatParams);
        }
        if (this.formatParams instanceof ORCFileFormatConfig) {
            return new ORCFileFormatExtractor((ORCFileFormatConfig)this.formatParams);
        }
        if (this.formatParams instanceof SequenceFileFormatConfig) {
            return new SequenceFileFormatExtractor((SequenceFileFormatConfig)this.formatParams);
        }
        throw new RuntimeException("Unsupported format config : " + this.formatParams.getClass().getName());
    }

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext job) throws IOException {
        InputSplit[] oldSplits;
        JobConf fakeConf = new JobConf(job.getConfiguration());
        ArrayList<org.apache.hadoop.mapreduce.InputSplit> splits = new ArrayList<org.apache.hadoop.mapreduce.InputSplit>();
        for (InputSplit oldSplit : oldSplits = this.mapredInputFormat.getSplits(fakeConf, 1)) {
            splits.add(InputSplitConverter.convertInputSplit(oldSplit));
        }
        return splits;
    }

    public RecordReader<Void, RowWithFactories> createRecordReader(org.apache.hadoop.mapreduce.InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Object serdeObj;
        String serdeClass = this.formatParams.getSerdeClass();
        try {
            serdeObj = Class.forName(serdeClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load Hive SerDe: " + serdeClass, e);
        }
        if (!this.serdeAccessUtils.isSerde(serdeObj)) {
            throw new RuntimeException("Class " + serdeClass + " is not a Hive SerDe.");
        }
        Object serde = serdeObj;
        String colTypes = ObjectInspectorBuilder.hiveTypeInfoFromDSSSchema(this.outputSchema);
        String colNames = Joiner.on((String)",").join((Iterable)FluentIterable.from((Iterable)this.outputSchema.getColumns()).transform((Function)new Function<SchemaColumn, Object>(){

            public Object apply(SchemaColumn schemaColumn) {
                return schemaColumn.getName().toLowerCase();
            }
        }));
        Properties tbl = new Properties();
        tbl.putAll((Map<?, ?>)this.formatParams.getSerdeProperties());
        tbl.setProperty("columns.types", colTypes);
        tbl.setProperty("columns", colNames);
        try {
            this.serdeAccessUtils.initialize(serde, new Configuration(), tbl);
            JobConf conf = new JobConf(taskAttemptContext.getConfiguration());
            org.apache.hadoop.mapred.RecordReader oldRecordReader = this.mapredInputFormat.getRecordReader(InputSplitConverter.convertInputSplit(inputSplit), conf, (Reporter)new DummyReporter());
            return new InternalRecordReader(serde, (org.apache.hadoop.mapred.RecordReader<Writable, Writable>)oldRecordReader);
        }
        catch (SerDeException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private class InternalRecordReader
    extends RecordReader<Void, RowWithFactories> {
        private final org.apache.hadoop.mapred.RecordReader<Writable, Writable> oldRecordReader;
        private final Object serde;
        private final StructObjectInspector rowObjectInspector;
        private final DSSRowConverter rowConverter;
        private final Writable key;
        private final Writable value;

        public InternalRecordReader(Object serde, org.apache.hadoop.mapred.RecordReader<Writable, Writable> oldRecordReader) throws SerDeException {
            this.serde = serde;
            this.oldRecordReader = oldRecordReader;
            this.rowObjectInspector = (StructObjectInspector)HiveInputFormatAdapter.this.serdeAccessUtils.getObjectInspector(serde);
            this.rowConverter = new DSSRowConverter(HiveInputFormatAdapter.this.columnFactory, HiveInputFormatAdapter.this.rowFactory, HiveInputFormatAdapter.this.outputSchema.getColumns(), HiveInputFormatAdapter.this.formatParams);
            this.key = HiveInputFormatAdapter.this.formatExtractor.getKey(serde, oldRecordReader);
            this.value = HiveInputFormatAdapter.this.formatExtractor.getValue(serde, oldRecordReader);
        }

        public void initialize(org.apache.hadoop.mapreduce.InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.oldRecordReader.next((Object)this.key, (Object)this.value);
        }

        public Void getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public RowWithFactories getCurrentValue() throws IOException, InterruptedException {
            try {
                Object obj = HiveInputFormatAdapter.this.serdeAccessUtils.deserialize(this.serde, this.value);
                Row row = this.rowConverter.buildRow(obj, this.rowObjectInspector);
                return new RowWithFactories(HiveInputFormatAdapter.this.columnFactory, HiveInputFormatAdapter.this.rowFactory, row);
            }
            catch (SerDeException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.oldRecordReader.getProgress();
        }

        public void close() throws IOException {
            this.oldRecordReader.close();
        }
    }
}

