/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.publicdata;

import com.dataiku.dip.DatasetDependency;
import com.dataiku.dip.ProcessorWithSingleCopyAdditionalInputs;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import com.dataiku.dip.shaker.text.Labelled;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;

public abstract class EnrichWithINSEEData
extends SingleRowProcessor
implements Processor,
ProcessorWithSingleCopyAdditionalInputs<SingleCopyAdditionalInputsLoader> {
    protected List<Col> extractedCols = new ArrayList<Col>();
    protected Map<String, String[]> dataMap;

    protected static List<String> computeExtractedColumnNames(Col[] fileCols, String[] categories, Object parameter, String prefix) {
        ArrayList<String> computedExtractedColumns = new ArrayList<String>();
        block2: for (int i = fileCols.length - 1; i >= 0; --i) {
            Col fileCol = fileCols[i];
            if (fileCol.category == null) continue;
            for (String category : categories) {
                try {
                    if (!fileCol.category.equals(category) || !parameter.getClass().getField(category).getBoolean(parameter)) continue;
                    computedExtractedColumns.add(prefix + "_" + fileCol.name);
                    continue block2;
                }
                catch (Exception e) {
                    throw new Error("Init failed", e);
                }
            }
        }
        return computedExtractedColumns;
    }

    protected void loadExtractedCols(Col[] fileCols, String[] categories, Object parameter, String inCol, String prefix) {
        block2: for (int i = fileCols.length - 1; i >= 0; --i) {
            Col fileCol = fileCols[i];
            if (fileCol.category == null) continue;
            for (String category : categories) {
                try {
                    if (!fileCol.category.equals(category) || !parameter.getClass().getField(category).getBoolean(parameter)) continue;
                    Col eCol = new Col(fileCol.name, fileCol.category);
                    eCol.origIdx = i;
                    eCol.col = this.getColumnFactory().columnAfter(inCol, prefix + "_" + eCol.name, Processor.ProcessorRole.OUTPUT_COLUMN);
                    this.extractedCols.add(eCol);
                    continue block2;
                }
                catch (Exception e) {
                    throw new Error("Init failed", e);
                }
            }
        }
    }

    @Override
    public void setAdditionalInputs(SingleCopyAdditionalInputsLoader loader) {
        this.dataMap = ((DataLoader)loader).localDataMap;
    }

    @Override
    public List<DatasetDependency> listDependencies() {
        return new ArrayList<DatasetDependency>();
    }

    public static class Col {
        int origIdx;
        Column col;
        public String name;
        public String category;

        Col(String name, String category) {
            this.name = name;
            this.category = category;
        }
    }

    protected static class DataLoader
    implements SingleCopyAdditionalInputsLoader {
        private final File file;
        Map<String, String[]> localDataMap = new HashMap<String, String[]>();

        DataLoader(File file) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
        }

        @Override
        public Callable<Void> loadAdditionalInputs(AdditionalInputAccessor runner) throws Exception {
            RFC4180CSVParser parser = new RFC4180CSVParser((LineReader)new InputStreamLineReader((InputStream)new FileInputStream(this.file), "utf8"), ',');
            ArrayList<String> out = new ArrayList<String>();
            while (parser.next(out)) {
                String[] data = new String[out.size()];
                for (int i = 0; i < out.size(); ++i) {
                    if (StringUtils.isBlank((String)((String)out.get(i)))) continue;
                    data[i] = (String)out.get(i);
                }
                this.localDataMap.put((String)out.get(0), data);
            }
            return new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    return null;
                }
            };
        }
    }

    public static enum SourceDatasetVersion implements Labelled
    {
        INSEE_2009_2011("INSEE 2009-2011"),
        INSEE_JAN_2024("INSEE Jan 2024");

        public final String label;

        private SourceDatasetVersion(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }
}

