/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.reshaping.UnfoldProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;

public class ArrayUnfold
extends UnfoldProcessor
implements Processor {
    public static final ProcessorMeta<ArrayUnfold, Parameter> META = new ProcessorMeta<ArrayUnfold, Parameter>(){

        @Override
        public String getName() {
            return "ArrayUnfold";
        }

        @Override
        public String getDocPage() {
            return "unfold-array";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ArrayUnfold.HELP", "This processor takes a column containing JSON arrays and transforms it into several columns, containing the number of occurrences of each term of the array.\n\nYou can prefix new columns by filling the \"Prefix\" option.\n\nYou can choose the maximum number of columns to create with the \"Max nb. columns to create\" option.\n\nYou can transform the original column into binary columns by unchecking the \"Count of Values\" option.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return UnfoldProcessor.addColumnLimitationsDesc(language, new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ArrayUnfold.DESCRIPTION", 1.actionVerb("Unfold") + " an array"), false).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withParam("prefix", "String", false, true, this.translate(language, "SHAKER.PROCESSOR.ArrayUnfold.DESCRIPTION.PREFIX", "Prefix (empty for no prefix)")).withBoolDefaultTrue("countVal", this.translate(language, "SHAKER.PROCESSOR.ArrayUnfold.DESCRIPTION.COUNT_VAL", "Count of Values"), "Count of Values"));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"column", "prefix"});
        }

        @Override
        public ArrayUnfold build(Parameter parameter) {
            return new ArrayUnfold(parameter);
        }
    };
    private final Parameter parameter;
    private Column unfoldCD;
    private String nextColName;

    public ArrayUnfold(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.unfoldCD = this.getColumnFactory().column(this.parameter.column);
        Column nextColCD = this.getColumnFactory().getColumnAfter(this.parameter.column);
        this.nextColName = nextColCD == null ? null : nextColCD.getName();
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.unfoldCD);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            JSONArray array = new JSONArray(v);
            LinkedHashMap<String, Integer> occurrences = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < array.length(); ++i) {
                Integer previousOccurrence;
                String s;
                Object so = array.get(i);
                String string = s = so == null ? null : so.toString();
                if (s == null) continue;
                Integer occurrence = this.parameter.countVal ? Integer.valueOf((previousOccurrence = (Integer)occurrences.get(s)) == null ? 1 : previousOccurrence + 1) : Integer.valueOf(1);
                occurrences.put(s, occurrence);
            }
            this.enrichCreatedColumns(occurrences.keySet(), (UnfoldProcessor.UnfoldParameter)this.parameter);
            for (Map.Entry entry : occurrences.entrySet()) {
                if (this.parameter.overflowAction != UnfoldProcessor.OverflowAction.KEEP && !this.createdColumns.contains(entry.getKey())) continue;
                String columnName = this.parameter.prefix == null ? (String)entry.getKey() : this.parameter.prefix + (String)entry.getKey();
                row.put(this.getColumnFactory().columnBefore(this.nextColName, columnName), ((Integer)entry.getValue()).intValue());
            }
        }
        catch (UnfoldProcessor.TooManyColumnsException e) {
            throw e;
        }
        catch (Exception e) {
            this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_DATA, "Failed to parse JSON", (Throwable)e, logger);
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    extends UnfoldProcessor.UnfoldParameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String column;
        String prefix;
        boolean countVal = true;

        public void validate() {
        }
    }
}

