/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public class ArraySortProcessor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<ArraySortProcessor, Parameter> META = new ProcessorMeta<ArraySortProcessor, Parameter>(){

        @Override
        public String getName() {
            return "ArraySortProcessor";
        }

        @Override
        public String getDocPage() {
            return "array-sort";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.COMPLEX});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ArraySortProcessor.HELP", "This processor sorts an array (written in JSON).\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ArraySortProcessor.DESCRIPTION", 1.actionVerb("Sort") + " array"), false);
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"input", "output"});
        }

        @Override
        public ArraySortProcessor build(Parameter param) {
            return new ArraySortProcessor(param);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter params = (Parameter)pss.params;
            if (StringUtils.isBlank((String)params.input)) {
                throw new IllegalConfigurationException("Missing input column for Sort array processor");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                String outputColumn = params.output;
                if (StringUtils.isNotBlank((String)outputColumn)) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(params.input, outputColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter param;
    private Column in;
    private Column out;

    public ArraySortProcessor(Parameter parameter) {
        this.param = parameter;
    }

    public void init() {
        this.in = this.getColumnFactory().column(this.param.input, Processor.ProcessorRole.INPUT_COLUMN);
        this.out = this.param.output != null && !this.param.output.equals("") ? this.getColumnFactory().columnAfter(this.param.input, this.param.output, Processor.ProcessorRole.OUTPUT_COLUMN) : this.in;
    }

    public void processRow(Row row) {
        String v = row.get(this.in);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            JSONArray array = new JSONArray(v);
            if (this.param.sortingType == SortingType.ALPHA) {
                ArrayList<String> outArray = new ArrayList<String>(array.length());
                for (int i = 0; i < array.length(); ++i) {
                    Object so = array.get(i);
                    String s = so == null ? null : so.toString();
                    outArray.add(s);
                }
                if (this.param.descending) {
                    Collections.sort(outArray, Collections.reverseOrder());
                } else {
                    Collections.sort(outArray);
                }
                row.put(this.out, new JSONArray(outArray).toString());
            } else if (this.param.sortingType == SortingType.NUM) {
                int i;
                int len = array.length();
                Integer[] indices = new Integer[len];
                double[] numbers = new double[len];
                String[] strings = new String[len];
                Object[] output = new Object[len];
                for (i = 0; i < len; ++i) {
                    indices[i] = i;
                    numbers[i] = array.optDouble(i, Double.NaN);
                    strings[i] = array.get(i) == null ? null : array.get(i).toString();
                }
                Arrays.sort(indices, new CustomComparator(numbers, strings, this.param.descending));
                for (i = 0; i < array.length(); ++i) {
                    output[i] = array.get(indices[i].intValue());
                }
                row.put(this.out, new JSONArray((Object)output).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String input;
        public String output;
        public SortingType sortingType = SortingType.NUM;
        public boolean descending;

        public void validate() throws IllegalArgumentException {
        }
    }

    public static enum SortingType {
        NUM,
        ALPHA;

    }

    private static class CustomComparator
    implements Comparator<Integer> {
        private double[] numbers;
        private String[] strings;
        private int order;

        public CustomComparator(double[] numbers, String[] strings, boolean reverse) {
            this.numbers = numbers;
            this.strings = strings;
            this.order = reverse ? -1 : 1;
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            if (Double.isNaN(this.numbers[i1]) && Double.isNaN(this.numbers[i2])) {
                return this.order * this.strings[i1].compareTo(this.strings[i2]);
            }
            return this.order * Double.compare(this.numbers[i1], this.numbers[i2]);
        }
    }
}

