/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import java.util.Set;

public class UseRowAsHeader
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<UseRowAsHeader, Parameter> META = new ProcessorMeta<UseRowAsHeader, Parameter>(){

        @Override
        public String getName() {
            return "UseRowAsHeader";
        }

        @Override
        public Category getCategory() {
            return Category.MISC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.UseRowAsHeader.HELP", "This processor replaces all column names by the corresponding values of a row.\n\nThe used row is removed.\n# Limitations\nThis processor identifies the row to use by its row number, which is not guaranteed to be stable.\n\nIn particular, you should only use this processor for single-file datasets or SQL datasets if your table does not change.\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.UseRowAsHeader.DESCRIPTION", 1.actionVerb("Use") + " values of a row as column names")).withParam(ParamDesc.intP("rowIdx", this.translate(language, "SHAKER.PROCESSOR.UseRowAsHeader.DESCRIPTION.ROW_IDX", "Row index"), "Row index", -1).withMandatory(true).withCanBeEmpty(false)).deprecate().doNotDisplayInLibrary();
        }

        @Override
        public UseRowAsHeader build(Parameter parameter) throws Exception {
            return new UseRowAsHeader(parameter.rowIdx);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Unsupported processor: UserRowAsHeader");
        }
    };
    private int curRowIdx = -1;
    private Integer requestedRowIdx;

    public UseRowAsHeader(Integer rowIdx) throws Exception {
        this.requestedRowIdx = rowIdx;
    }

    public void postProcess() {
    }

    public void init() {
    }

    public void processRow(Row row) throws Exception {
        if (this.requestedRowIdx == null) {
            return;
        }
        ++this.curRowIdx;
        if (this.curRowIdx == this.requestedRowIdx) {
            for (Column c2 : this.getColumnFactory().columns()) {
                String v = row.get(c2);
                if (v == null) continue;
                c2.setName(v);
            }
            row.delete();
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public Integer rowIdx;

        public void validate() throws IllegalArgumentException {
        }
    }
}

