/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.ParamsWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.PythonUDFMode;
import com.dataiku.dip.shaker.resources.YarnPythonBinsSetup;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PythonParameter
implements StepParams,
ParamsWithSelectableCodeEnv,
ParamsWithRemoteCodeEnv {
    private static final long serialVersionUID = -1L;
    public PythonUDFMode mode = PythonUDFMode.CELL;
    public String pythonSourceCode = "";
    public transient Map<String, String> variablesDefinition = Maps.newHashMap();
    public String column = null;
    public String errorColumn = null;
    public boolean stopOnError = false;
    public boolean usePythonUnicode = false;
    public boolean useKernel = false;
    public boolean vectorize = false;
    public int vectorSize = 256;
    public String fixedEnvName;
    public String sourceColumnsPattern;
    public List<String> sourceColumnsList = Lists.newArrayList();
    public CodeEnvSelection envSelection = new CodeEnvSelection();
    protected static Logger logger = Logger.getLogger((String)"dku.shaker.python.param");

    public void validate() throws IllegalArgumentException {
    }

    @Override
    public CodeEnvSelection getCodeEnvSelection() {
        return this.envSelection;
    }

    @Override
    public void setCodeEnvSelection(CodeEnvSelection envSelection) {
        this.envSelection = envSelection;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
        ArrayList usages = Lists.newArrayList();
        if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
            usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.RECIPE, object.getProjectKey(), object.getId()));
        }
        return usages;
    }

    @Override
    public String getCodeEnvName(MetaWithRemoteCodeEnv meta, String projectKey) throws IOException {
        if (YarnPythonBinsSetup.isRemote) {
            logger.info((Object)("Use fixed code env " + this.fixedEnvName));
            return "__BUILTIN_ENV__".equals(this.fixedEnvName) ? null : this.fixedEnvName;
        }
        logger.info((Object)("Pick code env for python udf with " + JSON.log((Object)this.envSelection)));
        return new CodeEnvSelector().selectForPythonRecipe(projectKey, this.envSelection);
    }

    @Override
    public void setCodeEnvName(String envName) {
        this.fixedEnvName = StringUtils.defaultIfBlank((String)envName, (String)"__BUILTIN_ENV__");
    }
}

