/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLExecutionResponse;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLResultSetMetaData;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLStatement;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DkuSparkSQLResultSet
implements ResultSet {
    private final DkuSparkSQLStatement statement;
    private final Map<String, Integer> columnIndices = Maps.newHashMap();
    private final int maxRows;
    private boolean isClosed;
    private DkuSparkSQLExecutionResponse currentResponse;
    private int position = -1;
    private int rowCount = 0;
    private boolean lastCellSeenWasNull = false;
    private AnyTemporal anyTemporal = new AnyTemporal();
    private static Logger logger = Logger.getLogger((String)"dip.livy.resultset");

    DkuSparkSQLResultSet(DkuSparkSQLStatement statement, int maxRows, DkuSparkSQLExecutionResponse initialResponse) {
        this.statement = statement;
        this.maxRows = maxRows;
        logger.info((Object)("Creating SparkSQL resultSet on schema=" + JSON.log((Object)initialResponse.schema)));
        for (int i = 0; i < initialResponse.schema.columns.size(); ++i) {
            this.columnIndices.put(((SchemaColumn)initialResponse.schema.columns.get(i)).getName(), i);
        }
        this.isClosed = false;
        this.setResponse(initialResponse);
    }

    private void setResponse(DkuSparkSQLExecutionResponse response) {
        logger.info((Object)("New chunk of rows size=" + response.rows.size() + " hasNext=" + response.hasNext + " iteratorIsReady=" + response.iteratorIsReady));
        this.currentResponse = response;
        this.position = -1;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowCount >= this.maxRows) {
            return false;
        }
        if (this.position + 1 < this.currentResponse.rows.size()) {
            ++this.position;
            ++this.rowCount;
            return true;
        }
        if (this.currentResponse.hasNext || !this.currentResponse.iteratorIsReady) {
            this.setResponse(this.statement.fetchNextBatch(this.currentResponse.statementIdentifier));
            return this.next();
        }
        return false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastCellSeenWasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new DkuSparkSQLResultSetMetaData(this.currentResponse.schema);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.columnIndices.containsKey(columnLabel) ? this.columnIndices.get(columnLabel) : -1;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String str = this.currentResponse.rows.get(this.position).get(columnIndex - 1);
        this.lastCellSeenWasNull = StringUtils.isBlank((String)str);
        return str;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? null : new BigDecimal(str);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? false : Boolean.parseBoolean(str);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.lastCellSeenWasNull ? (byte)0 : (byte)this.getLong(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? (short)0 : Short.parseShort(str);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? 0 : Integer.parseInt(str);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? 0L : Long.parseLong(str);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? 0.0f : Float.parseFloat(str);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return this.lastCellSeenWasNull ? 0.0 : Double.parseDouble(str);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        long ts = this.anyTemporal.longValue(str);
        if (ts == Long.MAX_VALUE) {
            return null;
        }
        return new Date(ts);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        long ts = this.anyTemporal.longValue(str);
        if (ts == Long.MAX_VALUE) {
            return null;
        }
        return new Timestamp(ts);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean first() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean last() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public int getRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public int getType() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new NotImplementedException("Should not be used");
    }
}

