/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.shaker.processors.transform.StringTransformation;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExpressionBuilder {
    private static final ExpressionBuilderFactory ebf = new ExpressionBuilderFactory();
    private static String accentuated = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0100\u0101\u0102\u0103\u0104\u0105\u00c7\u00e7\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d\u00d0\u00f0\u010e\u010f\u0110\u0111\u00c8\u00c9\u00ca\u00cb\u00e8\u00e9\u00ea\u00eb\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123\u0124\u0125\u0126\u0127\u00cc\u00cd\u00ce\u00cf\u00ec\u00ed\u00ee\u00ef\u0128\u0129\u012a\u012b\u012c\u012d\u012e\u012f\u0130\u0131\u0134\u0135\u0136\u0137\u0138\u0139\u013a\u013b\u013c\u013d\u013e\u013f\u0140\u0141\u0142\u00d1\u00f1\u0143\u0144\u0145\u0146\u0147\u0148\u0149\u014a\u014b\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014c\u014d\u014e\u014f\u0150\u0151\u0154\u0155\u0156\u0157\u0158\u0159\u015a\u015b\u015c\u015d\u015e\u015f\u0160\u0161\u017f\u0162\u0163\u0164\u0165\u0166\u0167\u00d9\u00da\u00db\u00dc\u00f9\u00fa\u00fb\u00fc\u0168\u0169\u016a\u016b\u016c\u016d\u016e\u016f\u0170\u0171\u0172\u0173\u0174\u0175\u00dd\u00fd\u00ff\u0176\u0177\u0178\u0179\u017a\u017b\u017c\u017d\u017e";
    private static String unaccentuated = "AAAAAAaaaaaaAaAaAaCcCcCcCcCcDdDdDdEEEEeeeeEeEeEeEeEeGgGgGgGgHhHhIIIIiiiiIiIiIiIiIiJjKkkLlLlLlLlLlNnNnNnNnnNnOOOOOOooooooOoOoOoRrRrRrSsSsSsSssTtTtTtUUUUuuuuUuUuUuUuUuUuWwYyyYyYZzZzZz";
    public final QueryAst.Expr expr;

    private ExpressionBuilder(QueryAst.Expr expr) {
        this.expr = expr;
    }

    public String toSQL(SQLDialect dialect) {
        return QuerySQLWriter.generateSafeSQL(dialect, this.expr);
    }

    private static List<QueryAst.Expr> makeExpressionsList(Object[] objects) {
        if (objects == null) {
            return Lists.newArrayList();
        }
        ArrayList<QueryAst.Expr> exprs = new ArrayList<QueryAst.Expr>(objects.length);
        for (Object o : objects) {
            if (o instanceof QueryAst.Expr) {
                exprs.add((QueryAst.Expr)o);
                continue;
            }
            if (o instanceof ExpressionBuilder) {
                ExpressionBuilder eb = (ExpressionBuilder)o;
                exprs.add(eb.expr);
                continue;
            }
            if (o instanceof SelectQueryBuilder) {
                SelectQueryBuilder qb = (SelectQueryBuilder)o;
                exprs.add(qb.query);
                continue;
            }
            exprs.add(new QueryAst.ConstExpr(o));
        }
        return exprs;
    }

    private ExpressionBuilder withOp(QueryUtils.OperatorType opType, Object ... vargs) {
        QueryAst.OperatorExpr e = new QueryAst.OperatorExpr();
        e.op = opType;
        List<QueryAst.Expr> args = ExpressionBuilder.makeExpressionsList(vargs);
        if (this.expr != null) {
            args.add(0, this.expr);
        }
        e.args = args;
        return new ExpressionBuilder(e);
    }

    public ExpressionBuilder over(QueryAst.Window window) {
        if (this.expr instanceof QueryAst.OperatorExpr) {
            QueryAst.OperatorExpr e = new QueryAst.OperatorExpr((QueryAst.OperatorExpr)this.expr);
            e.window = window;
            return new ExpressionBuilder(e);
        }
        throw new QueryUtils.SQLGenerationException("Cannot apply SQL OVER clause");
    }

    public ExpressionBuilder caseWhen(Object ... vargs) {
        QueryAst.CaseExpr e;
        List<QueryAst.Expr> args = ExpressionBuilder.makeExpressionsList(vargs);
        if (this.expr instanceof QueryAst.CaseExpr) {
            e = new QueryAst.CaseExpr((QueryAst.CaseExpr)this.expr, args);
        } else if (this.expr == null) {
            e = new QueryAst.CaseExpr(args);
        } else {
            throw new QueryUtils.SQLGenerationException("Case when can only be used with constants");
        }
        return new ExpressionBuilder(e);
    }

    public ExpressionBuilder inList(Collection<?> vargs) {
        if (this.expr == null) {
            throw new QueryUtils.SQLGenerationException("Cannot use Operator IN on an null expression");
        }
        Object[] vargs2 = vargs.toArray(new Object[vargs.size()]);
        QueryAst.ListExpr list = new QueryAst.ListExpr(ExpressionBuilder.makeExpressionsList(vargs2));
        return this.in(list);
    }

    public ExpressionBuilder eq(Object arg) {
        return this.withOp(QueryUtils.OperatorType.EQ, arg);
    }

    public ExpressionBuilder ne(Object arg) {
        return this.withOp(QueryUtils.OperatorType.NE, arg);
    }

    public ExpressionBuilder gt(Object arg) {
        return this.withOp(QueryUtils.OperatorType.GT, arg);
    }

    public ExpressionBuilder lt(Object arg) {
        return this.withOp(QueryUtils.OperatorType.LT, arg);
    }

    public ExpressionBuilder gte(Object arg) {
        return this.withOp(QueryUtils.OperatorType.GE, arg);
    }

    public ExpressionBuilder lte(Object arg) {
        return this.withOp(QueryUtils.OperatorType.LE, arg);
    }

    public ExpressionBuilder like(Object arg) {
        return this.withOp(QueryUtils.OperatorType.LIKE, arg);
    }

    public ExpressionBuilder rlike(Object arg) {
        return this.withOp(QueryUtils.OperatorType.REGEX_LIKE, arg);
    }

    public ExpressionBuilder nullUnsafeEq(Object arg) {
        return this.withOp(QueryUtils.OperatorType.NULL_UNSAFE_EQ, arg);
    }

    public ExpressionBuilder and(ExpressionBuilder ... vargs) {
        return this.withOp(QueryUtils.OperatorType.AND, vargs);
    }

    public ExpressionBuilder or(ExpressionBuilder ... vargs) {
        return this.withOp(QueryUtils.OperatorType.OR, vargs);
    }

    public ExpressionBuilder not() {
        return this.withOp(QueryUtils.OperatorType.NOT, new Object[0]);
    }

    public ExpressionBuilder isnull() {
        return this.withOp(QueryUtils.OperatorType.ISNULL, new Object[0]);
    }

    public ExpressionBuilder isnotnull() {
        return this.withOp(QueryUtils.OperatorType.ISNOTNULL, new Object[0]);
    }

    public ExpressionBuilder in(Object e) {
        return this.withOp(QueryUtils.OperatorType.IN, e);
    }

    public ExpressionBuilder isTrue() {
        return this.withOp(QueryUtils.OperatorType.ISTRUE, new Object[0]);
    }

    public ExpressionBuilder isFalse() {
        return this.withOp(QueryUtils.OperatorType.ISFALSE, new Object[0]);
    }

    public ExpressionBuilder contains(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.CONTAINS, varg);
    }

    public ExpressionBuilder startsWith(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.STARTS_WITH, varg);
    }

    public ExpressionBuilder endsWith(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ENDS_WITH, varg);
    }

    public ExpressionBuilder indexOf(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.INDEX_OF, varg);
    }

    public ExpressionBuilder lastIndexOf(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.LAST_INDEX_OF, varg);
    }

    public ExpressionBuilder reverse() {
        return this.withOp(QueryUtils.OperatorType.REVERSE_STR, new Object[0]);
    }

    public ExpressionBuilder isBlank() {
        return this.withOp(QueryUtils.OperatorType.IS_BLANK, new Object[0]);
    }

    public ExpressionBuilder isNonBlank() {
        return this.withOp(QueryUtils.OperatorType.IS_NON_BLANK, new Object[0]);
    }

    public ExpressionBuilder stEquals(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_EQUALS, varg);
    }

    public ExpressionBuilder stDwithin(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_DWITHIN, varg);
    }

    public ExpressionBuilder stBeyond(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_BEYOND, varg);
    }

    public ExpressionBuilder stWithin(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_WITHIN, varg);
    }

    public ExpressionBuilder stCrosses(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_CROSSES, varg);
    }

    public ExpressionBuilder stTouches(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_TOUCHES, varg);
    }

    public ExpressionBuilder stContains(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_CONTAINS, varg);
    }

    public ExpressionBuilder stDisjoint(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_DISJOINT, varg);
    }

    public ExpressionBuilder stOverlaps(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_OVERLAPS, varg);
    }

    public ExpressionBuilder stIntersects(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_INTERSECTS, varg);
    }

    public ExpressionBuilder stTransform(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_TRANSFORM, varg);
    }

    public ExpressionBuilder stArea() {
        return this.withOp(QueryUtils.OperatorType.ST_AREA, new Object[0]);
    }

    public ExpressionBuilder stCentroid() {
        return this.withOp(QueryUtils.OperatorType.ST_CENTROID, new Object[0]);
    }

    public ExpressionBuilder stDistance(Object arg) {
        return this.withOp(QueryUtils.OperatorType.ST_DISTANCE, arg);
    }

    public ExpressionBuilder stLength() {
        return this.withOp(QueryUtils.OperatorType.ST_LENGTH, new Object[0]);
    }

    public ExpressionBuilder stAsText() {
        return this.withOp(QueryUtils.OperatorType.ST_ASTEXT, new Object[0]);
    }

    public ExpressionBuilder plus(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.PLUS, vargs);
    }

    public ExpressionBuilder minus(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.MINUS, vargs);
    }

    public ExpressionBuilder time(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.TIMES, vargs);
    }

    public ExpressionBuilder div(Object arg) {
        return this.withOp(QueryUtils.OperatorType.DIV, arg);
    }

    public ExpressionBuilder quotient(Object arg) {
        return this.withOp(QueryUtils.OperatorType.QUOTIENT, arg);
    }

    public ExpressionBuilder mod(Object arg) {
        return this.withOp(QueryUtils.OperatorType.MOD, arg);
    }

    public ExpressionBuilder distinct() {
        return this.withOp(QueryUtils.OperatorType.DISTINCT, new Object[0]);
    }

    public ExpressionBuilder abs() {
        return this.withOp(QueryUtils.OperatorType.ABS, new Object[0]);
    }

    public ExpressionBuilder sign() {
        return this.withOp(QueryUtils.OperatorType.SIGN, new Object[0]);
    }

    public ExpressionBuilder floor() {
        return this.withOp(QueryUtils.OperatorType.FLOOR, new Object[0]);
    }

    public ExpressionBuilder ceil() {
        return this.withOp(QueryUtils.OperatorType.CEIL, new Object[0]);
    }

    public ExpressionBuilder round() {
        return this.withOp(QueryUtils.OperatorType.ROUND, new Object[0]);
    }

    public ExpressionBuilder round(int decimalPlaces) {
        return this.withOp(QueryUtils.OperatorType.ROUND, decimalPlaces);
    }

    public ExpressionBuilder sqrt() {
        return this.withOp(QueryUtils.OperatorType.SQRT, new Object[0]);
    }

    public ExpressionBuilder exp() {
        return this.withOp(QueryUtils.OperatorType.EXP, new Object[0]);
    }

    public ExpressionBuilder sin() {
        return this.withOp(QueryUtils.OperatorType.SIN, new Object[0]);
    }

    public ExpressionBuilder cos() {
        return this.withOp(QueryUtils.OperatorType.COS, new Object[0]);
    }

    public ExpressionBuilder power(int n) {
        return this.withOp(QueryUtils.OperatorType.POW, n);
    }

    public ExpressionBuilder ln() {
        return this.withOp(QueryUtils.OperatorType.LN, new Object[0]);
    }

    public ExpressionBuilder log() {
        return this.withOp(QueryUtils.OperatorType.LOG, new Object[0]);
    }

    public ExpressionBuilder fact() {
        return this.withOp(QueryUtils.OperatorType.FACT, new Object[0]);
    }

    public ExpressionBuilder hash() {
        return this.withOp(QueryUtils.OperatorType.HASH, new Object[0]);
    }

    public ExpressionBuilder avg() {
        return this.withOp(QueryUtils.OperatorType.AVG, new Object[0]);
    }

    public ExpressionBuilder median() {
        return this.withOp(QueryUtils.OperatorType.MEDIAN, new Object[0]);
    }

    public ExpressionBuilder min() {
        return this.withOp(QueryUtils.OperatorType.MIN, new Object[0]);
    }

    public ExpressionBuilder max() {
        return this.withOp(QueryUtils.OperatorType.MAX, new Object[0]);
    }

    public ExpressionBuilder sum() {
        return this.withOp(QueryUtils.OperatorType.SUM, new Object[0]);
    }

    public ExpressionBuilder stdDevSamp() {
        return this.withOp(QueryUtils.OperatorType.STDDEV_SAMP, new Object[0]);
    }

    public ExpressionBuilder aggConcat(String separator) {
        return this.withOp(QueryUtils.OperatorType.AGG_CONCAT, separator, false);
    }

    public ExpressionBuilder aggConcat(String separator, boolean distinct) {
        return this.withOp(QueryUtils.OperatorType.AGG_CONCAT, separator, distinct);
    }

    public ExpressionBuilder collectStringList() {
        return this.withOp(QueryUtils.OperatorType.COLLECT_STRING_LIST, new Object[0]);
    }

    public ExpressionBuilder collectStringSet() {
        return this.withOp(QueryUtils.OperatorType.COLLECT_STRING_SET, new Object[0]);
    }

    public ExpressionBuilder arrayToString(String separator) {
        return this.withOp(QueryUtils.OperatorType.ARRAY_TO_STRING, separator);
    }

    public ExpressionBuilder count() {
        return this.withOp(QueryUtils.OperatorType.COUNT, new Object[0]);
    }

    public ExpressionBuilder countDistinct() {
        return this.distinct().count();
    }

    public ExpressionBuilder length() {
        return this.withOp(QueryUtils.OperatorType.LENGTH, new Object[0]);
    }

    public ExpressionBuilder upper() {
        return this.withOp(QueryUtils.OperatorType.UPPER, new Object[0]);
    }

    public ExpressionBuilder lower() {
        return this.withOp(QueryUtils.OperatorType.LOWER, new Object[0]);
    }

    public ExpressionBuilder trim() {
        return this.withOp(QueryUtils.OperatorType.TRIM, new Object[0]);
    }

    public ExpressionBuilder substr(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.SUBSTR, varg);
    }

    public ExpressionBuilder concat(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.CONCAT, varg);
    }

    public ExpressionBuilder caseSensitivity(boolean sensitive) {
        return this.withOp(QueryUtils.OperatorType.SET_CASE_SENSITIVITY, sensitive);
    }

    public ExpressionBuilder firstValue(boolean ignoreNulls) {
        return this.withOp(QueryUtils.OperatorType.FIRST_VALUE, ignoreNulls);
    }

    public ExpressionBuilder lastValue(boolean ignoreNulls) {
        return this.withOp(QueryUtils.OperatorType.LAST_VALUE, ignoreNulls);
    }

    public ExpressionBuilder rowNumber() {
        return this.withOp(QueryUtils.OperatorType.ROW_NUMBER, new Object[0]);
    }

    public ExpressionBuilder rank() {
        return this.withOp(QueryUtils.OperatorType.RANK, new Object[0]);
    }

    public ExpressionBuilder denseRank() {
        return this.withOp(QueryUtils.OperatorType.DENSE_RANK, new Object[0]);
    }

    public ExpressionBuilder lag(int offset) {
        return this.withOp(QueryUtils.OperatorType.LAG, offset);
    }

    public ExpressionBuilder lead(int offset) {
        return this.withOp(QueryUtils.OperatorType.LEAD, offset);
    }

    public ExpressionBuilder cumeDist() {
        return this.withOp(QueryUtils.OperatorType.CUME_DIST, new Object[0]);
    }

    public ExpressionBuilder ntile(int buckets) {
        return this.withOp(QueryUtils.OperatorType.NTILE, buckets);
    }

    public ExpressionBuilder percentileApproxAgg(double percent) {
        return this.withOp(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, percent);
    }

    public ExpressionBuilder percentileApproxWin(double percent) {
        return this.withOp(QueryUtils.OperatorType.PERCENTILE_APPROX_WIN, percent);
    }

    public ExpressionBuilder coalesce(Object replacement) {
        return this.withOp(QueryUtils.OperatorType.COALESCE, replacement);
    }

    public ExpressionBuilder replace(Object replaced, Object replacement) {
        return this.withOp(QueryUtils.OperatorType.REPLACE, replaced, replacement);
    }

    public ExpressionBuilder regexpSubstr(Object replaced) {
        return this.withOp(QueryUtils.OperatorType.REGEXP_SUBSTR, replaced);
    }

    public ExpressionBuilder regexpSubstr(Object replaced, boolean ignoreCase) {
        return this.withOp(QueryUtils.OperatorType.REGEXP_SUBSTR, replaced, ignoreCase);
    }

    public ExpressionBuilder regexpReplace(Object replaced, Object replacement) {
        return this.withOp(QueryUtils.OperatorType.REGEXP_REPLACE, replaced, replacement);
    }

    public ExpressionBuilder regexpReplace(Object replaced, Object replacement, boolean ignoreCase) {
        return this.withOp(QueryUtils.OperatorType.REGEXP_REPLACE, replaced, replacement, ignoreCase);
    }

    public ExpressionBuilder translate(Object replaced, Object replacement) {
        return this.withOp(QueryUtils.OperatorType.TRANSLATE, replaced, replacement);
    }

    public ExpressionBuilder greatest(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.GREATEST, varg);
    }

    public ExpressionBuilder least(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.LEAST, varg);
    }

    public ExpressionBuilder dateTrunc(String unit) {
        return this.withOp(QueryUtils.OperatorType.DATETRUNC, unit);
    }

    public ExpressionBuilder dateonlyTrunc(String unit) {
        return this.withOp(QueryUtils.OperatorType.DATEONLYTRUNC, unit);
    }

    public ExpressionBuilder datetimenotzTrunc(String unit) {
        return this.withOp(QueryUtils.OperatorType.DATETIMENOTZTRUNC, unit);
    }

    public ExpressionBuilder minusDate(Object start, String unit) {
        return this.withOp(QueryUtils.OperatorType.DATEDIFF, start, unit);
    }

    public ExpressionBuilder datePart(String unit) {
        return this.withOp(QueryUtils.OperatorType.DATEPART, unit);
    }

    public ExpressionBuilder dateonlyPart(String unit) {
        return this.withOp(QueryUtils.OperatorType.DATEONLYPART, unit);
    }

    public ExpressionBuilder datetimenotzPart(String unit) {
        return this.withOp(QueryUtils.OperatorType.DATETIMENOTZPART, unit);
    }

    public ExpressionBuilder extract(String unit) {
        return this.withOp(QueryUtils.OperatorType.EXTRACT_FROM_INTERVAL, unit);
    }

    public ExpressionBuilder dateAdd(Object addIntLong, String unit) {
        return this.withOp(QueryUtils.OperatorType.DATE_ADD, addIntLong, unit);
    }

    public ExpressionBuilder splitString(Object pattern) {
        return this.withOp(QueryUtils.OperatorType.SPLIT, pattern);
    }

    public ExpressionBuilder splitPartString(Object pattern, int position) {
        return this.withOp(QueryUtils.OperatorType.SPLIT_PART, pattern, position);
    }

    public ExpressionBuilder getInArray(Object index) {
        return this.withOp(QueryUtils.OperatorType.GET, index);
    }

    public ExpressionBuilder cast(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.CAST, vargs);
    }

    public ExpressionBuilder parse(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.PARSE, vargs);
    }

    public ExpressionBuilder tryParse(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.TRY_PARSE, vargs);
    }

    public ExpressionBuilder format(Object ... vargs) {
        return this.withOp(QueryUtils.OperatorType.FORMAT, vargs);
    }

    public ExpressionBuilder uniqueId() {
        return this.withOp(QueryUtils.OperatorType.UNIQUE_ID, new Object[0]);
    }

    public ExpressionBuilder intToBool() {
        return this.cast(Type.BOOLEAN);
    }

    public ExpressionBuilder castToBigint() {
        return this.cast(Type.BIGINT);
    }

    public ExpressionBuilder castToBoolean() {
        return this.cast(Type.BOOLEAN);
    }

    public ExpressionBuilder castToInt() {
        return this.cast(Type.INT);
    }

    public ExpressionBuilder castToFloat() {
        return this.cast(Type.FLOAT);
    }

    public ExpressionBuilder castToDouble() {
        return this.cast(Type.DOUBLE);
    }

    public ExpressionBuilder castToString(int maxLength) {
        return this.cast(Type.STRING, maxLength);
    }

    public ExpressionBuilder castToDate() {
        return this.cast(Type.DATE);
    }

    public ExpressionBuilder castToDatetimeNoTz() {
        return this.cast(Type.DATETIMENOTZ);
    }

    public ExpressionBuilder nullValue(Type type, int maxLength) {
        return this.withOp(QueryUtils.OperatorType.NULL, type, maxLength);
    }

    public ExpressionBuilder nullWhen(Object cond, Type type, int maxLength) {
        return this.withOp(QueryUtils.OperatorType.NULL_WHEN, cond, type, maxLength);
    }

    public ExpressionBuilder mssToEpoch() {
        return this.withOp(QueryUtils.OperatorType.MSS_TO_EPOCH, new Object[0]);
    }

    public ExpressionBuilder mssToDateOnlyEpoch() {
        return this.withOp(QueryUtils.OperatorType.MSS_TO_DATEONLY_EPOCH, new Object[0]);
    }

    public ExpressionBuilder mssToDatetimeNoTzEpoch() {
        return this.withOp(QueryUtils.OperatorType.MSS_TO_DATETIMENOTZ_EPOCH, new Object[0]);
    }

    public ExpressionBuilder stringToDate() {
        return this.withOp(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, new Object[0]);
    }

    public ExpressionBuilder stringToDateOnly() {
        return this.withOp(QueryUtils.OperatorType.STRING_TO_DATE, new Object[0]);
    }

    public ExpressionBuilder stringToDatetimeNoTz() {
        return this.withOp(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, new Object[0]);
    }

    public ExpressionBuilder isNullOrEmptyString() {
        return this.withOp(QueryUtils.OperatorType.ISNULLOREMPTY, new Object[0]);
    }

    public ExpressionBuilder coalesceNullOrEmptyString(ExpressionBuilder replacement) {
        return this.withOp(QueryUtils.OperatorType.DEFAULT_IF_NULL_OR_EMPTY, replacement);
    }

    public ExpressionBuilder convertFromTz(String timezone) {
        return this.withOp(QueryUtils.OperatorType.FROM_TIMEZONE, timezone);
    }

    public ExpressionBuilder convertFromTzWithNtz(String timezone) {
        return this.withOp(QueryUtils.OperatorType.FROM_TIMEZONE_NTZ, timezone);
    }

    public ExpressionBuilder convertFromTz(String timezone, String toTimezone) {
        return this.withOp(QueryUtils.OperatorType.FROM_TIMEZONE, timezone, toTimezone);
    }

    public ExpressionBuilder convertFromTz(ExpressionBuilder timezone, String toTimezone) {
        return this.withOp(QueryUtils.OperatorType.FROM_TIMEZONE, timezone, toTimezone);
    }

    public ExpressionBuilder geoBuffer(Object ... varg) {
        return this.withOp(QueryUtils.OperatorType.ST_BUFFER, varg);
    }

    public ExpressionBuilder geoSimplify(float toleranceDistance) {
        return this.withOp(QueryUtils.OperatorType.ST_SIMPLIFY, Float.valueOf(toleranceDistance));
    }

    public ExpressionBuilder geoEnvelope() {
        return this.withOp(QueryUtils.OperatorType.ST_ENVELOPE, new Object[0]);
    }

    public ExpressionBuilder geoMakeValid() {
        return this.withOp(QueryUtils.OperatorType.ST_MAKEVALID, new Object[0]);
    }

    public ExpressionBuilder toBase64() {
        return this.withOp(QueryUtils.OperatorType.TO_BASE64, new Object[0]);
    }

    public ExpressionBuilder toJsonString() {
        return this.withOp(QueryUtils.OperatorType.TO_JSON_STRING, new Object[0]);
    }

    public ExpressionBuilder jsonArraySum(java.lang.Boolean isMultipleArgument) {
        ExpressionBuilder eb = new ExpressionBuilderFactory().expr(String.valueOf(isMultipleArgument));
        return this.withOp(QueryUtils.OperatorType.JSON_ARRAY_SUM, eb);
    }

    public ExpressionBuilder jsonArrayCount(java.lang.Boolean isMultipleArgument) {
        ExpressionBuilder eb = new ExpressionBuilderFactory().expr(String.valueOf(isMultipleArgument));
        return this.withOp(QueryUtils.OperatorType.JSON_ARRAY_COUNT, eb);
    }

    public ExpressionBuilder removeAccents() {
        return this.translate(accentuated, unaccentuated);
    }

    public ExpressionBuilder normalizeText() {
        return this.lower().translate("\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e7\u0107\u0109\u010b\u010d\u00f0\u010f\u0111\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u0138\u013a\u013c\u013e\u0140\u0142\u00f1\u0144\u0146\u0148\u0149\u014b\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u017f\u0163\u0165\u0167\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u00fd\u00ff\u0177\u017a\u017c\u017e-'\"\u00a0", StringTransformation.normalized).replace(" ", "");
    }

    public ExpressionBuilder castForAggregateIfNeeded(SQLDialect dialect, Type t) {
        if (t.isInteger() && t != Type.BIGINT && dialect.integerAggregateCanOverflow()) {
            return this.castToBigint();
        }
        return this;
    }

    public static class ExpressionBuilderFactory {
        private static final Boolean booleanMeaning = new Boolean();

        public ExpressionBuilder col(String columnName) {
            return new ExpressionBuilder(new QueryAst.Column(columnName));
        }

        public ExpressionBuilder col(String columnName, Type type) {
            return new ExpressionBuilder(new QueryAst.Column(columnName, type));
        }

        public ExpressionBuilder col(String tableName, String columnName) {
            QueryAst.Table table = new QueryAst.Table(null, null, tableName, null);
            return this.col(table, columnName);
        }

        public ExpressionBuilder col(String catalog, String tableSchema, String tableName, String columnName) {
            QueryAst.Table table = new QueryAst.Table(catalog, tableSchema, tableName, null);
            return this.col(table, columnName);
        }

        public ExpressionBuilder col(QueryAst.TableLike table, String columnName) {
            return new ExpressionBuilder(new QueryAst.Column(table, columnName));
        }

        public ExpressionBuilder col(ExpressionBuilder eb) {
            assert (eb.expr instanceof QueryAst.Column);
            QueryAst.Column original = (QueryAst.Column)eb.expr;
            return new ExpressionBuilder(new QueryAst.Column(original.table, original.name));
        }

        public ExpressionBuilder cst(Object value) {
            return new ExpressionBuilder(new QueryAst.ConstExpr(value));
        }

        public ExpressionBuilder cst(Object value, boolean isDeltaPartitionValue) {
            return new ExpressionBuilder(isDeltaPartitionValue ? new QueryAst.ConstExpr(value).useCurrentTZForQuoteDate(true) : new QueryAst.ConstExpr(value));
        }

        public ExpressionBuilder cst(Object value, Type forcedType) {
            QueryAst.ConstExpr cst = new QueryAst.ConstExpr(value);
            cst.outputType.dssType = forcedType;
            return new ExpressionBuilder(cst);
        }

        public ExpressionBuilder list(Object ... vargs) {
            List<QueryAst.Expr> items = ExpressionBuilder.makeExpressionsList(vargs);
            return new ExpressionBuilder(new QueryAst.ListExpr(items));
        }

        public ExpressionBuilder expr(String expr) {
            return new ExpressionBuilder(new QueryAst.InlineExpr(expr));
        }

        public ExpressionBuilder expr(String expr, String windowKey, QueryAst.Window window) {
            return new ExpressionBuilder(new QueryAst.InlineExpr(expr).withWindow(windowKey, window));
        }

        public ExpressionBuilder expr(QueryAst.Expr expr) {
            return new ExpressionBuilder(expr);
        }

        public ExpressionBuilder expr() {
            return this.expr((QueryAst.Expr)null);
        }

        public ExpressionBuilder cmt(String comment) {
            return new ExpressionBuilder(new QueryAst.Comment(comment));
        }

        public ExpressionBuilder count(String column) {
            return new ExpressionBuilder(new QueryAst.Column(column)).count();
        }

        public ExpressionBuilder rank() {
            return new ExpressionBuilder(null).rank();
        }

        public ExpressionBuilder denseRank() {
            return new ExpressionBuilder(null).denseRank();
        }

        public ExpressionBuilder rowNumber() {
            return new ExpressionBuilder(null).rowNumber();
        }

        public ExpressionBuilder cumeDist() {
            return new ExpressionBuilder(null).cumeDist();
        }

        public ExpressionBuilder ntile(int buckets) {
            return new ExpressionBuilder(null).ntile(buckets);
        }

        public ExpressionBuilder coalesce(ExpressionBuilder ... vargs) {
            return new ExpressionBuilder(null).withOp(QueryUtils.OperatorType.COALESCE, vargs);
        }

        public ExpressionBuilder or(ExpressionBuilder ... vargs) {
            return new ExpressionBuilder(null).or(vargs);
        }

        public ExpressionBuilder and(ExpressionBuilder ... vargs) {
            return new ExpressionBuilder(null).and(vargs);
        }

        public ExpressionBuilder not() {
            return new ExpressionBuilder(null).withOp(QueryUtils.OperatorType.NOT, new Object[0]);
        }

        public ExpressionBuilder op(QueryUtils.OperatorType opType, Object ... vargs) {
            return new ExpressionBuilder(null).withOp(opType, vargs);
        }

        public ExpressionBuilder dateDiff(QueryAst.Expr end, QueryAst.Expr start, String unit) {
            return new ExpressionBuilder(end).minusDate(start, unit);
        }

        public ExpressionBuilder uniqueId() {
            return new ExpressionBuilder(null).uniqueId();
        }

        public ExpressionBuilder srcPartitionId(String colName) {
            return new ExpressionBuilder(new QueryAst.ConstExpr("$DKU_SRC_" + colName));
        }

        public ExpressionBuilder dstPartitionId(SchemaColumn column, Dimension dim) {
            Type columnType = column.getType();
            String columnName = column.getName();
            if (dim instanceof TimeDimension && columnType.isTemporal()) {
                TimeDimension.Period period = ((TimeDimension)dim).mappedPeriod;
                String variabilizedExpr = switch (period) {
                    case TimeDimension.Period.YEAR -> "$DKU_DST_YEAR-01-01 00:00:00";
                    case TimeDimension.Period.MONTH -> "$DKU_DST_YEAR-$DKU_DST_MONTH-01 00:00:00";
                    case TimeDimension.Period.DAY -> "$DKU_DST_YEAR-$DKU_DST_MONTH-$DKU_DST_DAY 00:00:00";
                    case TimeDimension.Period.HOUR -> "$DKU_DST_YEAR-$DKU_DST_MONTH-$DKU_DST_DAY $DKU_DST_HOUR:00:00";
                    default -> throw new Error("unreachable");
                };
                if (columnType == Type.DATE) {
                    return new ExpressionBuilder(new QueryAst.ConstExpr(variabilizedExpr)).stringToDate();
                }
                if (columnType == Type.DATEONLY) {
                    variabilizedExpr = variabilizedExpr.replace(" 00:00:00", "");
                    return new ExpressionBuilder(new QueryAst.ConstExpr(variabilizedExpr)).stringToDateOnly();
                }
                return new ExpressionBuilder(new QueryAst.ConstExpr(variabilizedExpr)).stringToDatetimeNoTz();
            }
            if (columnType != null && columnType.isNumeric()) {
                return new ExpressionBuilder(new QueryAst.InlineExpr("$DKU_DST_" + columnName));
            }
            if (columnType == Type.BOOLEAN) {
                return new ExpressionBuilder(new QueryAst.ConstExpr("$DKU_DST_" + columnName)).castToBoolean();
            }
            if (columnType == Type.STRING) {
                return new ExpressionBuilder(new QueryAst.ConstExpr("$DKU_DST_" + columnName)).castToString(column.getMaxLength());
            }
            return new ExpressionBuilder(new QueryAst.ConstExpr("$DKU_DST_" + columnName));
        }

        public ExpressionBuilder dstPartitionValue(SchemaColumn column, DimensionValue dimensionValue, SQLDialect dialect) {
            Type valueType = column.getType();
            String partitionValue = ExpressionUtils.getStringForDimensionValue(dimensionValue, valueType);
            if (valueType.isNumeric()) {
                if (valueType.isFloatingPoint()) {
                    return new ExpressionBuilder(new QueryAst.ConstExpr(Double.parseDouble(partitionValue)));
                }
                return new ExpressionBuilder(new QueryAst.ConstExpr(Long.parseLong(partitionValue)));
            }
            if (valueType == Type.BOOLEAN) {
                return new ExpressionBuilder(new QueryAst.ConstExpr(booleanMeaning.parse(partitionValue)));
            }
            if (valueType == Type.DATE) {
                return new ExpressionBuilder(new QueryAst.ConstExpr(partitionValue));
            }
            if (valueType == Type.DATEONLY) {
                return new ExpressionBuilder(new QueryAst.ConstExpr(partitionValue)).cast(Type.DATEONLY);
            }
            if (valueType == Type.DATETIMENOTZ) {
                return new ExpressionBuilder(new QueryAst.ConstExpr(partitionValue)).cast(Type.DATETIMENOTZ);
            }
            int maxLength = column.getMaxLength() > 0 ? column.getMaxLength() : dialect.getDefaultVarcharLen();
            return new ExpressionBuilder(new QueryAst.ConstExpr(partitionValue)).castToString(maxLength);
        }

        public ExpressionBuilder nullValue(Type type, int maxLength) {
            return new ExpressionBuilder(null).nullValue(type, maxLength);
        }

        public ExpressionBuilder caseWhen(Object ... vargs) {
            return new ExpressionBuilder(null).caseWhen(vargs);
        }

        public ExpressionBuilder parameterizedColumnOperation(String columnName, QueryUtils.OperatorType operator) {
            ExpressionBuilder col = this.col(columnName);
            ExpressionBuilder parameter = this.expr("?");
            switch (operator) {
                case EQ: {
                    throw new NotImplementedException(String.format("Unsupported operator type '%s'. You should consider using '%s' instead.", new Object[]{operator, QueryUtils.OperatorType.NULL_UNSAFE_EQ}));
                }
                case NULL_UNSAFE_EQ: {
                    return col.nullUnsafeEq(parameter);
                }
                case GT: {
                    return col.gt(parameter);
                }
            }
            throw new NotImplementedException(String.format("Unsupported operator type '%s'.", new Object[]{operator}));
        }
    }
}

