/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.SQLDialect;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.util.List;

public final class QueryBuilderUtils {
    public static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    private QueryBuilderUtils() {
    }

    public static String tuple(List<String> columns, SQLDialect dialect) {
        return QueryBuilderUtils.tuple(columns, dialect, COMMA_JOINER);
    }

    public static String tuple(List<String> columns, final SQLDialect dialect, Joiner joiner) {
        return "(" + FluentIterable.from(columns).transform((Function)new Function<String, String>(){

            public String apply(String col) {
                return dialect.quoteIdentifier(col);
            }
        }).join(joiner) + ")";
    }

    public static String columnDefinition(SchemaColumn column, SQLDialect dialect) {
        return dialect.quoteIdentifier(column.getName()) + " " + dialect.getSQLType((SchemaColumn)column, null).sqlDecl;
    }
}

