/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.queries.QuotedPortionFinder;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Splitter {
    private final QuotedPortionFinderFactory[] portionFinderFactories;
    private static String MANUAL_SPLIT_PATTERN = "(--\\s*DKU_END_STATEMENT.*?\\r?\\n)";

    public Splitter(QuotedPortionFinderFactory[] portionFinderFactories) {
        this.portionFinderFactories = portionFinderFactories;
    }

    public String[] split(String sql) {
        return (String[])this.splitWithLineOffsets((String)sql, (boolean)true).first;
    }

    public String[] splitNoTrim(String sql) {
        return (String[])this.splitWithLineOffsets((String)sql, (boolean)false).first;
    }

    private List<FinderMatches> prepareMatches(String sql, QuotedPortionFinder[] portionFinders) {
        ArrayList positionsByFinder = Lists.newArrayList();
        for (QuotedPortionFinder finder : portionFinders) {
            int pos = 0;
            FinderMatches matches = new FinderMatches(finder);
            while (pos < sql.length()) {
                int nextStart = finder.findStart(pos);
                if (nextStart >= 0) {
                    int startLength = finder.startSegmentLength(nextStart);
                    matches.add(nextStart, startLength);
                    pos = nextStart + 1;
                    continue;
                }
                pos = sql.length();
            }
            positionsByFinder.add(matches);
        }
        return positionsByFinder;
    }

    public Pair<String[], Integer[]> splitWithLineOffsets(String sql, boolean trim) {
        Matcher manualSplit = Pattern.compile(MANUAL_SPLIT_PATTERN, 2).matcher(sql);
        ArrayList splitted = Lists.newArrayList();
        ArrayList offsets = Lists.newArrayList();
        if (manualSplit.find()) {
            int searchPos = 0;
            int lineOffset = 0;
            while (searchPos < sql.length() && manualSplit.find(searchPos)) {
                int statementMarkerStart = manualSplit.start();
                String part = sql.substring(searchPos, statementMarkerStart);
                splitted.add(part);
                offsets.add(lineOffset);
                searchPos = manualSplit.end();
                lineOffset += StringUtils.countMatches((String)part, (String)"\n") + 1;
            }
            if (searchPos < sql.length()) {
                splitted.add(sql.substring(searchPos));
                offsets.add(lineOffset);
            }
        } else {
            QuotedPortionFinder[] portionFinders = new QuotedPortionFinder[this.portionFinderFactories.length];
            for (int i = 0; i < portionFinders.length; ++i) {
                portionFinders[i] = this.portionFinderFactories[i].build(sql);
            }
            List<FinderMatches> positionsByFinder = this.prepareMatches(sql, portionFinders);
            int searchPos = 0;
            int statementPos = 0;
            while (searchPos < sql.length()) {
                QuotedPortionFinder closestPortion = null;
                int closestPortionStart = sql.length();
                int closestPortionLength = sql.length();
                for (FinderMatches positions : positionsByFinder) {
                    while (positions.index < positions.matches.size() && searchPos > positions.matches.get((int)positions.index).start) {
                        ++positions.index;
                    }
                    if (positions.index >= positions.matches.size()) continue;
                    int start = positions.matches.get((int)positions.index).start;
                    int length = positions.matches.get((int)positions.index).startLength;
                    if (start >= closestPortionStart && (start != closestPortionStart || length <= closestPortionLength)) continue;
                    closestPortionStart = start;
                    closestPortionLength = length;
                    closestPortion = positions.finder;
                }
                int closestSemicolon = sql.indexOf(59, searchPos);
                if (closestSemicolon < 0) {
                    closestSemicolon = sql.length();
                }
                if (closestSemicolon <= closestPortionStart) {
                    int statementLength;
                    String statement = sql.substring(statementPos, closestSemicolon);
                    if (trim) {
                        statement = statement.trim();
                        statementLength = statement.length();
                    } else {
                        statementLength = statement.trim().length();
                    }
                    if (statementLength > 0) {
                        splitted.add(statement);
                        int trimmedPos = statementPos;
                        while (sql.charAt(trimmedPos) <= ' ') {
                            ++trimmedPos;
                        }
                        offsets.add(StringUtils.countMatches((String)sql.substring(0, trimmedPos), (String)"\n"));
                    }
                    statementPos = searchPos = closestSemicolon + 1;
                    continue;
                }
                searchPos = closestPortion.findEnd(closestPortionStart) + 1;
            }
            if (statementPos < sql.length()) {
                int statementLength;
                String statement = sql.substring(statementPos);
                if (trim) {
                    statement = statement.trim();
                    statementLength = statement.length();
                } else {
                    statementLength = statement.trim().length();
                }
                if (statementLength > 0) {
                    splitted.add(statement);
                    int trimmedPos = statementPos;
                    while (sql.charAt(trimmedPos) <= ' ') {
                        ++trimmedPos;
                    }
                    offsets.add(StringUtils.countMatches((String)sql.substring(0, statementPos), (String)"\n"));
                }
            }
        }
        assert (splitted.size() == offsets.size());
        return new Pair((Object)splitted.toArray(new String[splitted.size()]), (Object)offsets.toArray(new Integer[offsets.size()]));
    }

    private String strip(String sql, boolean keepStrings) {
        List<QueryChunk> chunks = this.chunkComments(sql, keepStrings);
        StringBuilder sb = new StringBuilder();
        for (QueryChunk chunk : chunks) {
            if (chunk.isComment) continue;
            sb.append(chunk.chunk);
        }
        return sb.toString();
    }

    public List<QueryChunk> chunkComments(String sql) {
        return this.chunkComments(sql, true);
    }

    private List<QueryChunk> chunkComments(String sql, boolean keepStrings) {
        ArrayList chunks = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        QuotedPortionFinder[] portionFinders = new QuotedPortionFinder[this.portionFinderFactories.length];
        for (int i = 0; i < portionFinders.length; ++i) {
            portionFinders[i] = this.portionFinderFactories[i].build(sql);
        }
        List<FinderMatches> positionsByFinder = this.prepareMatches(sql, portionFinders);
        int searchPos = 0;
        while (searchPos < sql.length()) {
            QuotedPortionFinder closestPortion = null;
            int closestPortionStart = sql.length();
            int closestPortionLength = sql.length();
            for (FinderMatches positions : positionsByFinder) {
                while (positions.index < positions.matches.size() && searchPos > positions.matches.get((int)positions.index).start) {
                    ++positions.index;
                }
                if (positions.index >= positions.matches.size()) continue;
                int start = positions.matches.get((int)positions.index).start;
                int length = positions.matches.get((int)positions.index).startLength;
                if (start >= closestPortionStart && (start != closestPortionStart || length <= closestPortionLength)) continue;
                closestPortionStart = start;
                closestPortionLength = length;
                closestPortion = positions.finder;
            }
            if (closestPortion == null) break;
            int closestPortionEnd = closestPortion.findEnd(closestPortionStart) + 1;
            sb.append(sql.substring(searchPos, closestPortionStart));
            if (keepStrings && !closestPortion.findsComments()) {
                sb.append(sql.substring(closestPortionStart, closestPortionEnd));
            }
            searchPos = closestPortionEnd;
            if (!closestPortion.findsComments()) continue;
            if (sb.length() > 0) {
                chunks.add(new QueryChunk(sb.toString(), false));
            }
            chunks.add(new QueryChunk(sql.substring(closestPortionStart, closestPortionEnd), true));
            sb.delete(0, sb.length());
        }
        sb.append(sql.substring(searchPos));
        if (sb.length() > 0) {
            chunks.add(new QueryChunk(sb.toString(), false));
        }
        return chunks;
    }

    public String stripComments(String sql) {
        return this.strip(sql, true);
    }

    public String stripCommentsAndStrings(String sql) {
        return this.strip(sql, false);
    }

    public int findFirstMatch(String sql, Pattern pattern, int startPos, boolean inComment, boolean inString, boolean outsideStringAndComments) {
        QuotedPortionFinder[] portionFinders = new QuotedPortionFinder[this.portionFinderFactories.length];
        for (int i = 0; i < portionFinders.length; ++i) {
            portionFinders[i] = this.portionFinderFactories[i].build(sql);
        }
        Matcher nonWhitespace = pattern.matcher(sql);
        int searchPos = startPos;
        while (searchPos < sql.length()) {
            int nextNonWhitespace;
            QuotedPortionFinder closestPortion = null;
            int closestPortionStart = sql.length();
            int closestPortionLength = sql.length();
            for (QuotedPortionFinder portionFinder : portionFinders) {
                int start = portionFinder.findStart(searchPos);
                if (start < 0) continue;
                int length = portionFinder.startSegmentLength(start);
                if (start >= closestPortionStart && (start != closestPortionStart || length <= closestPortionLength)) continue;
                closestPortionStart = start;
                closestPortionLength = length;
                closestPortion = portionFinder;
            }
            int n = nextNonWhitespace = nonWhitespace.find(searchPos) ? nonWhitespace.start() : sql.length();
            if (closestPortion != null && closestPortionStart <= nextNonWhitespace) {
                int closestPortionEnd = closestPortion.findEnd(closestPortionStart) + 1;
                if (inComment && closestPortion.findsComments() || inString && !closestPortion.findsComments()) {
                    int n2 = nextNonWhitespace = nonWhitespace.find(closestPortionStart) ? nonWhitespace.start() : sql.length();
                    if (nextNonWhitespace < closestPortionEnd) {
                        searchPos = closestPortionStart;
                        break;
                    }
                }
                searchPos = closestPortionEnd;
                continue;
            }
            searchPos = nextNonWhitespace;
            if (!outsideStringAndComments) continue;
            break;
        }
        return searchPos;
    }

    private static class FinderMatches {
        QuotedPortionFinder finder;
        int index = 0;
        List<FinderMatch> matches = Lists.newArrayList();

        FinderMatches(QuotedPortionFinder finder) {
            this.finder = finder;
        }

        void add(int start, int startLength) {
            this.matches.add(new FinderMatch(start, startLength));
        }
    }

    private static class FinderMatch {
        final int start;
        final int startLength;

        FinderMatch(int start, int startLength) {
            this.start = start;
            this.startLength = startLength;
        }
    }

    public static class QueryChunk {
        public final String chunk;
        public final boolean isComment;

        public QueryChunk(String chunk, boolean isComment) {
            this.chunk = chunk;
            this.isComment = isComment;
        }
    }
}

