/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.WorkspaceTimelineItemEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineItem;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkspaceTimelinesService {
    private static final long MAX_TIME_DIFF_TO_COLLAPSE = 43200000L;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UsersService usersService;
    @Autowired
    private WorkspaceTimelinesInternalDB timelinesInternalDB;
    @Autowired
    private EnrichmentService enrichmentService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    public WorkspaceTimelinesService() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void push(WorkspaceTimelineItem ti) throws CodedSQLException {
        this.updateTimelineDB(ti);
        this.pubSub.publish(new WorkspaceTimelineItemEvent(ti));
    }

    public WorkspaceTimelineWithVersioning getWorkspaceTimeline_NT(String workspaceKey, int from, int limit) throws CodedSQLException, IOException {
        WorkspaceTimelineWithVersioning ret = this.timelinesInternalDB.getForWorkspace(workspaceKey, from, limit);
        WorkspaceTimelineItem firstForObject = this.timelinesInternalDB.getFirstForObject(workspaceKey, ITaggingService.TaggableType.WORKSPACE, "$$$WORKSPACES$$$", workspaceKey);
        try (Transaction ignored = this.transactionService.beginRead();){
            for (WorkspaceTimelineItem ti : ret.items) {
                try {
                    this.enrichmentService.enrich(ti);
                }
                catch (Exception e) {
                    logger.info((Object)("Failed to enrich workspace timeline item: " + String.valueOf(ti)), (Throwable)e);
                }
            }
            this.updateTimelineWithModifiedAndCreation(ret, firstForObject);
        }
        return ret;
    }

    public long getWorkspaceLastModification_NT(String workspaceKey) throws CodedSQLException {
        WorkspaceTimelineItem item = this.timelinesInternalDB.getLatest(workspaceKey);
        return item == null ? -1L : item.time;
    }

    public long getWorkspaceLastModificationForUser_NT(String workspaceKey, String userId) throws CodedSQLException {
        WorkspaceTimelineItem item = this.timelinesInternalDB.getLatestForUser(workspaceKey, userId);
        return item == null ? -1L : item.time;
    }

    private void updateTimelineDB(WorkspaceTimelineItem ti) throws CodedSQLException {
        WorkspaceTimelineItem latest = this.timelinesInternalDB.getLatestForObject(ti.workspaceKey, ti.objectType, ti.projectKey, ti.objectId);
        if (WorkspaceTimelinesService.collapse(ti, latest)) {
            logger.debugV("Collapse workspace timeline item %s", new Object[]{ti});
            this.timelinesInternalDB.update(ti);
        } else {
            logger.debugV("Add workspace timeline item %s", new Object[]{ti});
            this.timelinesInternalDB.insert(ti);
        }
    }

    private void updateTimelineWithModifiedAndCreation(WorkspaceTimelineWithVersioning ret, WorkspaceTimelineItem firstForObject) throws IOException {
        if (!ret.items.isEmpty()) {
            ret.lastModifiedBy = this.usersService.getPublicUser(ret.items.get((int)0).user);
            ret.lastModifiedOn = ret.items.get((int)0).time;
        }
        if (firstForObject != null) {
            ret.createdBy = this.usersService.getPublicUser(firstForObject.user);
            ret.createdOn = firstForObject.time;
        }
    }

    private static boolean collapse(WorkspaceTimelineItem a, WorkspaceTimelineItem b) {
        return a != null && b != null && a.action == b.action && a.action.isCollapsable() && !a.action.isRenaming() && StringUtils.equals((String)a.user, (String)b.user) && Math.abs(a.time - b.time) < 43200000L;
    }

    public static class WorkspaceTimelineWithVersioning
    extends HeadWithVersioningInfo {
        public List<WorkspaceTimelineItem> items = new ArrayList<WorkspaceTimelineItem>();
    }
}

