/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class ProjectsGitServiceHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.git.helper");

    ProjectsGitServiceHelper() {
    }

    static boolean regenerateAPIKeys(String projectKey, List<ProjectScopePublicAPIKey> apiKeysFromSnapshot, Map<String, String> webappApiKeysFromSnapshot, PasswordEncryptionService passwordEncryptionService) throws IOException {
        RelFile apiKeysFile = new RelFile(new String[]{"projects", projectKey, "apikeys.json"});
        RelFile webAppDirectory = new RelFile(new String[]{"projects", projectKey, "web_apps"});
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.isFile(apiKeysFile)) {
            logger.info((Object)"Update api keys");
            ProjectScopePublicAPIKey.KeyList apiKeys1 = (ProjectScopePublicAPIKey.KeyList)tr.readObject(apiKeysFile, ProjectScopePublicAPIKey.KeyList.class);
            assert (apiKeys1 != null);
            HashMap<String, ProjectScopePublicAPIKey> reference = new HashMap<String, ProjectScopePublicAPIKey>();
            for (ProjectScopePublicAPIKey projectScopePublicAPIKey : apiKeysFromSnapshot) {
                reference.put(projectScopePublicAPIKey.id, projectScopePublicAPIKey);
            }
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            for (ProjectScopePublicAPIKey apiKey : apiKeys1) {
                String id = apiKey.id;
                ProjectScopePublicAPIKey referenceKey = (ProjectScopePublicAPIKey)((Object)reference.get(id));
                if (referenceKey == null || Objects.equals(apiKey.key, referenceKey.key)) continue;
                replacementMap.put(apiKey.key, referenceKey.key);
                apiKey.key = referenceKey.key;
            }
            if (!replacementMap.isEmpty()) {
                RWTransactionRef rWTransactionRef = TransactionContext.retrieveWrite();
                rWTransactionRef.writeObject(apiKeysFile, (Object)apiKeys1);
                if (tr.isDirectory(webAppDirectory)) {
                    try {
                        List files = tr.listFiles(webAppDirectory);
                        for (RelFile file : files) {
                            ProjectsGitServiceHelper.updateWebApp(file, replacementMap, webappApiKeysFromSnapshot, passwordEncryptionService);
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to list webapps ", (Throwable)e);
                    }
                }
                return true;
            }
            logger.info((Object)"No change in API keys file required");
            return false;
        }
        logger.info((Object)"No API keys file");
        return false;
    }

    static void updateWebApp(RelFile file, Map<String, String> replacementMap, Map<String, String> webappApiKeysFromSnapshot, PasswordEncryptionService passwordEncryptionService) {
        if (!file.getFullPath().endsWith("json")) {
            return;
        }
        logger.info((Object)("Update webapp: " + file.getFullPath()));
        try {
            RWTransactionRef tw = TransactionContext.retrieveWrite();
            WebApp app = (WebApp)tw.readObject(file, WebApp.class);
            try {
                String appId = FilenameUtils.removeExtension((String)file.getLeafName());
                String replacementWebAppKey = webappApiKeysFromSnapshot.get(appId);
                if (replacementWebAppKey == null) {
                    logger.info((Object)("Skipping webapp: '" + appId + "', not found in project snapshot"));
                    return;
                }
                if (app.apiKey != null) {
                    for (String replacedKey : replacementMap.keySet()) {
                        if (!ApiKeyUtils.compareKeySecret((String)passwordEncryptionService.decryptIfEncrypted(app.apiKey), (String)replacedKey)) continue;
                        app.apiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(replacementWebAppKey);
                        tw.writeObject(file, (Object)app);
                    }
                }
            }
            catch (Exception e) {
                logger.info((Object)("Failed to update webapp apiKey in " + file.getFullPath()), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to parse webapp in " + file.getFullPath()), (Throwable)e);
        }
    }

    static boolean sameApiKeys(List<ProjectScopePublicAPIKey> apiKeys1, List<ProjectScopePublicAPIKey> apiKeys2) {
        return ProjectsGitServiceHelper.duplicateAndSortApiKeys(apiKeys1).equals(ProjectsGitServiceHelper.duplicateAndSortApiKeys(apiKeys2));
    }

    static boolean samePermissions(List<SerializedProject.PermissionItem> permissions1, List<SerializedProject.PermissionItem> permissions2) {
        return ProjectsGitServiceHelper.duplicateAndSortPermissions(permissions1).equals(ProjectsGitServiceHelper.duplicateAndSortPermissions(permissions2));
    }

    static boolean hasDuplicatedTag(List<String> tags) {
        return tags.contains(TaggingService.DEFAULT_TAG.DUPLICATED.name);
    }

    static List<String> addDuplicatedTag(List<String> tags) {
        ArrayList<String> result = new ArrayList<String>(tags);
        result.add(TaggingService.DEFAULT_TAG.DUPLICATED.name);
        return result;
    }

    static List<String> removeDuplicatedTag(List<String> tags) {
        ArrayList<String> result = new ArrayList<String>(tags);
        result.remove(TaggingService.DEFAULT_TAG.DUPLICATED.name);
        return result;
    }

    private static List<ProjectScopePublicAPIKey> duplicateAndSortApiKeys(List<ProjectScopePublicAPIKey> apiKeys) {
        ArrayList<ProjectScopePublicAPIKey> result = new ArrayList<ProjectScopePublicAPIKey>(apiKeys);
        Collections.sort(result, new Comparator<ProjectScopePublicAPIKey>(){

            @Override
            public int compare(ProjectScopePublicAPIKey o1, ProjectScopePublicAPIKey o2) {
                return o1.id.compareTo(o2.id);
            }
        });
        return result;
    }

    private static List<SerializedProject.PermissionItem> duplicateAndSortPermissions(List<SerializedProject.PermissionItem> permissions) {
        ArrayList<SerializedProject.PermissionItem> result = new ArrayList<SerializedProject.PermissionItem>(permissions);
        result.sort((o1, o2) -> {
            String pendingUserEmail2;
            String user2;
            int res;
            String group2;
            String group1 = o1 == null ? null : o1.group;
            String string = group2 = o2 == null ? null : o2.group;
            if (group1 == null) {
                res = group2 == null ? 0 : -1;
            } else {
                int n = res = group2 == null ? 1 : group1.compareTo(group2);
            }
            if (res != 0) {
                return res;
            }
            String user1 = o1 == null ? null : o1.user;
            String string2 = user2 = o2 == null ? null : o2.user;
            if (user1 == null) {
                res = user2 == null ? 0 : -1;
            } else {
                int n = res = user2 == null ? 1 : user1.compareTo(user2);
            }
            if (res != 0) {
                return res;
            }
            String pendingUserEmail1 = o1 == null ? null : o1.pendingUserEmail;
            String string3 = pendingUserEmail2 = o2 == null ? null : o2.pendingUserEmail;
            res = pendingUserEmail1 == null ? (pendingUserEmail2 == null ? 0 : -1) : (pendingUserEmail2 == null ? 1 : pendingUserEmail1.compareTo(pendingUserEmail2));
            return res;
        });
        return result;
    }
}

