/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsDAO;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.deployer.apideployer.monitoring.AbstractApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiDeploymentSystemMonitoringService;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiEndpointDeploymentActivityAndSystemMetrics;
import com.dataiku.dip.deployer.apideployer.monitoring.DeploymentAndEndpoint;
import com.dataiku.dip.deployer.apideployer.monitoring.ExternalApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.deployer.apideployer.monitoring.ManagedApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.deployer.apideployer.monitoring.MetricsAggregation;
import com.dataiku.dip.deployer.apideployer.monitoring.ScopeAndEndpoint;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.config.PublishedItem;
import com.dataiku.dip.deployer.common.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.AbstractMonitoredThing;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerCRUDService;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.AbstractMonitoredApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.MonitoredManagedApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.unifiedmonitoring.payloads.AbstractMonitoredApiEndpointWithActivityMetrics;
import com.dataiku.dip.unifiedmonitoring.payloads.EndpointIdentifier;
import com.dataiku.dip.unifiedmonitoring.payloads.MonitoredExternalApiEndpointWithActivityMetrics;
import com.dataiku.dip.unifiedmonitoring.payloads.MonitoredManagedApiEndpointWithActivityMetrics;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.settings.UnifiedMonitoringSettingsService;
import com.dataiku.dip.utils.CollectorUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringDeployerService {
    @Autowired
    TransactionService transactionService;
    @Autowired
    UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    @Autowired
    ConnectionsDAO connectionsDAO;
    @Autowired
    APIServiceDeploymentsDAO deploymentsDAO;
    @Autowired
    UnifiedMonitoringSettingsService unifiedMonitoringSettingsService;
    @Autowired
    ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    UnifiedMonitoringDeployerCRUDService unifiedMonitoringDeployerCRUDService;
    @Autowired
    ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    ApiEndpointActivityMonitoringService apiEndpointActivityMonitoringService;
    @Autowired
    ApiDeploymentSystemMonitoringService apiDeploymentSystemMonitoringService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.deployerService");

    public List<AbstractMonitoredProjectDeployment> listMonitoredProjectDeployments(AuthCtx user) throws Exception {
        List<String> unmonitoredInfrastructures;
        try (Transaction t = this.transactionService.beginRead();){
            unmonitoredInfrastructures = this.unifiedMonitoringSettingsDAO.read().unmonitoredProjectInfrastructures;
        }
        List<AbstractDeploymentLightStatus> deployments = this.projectDeploymentsService.listLightStatusUnsafe_NT_Check(user);
        List<String> deploymentIds = deployments.stream().filter(deployment -> !unmonitoredInfrastructures.contains(deployment.deploymentBasicInfo.infraId)).map(AbstractDeploymentLightStatus::getDeploymentBasicInfo).map(AbstractDeploymentBasicInfo::getId).collect(Collectors.toList());
        return this.unifiedMonitoringDeployerCRUDService.listMonitoredProjectDeployments(deploymentIds);
    }

    public AbstractMonitoredProjectDeployment getMonitoredProjectDeployment(AuthCtx user, String deploymentId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectDeploymentsService.getSettingsMandatoryUnsafe_Check(deploymentId, user);
        }
        AbstractMonitoredProjectDeployment deployment = this.unifiedMonitoringDeployerCRUDService.listMonitoredProjectDeployments(List.of(deploymentId)).stream().findFirst().orElse(null);
        if (deployment != null && this.unifiedMonitoringSettingsService.get().unmonitoredProjectInfrastructures.contains(deployment.infrastructureId)) {
            deployment.disabledInfra = true;
        }
        return deployment;
    }

    public List<AbstractMonitoredApiEndpoint> listMonitoredApiEndpoints(AuthCtx user, boolean removeDuplicatedExternalEndpoints) throws Exception {
        UnifiedMonitoringSettings unifiedMonitoringSettings;
        logger.infoV("Listing monitored API endpoints", new Object[0]);
        ArrayList<AbstractMonitoredApiEndpoint> resp = new ArrayList<AbstractMonitoredApiEndpoint>();
        try (Transaction t = this.transactionService.beginRead();){
            unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
        }
        List<String> unmonitoredInfrastructures = unifiedMonitoringSettings.unmonitoredEndpointInfrastructures;
        List<String> unmonitoredExternalEndpointsScopes = unifiedMonitoringSettings.unmonitoredExternalEndpointsScopes;
        List<String> deploymentIds = null;
        List<AbstractDeploymentLightStatus> deployments = this.apiServiceDeploymentsService.listLightStatusUnsafe_NT_Check(user);
        deploymentIds = deployments.stream().filter(deployment -> !unmonitoredInfrastructures.contains(deployment.deploymentBasicInfo.infraId)).map(AbstractDeploymentLightStatus::getDeploymentBasicInfo).map(AbstractDeploymentBasicInfo::getId).collect(Collectors.toList());
        if (deploymentIds != null) {
            resp.addAll(this.unifiedMonitoringDeployerCRUDService.listMonitoredManagedApiEndpoints(deploymentIds));
        }
        List monitoredExternalApiEndpoints = this.listMonitoredExternalApiEndpoints(user, removeDuplicatedExternalEndpoints).stream().filter(externalMonitoring -> !unmonitoredExternalEndpointsScopes.contains(externalMonitoring.externalEndpointsScope.name)).collect(Collectors.toList());
        resp.addAll(monitoredExternalApiEndpoints);
        return resp;
    }

    public MonitoredManagedApiEndpoint getMonitoredManagedApiEndpoint(AuthCtx user, String deploymentId, String endpointId) throws Exception {
        logger.infoV("Getting monitored managed API endpoint %s from deployment %s", new Object[]{deploymentId, endpointId});
        MonitoredManagedApiEndpoint resp = null;
        try (Transaction t = this.transactionService.beginRead();){
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
            Object dep = this.apiServiceDeploymentsService.getSettingsMandatory_Check(deploymentId, user);
            if (dep != null) {
                resp = this.unifiedMonitoringDeployerCRUDService.listMonitoredManagedApiEndpoints(List.of(deploymentId)).stream().filter(d -> d.endpointId.equals(endpointId)).findFirst().orElse(null);
                if (unifiedMonitoringSettings.unmonitoredEndpointInfrastructures.contains(((AbstractDeployment)dep).infraId)) {
                    if (resp == null) {
                        resp = new MonitoredManagedApiEndpoint();
                    }
                    resp.disabledInfra = true;
                }
            }
        }
        return resp;
    }

    public List<AbstractMonitoredApiEndpointWithActivityMetrics> listMonitoredApiEndpointWithActivityMetrics(AuthCtx user, @Nullable List<EndpointIdentifier> endpointsToFilterOn, boolean removeDuplicatedExternalEndpoints) throws Exception {
        Object scopeAndEndpointsToKeep;
        ArrayList<AbstractMonitoredApiEndpointWithActivityMetrics> results = new ArrayList<AbstractMonitoredApiEndpointWithActivityMetrics>();
        List<AbstractMonitoredApiEndpoint> monitoredEndpoints = this.listMonitoredApiEndpoints(user, removeDuplicatedExternalEndpoints);
        Map monitoredManagedApiEndpoints = monitoredEndpoints.stream().filter(endpointMonitoring -> endpointMonitoring.type.equals("MANAGED_API_ENDPOINT")).map(MonitoredManagedApiEndpoint.class::cast).collect(Collectors.toMap(e -> new DeploymentAndEndpoint(e.deploymentId, e.endpointName), e -> new MonitoredManagedApiEndpointWithActivityMetrics((MonitoredManagedApiEndpoint)e, null)));
        Map monitoredExternalApiEndpoints = monitoredEndpoints.stream().filter(endpointMonitoring -> endpointMonitoring.type.equals("EXTERNAL_API_ENDPOINT")).map(MonitoredExternalApiEndpoint.class::cast).collect(Collectors.toMap(e -> new ScopeAndEndpoint(e.externalEndpointsScope.name, e.endpointName), e -> new MonitoredExternalApiEndpointWithActivityMetrics((MonitoredExternalApiEndpoint)e, null)));
        if (CollectionUtils.isNotEmpty(endpointsToFilterOn)) {
            HashSet<DeploymentAndEndpoint> deploymentAndEndpointsToKeep = new HashSet<DeploymentAndEndpoint>();
            scopeAndEndpointsToKeep = new HashSet<ScopeAndEndpoint>();
            for (EndpointIdentifier ep : endpointsToFilterOn) {
                if (ep.isManagedApiEndpoint()) {
                    deploymentAndEndpointsToKeep.add(new DeploymentAndEndpoint(ep.deploymentId, ep.endpointId));
                    continue;
                }
                if (ep.isExternalApiEndpoint()) {
                    scopeAndEndpointsToKeep.add(new ScopeAndEndpoint(ep.externalEndpointsScopeName, ep.endpointName));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Endpoint must have exclusively either a (deploymentId, endpointId) OR a (externalEndpointsScopeName, endpointName) fields : %s", ep));
            }
            monitoredManagedApiEndpoints = (Map)monitoredManagedApiEndpoints.entrySet().stream().filter(entry -> deploymentAndEndpointsToKeep.contains(entry.getKey())).collect(CollectorUtils.toMap());
            monitoredExternalApiEndpoints = (Map)monitoredExternalApiEndpoints.entrySet().stream().filter(arg_0 -> UnifiedMonitoringDeployerService.lambda$listMonitoredApiEndpointWithActivityMetrics$11((Set)scopeAndEndpointsToKeep, arg_0)).collect(CollectorUtils.toMap());
        }
        logger.infoV("Retrieving monitored endpoints and activity metrics for %d DSS endpoints and %d external endpoints", new Object[]{monitoredManagedApiEndpoints.size(), monitoredExternalApiEndpoints.size()});
        List<ManagedApiEndpointUnifiedMonitoringActivityMetrics> managedActivityMetrics = this.apiEndpointActivityMonitoringService.getManagedActivityMetricsCounts_NT(user, monitoredManagedApiEndpoints.keySet());
        scopeAndEndpointsToKeep = managedActivityMetrics.iterator();
        while (scopeAndEndpointsToKeep.hasNext()) {
            ManagedApiEndpointUnifiedMonitoringActivityMetrics metric;
            ((MonitoredManagedApiEndpointWithActivityMetrics)monitoredManagedApiEndpoints.get((Object)new DeploymentAndEndpoint((String)metric.deploymentId, (String)metric.endpointName))).activityMetrics = metric = (ManagedApiEndpointUnifiedMonitoringActivityMetrics)scopeAndEndpointsToKeep.next();
        }
        results.addAll(monitoredManagedApiEndpoints.values());
        List<ExternalApiEndpointUnifiedMonitoringActivityMetrics> externalActivityMetrics = this.apiEndpointActivityMonitoringService.getExternalActivityMetricsCounts_NT(user, monitoredExternalApiEndpoints.keySet());
        Iterator<Object> iterator = externalActivityMetrics.iterator();
        while (iterator.hasNext()) {
            ExternalApiEndpointUnifiedMonitoringActivityMetrics metric;
            ((MonitoredExternalApiEndpointWithActivityMetrics)monitoredExternalApiEndpoints.get((Object)new ScopeAndEndpoint((String)metric.externalEndpointsScopeName, (String)metric.endpointName))).activityMetrics = metric = (ExternalApiEndpointUnifiedMonitoringActivityMetrics)iterator.next();
        }
        results.addAll(monitoredExternalApiEndpoints.values());
        return results;
    }

    public List<MonitoredExternalApiEndpoint> listMonitoredExternalApiEndpoints(AuthCtx user, boolean filterOutDeployAnywhereEndpoints) throws Exception {
        ArrayList<String> externalEndpointsScopeNamesWithPermissions = new ArrayList<String>();
        try (Transaction t = this.transactionService.beginRead();){
            List<UnifiedMonitoringExternalEndpointsScope> externalEndpointsScopes = this.unifiedMonitoringSettingsDAO.read().externalEndpointsScopes;
            for (UnifiedMonitoringExternalEndpointsScope externalEndpointsScope : externalEndpointsScopes) {
                try {
                    DSSConnection connection = this.connectionsDAO.getMandatoryConnection(user, externalEndpointsScope.connectionName);
                    if (!connection.isFreelyUsableBy(user)) continue;
                    externalEndpointsScopeNamesWithPermissions.add(externalEndpointsScope.name);
                }
                catch (Exception e) {
                    logger.warn((Object)String.format("Could not read permissions for connection %s", externalEndpointsScope.connectionName), (Throwable)e);
                }
            }
        }
        List<MonitoredExternalApiEndpoint> externalEndpointMonitorings = this.unifiedMonitoringDeployerCRUDService.listMonitoredExternalApiEndpoints(externalEndpointsScopeNamesWithPermissions);
        if (filterOutDeployAnywhereEndpoints) {
            List<AbstractDeploymentLightStatus> apiEndpointsDeployments = this.apiServiceDeploymentsService.listLightStatusUnsafe_NT_Check(user);
            List deployAnywhereExternalEndpointIdentifiers = apiEndpointsDeployments.stream().filter(abstractDeployment -> abstractDeployment.deploymentBasicInfo instanceof AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo && ((AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo)abstractDeployment.deploymentBasicInfo).deploymentInfo != null).map(abstractDeployment -> ((AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo)abstractDeployment.deploymentBasicInfo).deploymentInfo).map(AbstractDeploymentInfo::getExternalEndpointIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
            externalEndpointMonitorings.removeIf(externalEndpointMonitoring -> deployAnywhereExternalEndpointIdentifiers.contains(externalEndpointMonitoring.externalEndpointIdentifier));
        }
        return externalEndpointMonitorings;
    }

    public AbstractApiEndpointUnifiedMonitoringActivityMetrics getActivityMetrics_Check(AuthCtx user, EndpointIdentifier endpointIdentifier) throws Exception {
        if (endpointIdentifier.isManagedApiEndpoint()) {
            return this.apiEndpointActivityMonitoringService.getManagedActivityMetricsCounts_NT(user, endpointIdentifier.asDeploymentAndEndpoint());
        }
        if (endpointIdentifier.isExternalApiEndpoint()) {
            return this.apiEndpointActivityMonitoringService.getExternalActivityMetricsCounts_NT(user, endpointIdentifier.asScopeAndEndpoint());
        }
        throw new IllegalArgumentException(String.format("The format of %s is invalid. It should be either a deployment and endpoint, or a scope and scope", endpointIdentifier));
    }

    public void deleteExternalEndpointScope(String externalEndpointScopeName) {
        logger.infoV("Deleting external endpoint scope %s", new Object[]{externalEndpointScopeName});
        try {
            this.unifiedMonitoringDeployerCRUDService.deleteExternalEndpointSnapshots(externalEndpointScopeName);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Cannot delete monitorings of external endpoint scope %s", new Object[]{externalEndpointScopeName});
        }
        try {
            this.apiEndpointActivityMonitoringService.deleteRrdFiles(externalEndpointScopeName);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Cannot delete activity (rrd files) of external endpoint scope %s", new Object[]{externalEndpointScopeName});
        }
    }

    public void updateDeploymentMonitoringData(String deploymentId, AbstractDeploymentInfra.InfraType infraType) throws DKUSecurityException, IOException {
        Set<String> configuredEndpointsIds = this.apiServiceDeploymentsService.getConfiguredEndpointIds_NT(deploymentId, DSSAuthCtx.internalAdminAuth());
        this.unifiedMonitoringDeployerCRUDService.deleteUnusedManagedApiEndpointSnapshots(deploymentId, configuredEndpointsIds);
        this.apiEndpointActivityMonitoringService.deleteUnusedActivityRrds(deploymentId, configuredEndpointsIds);
        this.apiEndpointActivityMonitoringService.createEndpointsActivityMetricsRrds_NT(deploymentId, configuredEndpointsIds);
        if (this.apiNodeInfrasService.hasSystemMetrics(infraType)) {
            this.apiDeploymentSystemMonitoringService.createDeploymentSystemMetricsRrd_NT(deploymentId, infraType);
        }
    }

    public List<ApiEndpointDeploymentActivityAndSystemMetrics> getApiEndpointDeploymentActivityAndSystemMetrics(AuthCtx authCtx, String deploymentId, String endpointId, Period period, MetricsAggregation metricsAggregation) throws IOException, UnauthorizedException {
        AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            AbstractAPIServiceDeployment deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasService.getSettingsMandatoryUnsafe(deployment.infraId);
            PublishedItem item = (PublishedItem)this.apiServiceDeploymentsService.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            this.apiServiceDeploymentsService.checkReadPermissions(infra, item, authCtx);
            infraBasicInfo = this.apiNodeInfrasService.basicInfoUnsafe(infra);
        }
        Map<Long, Map<String, Double>> activityMetrics = this.apiEndpointActivityMonitoringService.getApiEndpointDeploymentActivityMetrics(new DeploymentAndEndpoint(deploymentId, endpointId), infraBasicInfo, metricsAggregation, period);
        if (!this.apiNodeInfrasService.hasSystemMetrics(infraBasicInfo)) {
            return UnifiedMonitoringDeployerService.convertToMetricsAtTimestamp(activityMetrics);
        }
        Map<Long, Map<String, Double>> systemMetrics = this.apiDeploymentSystemMonitoringService.getEndpointDeploymentSystemMetrics(deploymentId, infraBasicInfo, period, metricsAggregation);
        return UnifiedMonitoringDeployerService.convertToMetricsAtTimestamp(activityMetrics, systemMetrics);
    }

    public static List<ApiEndpointDeploymentActivityAndSystemMetrics> convertToMetricsAtTimestamp(Map<Long, Map<String, Double>> metrics) {
        return metrics.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> new ApiEndpointDeploymentActivityAndSystemMetrics((Long)entry.getKey(), (Map)entry.getValue())).collect(Collectors.toList());
    }

    public static List<ApiEndpointDeploymentActivityAndSystemMetrics> convertToMetricsAtTimestamp(Map<Long, Map<String, Double>> activityMetrics, Map<Long, Map<String, Double>> systemMetrics) {
        HashSet<Long> timestamps = new HashSet<Long>(activityMetrics.keySet());
        timestamps.retainAll(new HashSet<Long>(systemMetrics.keySet()));
        return new ArrayList<Long>(timestamps).stream().sorted().map(timestamp -> {
            HashMap<String, Double> metrics = new HashMap<String, Double>((Map)activityMetrics.get(timestamp));
            metrics.putAll((Map)systemMetrics.get(timestamp));
            return new ApiEndpointDeploymentActivityAndSystemMetrics((long)timestamp, (Map<String, Double>)metrics);
        }).collect(Collectors.toList());
    }

    public String getPrometheusMetrics(AuthCtx user, String name) throws Exception {
        Pattern pattern = Pattern.compile(name);
        StringBuilder sb = new StringBuilder();
        sb.append("# HELP global_status Global status: -1=NO_STATUS, 0=HEALTHY, 1=WARNING, 2=ERROR\n");
        sb.append("# TYPE global_status gauge\n");
        sb.append("# HELP deployment_status Deployment status: -1=NO_STATUS, 0=HEALTHY, 1=WARNING, 2=ERROR\n");
        sb.append("# TYPE deployment_status gauge\n");
        sb.append("# HELP model_status Model status: -1=NO_STATUS, 0=HEALTHY, 1=WARNING, 2=ERROR\n");
        sb.append("# TYPE model_status gauge\n");
        sb.append("# HELP execution_status Execution status: -1=NO_STATUS, 0=HEALTHY, 1=WARNING, 2=ERROR\n");
        sb.append("# TYPE execution_status gauge\n");
        sb.append("# HELP governance_status Governance status: -1=NO_STATUS, 0=HEALTHY, 1=WARNING, 2=ERROR\n");
        sb.append("# TYPE governance_status gauge\n");
        sb.append("# HELP data_status Data status: -1=NO_STATUS, 0=HEALTHY, 1=WARNING, 2=ERROR\n");
        sb.append("# TYPE data_status gauge\n");
        List<AbstractMonitoredApiEndpoint> endpoints = this.listMonitoredApiEndpoints(user, true);
        for (AbstractMonitoredApiEndpoint endpoint : endpoints) {
            if (!name.isEmpty() && !this.matchesPattern(endpoint, pattern)) continue;
            String labels = String.format("displayName=\"%s\",endpointName=\"%s\",deploymentId=\"%s\",infrastructureId=\"%s\",type=\"%s\"", UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)endpoint.displayedName, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)endpoint.endpointName, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)endpoint.deploymentId, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)(Objects.equals(endpoint.type, "MANAGED_API_ENDPOINT") ? endpoint.infrastructureId : ((MonitoredExternalApiEndpoint)endpoint).externalEndpointsScope.name), (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)endpoint.type, (Object)"")));
            sb.append(String.format("global_status{%s} %d\n", labels, endpoint.umGlobalStatus.severity));
            sb.append(String.format("deployment_status{%s} %d\n", labels, endpoint.umDeploymentStatus.severity));
            sb.append(String.format("model_status{%s} %d\n", labels, endpoint.umModelStatus.severity));
            sb.append(String.format("governance_status{%s} %d\n", labels, endpoint.umGovernanceStatus.severity));
        }
        List<AbstractMonitoredProjectDeployment> projects = this.listMonitoredProjectDeployments(user);
        for (AbstractMonitoredProjectDeployment project : projects) {
            if (!name.isEmpty() && !this.matchesPattern(project, pattern)) continue;
            String labels = String.format("displayName=\"%s\",bundleName=\"%s\",deployedProjectKey=\"%s\",deploymentId=\"%s\",infrastructureId=\"%s\",type=\"%s\"", UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)project.displayedName, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)project.bundleName, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)project.deployedProjectKey, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)project.deploymentId, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)project.infrastructureId, (Object)"")), UnifiedMonitoringDeployerService.escape((String)MoreObjects.firstNonNull((Object)project.type, (Object)"")));
            sb.append(String.format("global_status{%s} %d\n", labels, project.umGlobalStatus.severity));
            sb.append(String.format("deployment_status{%s} %d\n", labels, project.umDeploymentStatus.severity));
            sb.append(String.format("models_status{%s} %d\n", labels, project.umProjectModelStatus.severity));
            sb.append(String.format("execution_status{%s} %d\n", labels, project.umProjectExecutionStatus.severity));
            sb.append(String.format("data_status{%s} %d\n", labels, project.umDataQualityStatus.severity));
            sb.append(String.format("governance_status{%s} %d\n", labels, project.umGovernanceStatus.severity));
        }
        sb.append("# EOF\n");
        return sb.toString();
    }

    private boolean matchesPattern(AbstractMonitoredThing monitoredThing, Pattern pattern) {
        if (monitoredThing instanceof AbstractMonitoredProjectDeployment) {
            AbstractMonitoredProjectDeployment monitoredProjectDeployment = (AbstractMonitoredProjectDeployment)monitoredThing;
            Matcher deployedProjectKeyMatcher = pattern.matcher(monitoredProjectDeployment.deployedProjectKey);
            Matcher deploymentIdMatcher = pattern.matcher(monitoredProjectDeployment.deploymentId);
            Matcher infrastructureIdMatcher = pattern.matcher(monitoredProjectDeployment.infrastructureId);
            return deployedProjectKeyMatcher.find() || deploymentIdMatcher.find() || infrastructureIdMatcher.find();
        }
        if (monitoredThing instanceof AbstractMonitoredApiEndpoint) {
            AbstractMonitoredApiEndpoint monitoredApiEndpoint = (AbstractMonitoredApiEndpoint)monitoredThing;
            Matcher endpointName = pattern.matcher(monitoredApiEndpoint.endpointName);
            Matcher deploymentIdMatcher = pattern.matcher(monitoredApiEndpoint.deploymentId);
            Matcher infrastructureIdMatcher = pattern.matcher(monitoredApiEndpoint.infrastructureId);
            return endpointName.find() || deploymentIdMatcher.find() || infrastructureIdMatcher.find();
        }
        return false;
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static /* synthetic */ boolean lambda$listMonitoredApiEndpointWithActivityMetrics$11(Set scopeAndEndpointsToKeep, Map.Entry entry) {
        return scopeAndEndpointsToKeep.contains(entry.getKey());
    }
}

