/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.project;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.project.ProjectDataQualityDTO;
import com.dataiku.dip.unifiedmonitoring.project.ProjectExecutionStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectScenarioRunsDTO;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@UIModel
public class MonitoredMultiNodeProjectDeployment
extends AbstractMonitoredProjectDeployment {
    public Map<String, DeploymentHealth> deploymentHealthPerNode = new HashMap<String, DeploymentHealth>();
    public Map<String, InfoMessage.InfoMessages> deploymentHealthMessagesPerNode = new HashMap<String, InfoMessage.InfoMessages>();
    public Map<String, UnifiedMonitoringStatus> umDeploymentStatusPerNode = new HashMap<String, UnifiedMonitoringStatus>();
    public Map<String, ProjectModelStatus> projectModelStatuses = new HashMap<String, ProjectModelStatus>();
    public Map<String, InfoMessage.InfoMessages> projectModelStatusMessages = new HashMap<String, InfoMessage.InfoMessages>();
    public Map<String, ProjectScenarioRunsDTO> projectLastScenarioRuns = new HashMap<String, ProjectScenarioRunsDTO>();
    public Map<String, InfoMessage.InfoMessages> projectLastScenarioRunsMessages = new HashMap<String, InfoMessage.InfoMessages>();
    public Map<String, ProjectDataQualityDTO> dataQualityStatuses = new HashMap<String, ProjectDataQualityDTO>();
    public Map<String, InfoMessage.InfoMessages> dataQualityStatusMessages = new HashMap<String, InfoMessage.InfoMessages>();
    public Map<String, ProjectExecutionStatus> projectExecutionStatuses = new HashMap<String, ProjectExecutionStatus>();

    public MonitoredMultiNodeProjectDeployment() {
    }

    public MonitoredMultiNodeProjectDeployment(List<String> automationNodeIds) {
        for (String automationNodeId : automationNodeIds) {
            this.deploymentHealthMessagesPerNode.put(automationNodeId, new InfoMessage.InfoMessages());
            this.projectModelStatusMessages.put(automationNodeId, new InfoMessage.InfoMessages());
            this.projectLastScenarioRuns.put(automationNodeId, new ProjectScenarioRunsDTO());
            this.projectLastScenarioRunsMessages.put(automationNodeId, new InfoMessage.InfoMessages());
            this.dataQualityStatusMessages.put(automationNodeId, new InfoMessage.InfoMessages());
        }
    }

    public MonitoredMultiNodeProjectDeployment(String deploymentId, String displayedName) {
        this.deploymentId = deploymentId;
        this.displayedName = displayedName;
    }

    @Override
    public void computeUMStatuses() {
        this.umDeploymentStatus = UnifiedMonitoringStatus.map(this.deploymentHealth);
        this.deploymentHealthPerNode.keySet().forEach(node -> this.umDeploymentStatusPerNode.put((String)node, UnifiedMonitoringStatus.map(this.deploymentHealthPerNode.get(node))));
        this.umGovernanceStatus = UnifiedMonitoringStatus.map(this.governanceStatus, this.governCheckPolicy);
        if (this.governanceStatusMessages.anyMessage && this.governanceStatusMessages.maxSeverity != null) {
            this.umGovernanceStatus = UnifiedMonitoringStatus.worstStatus(this.umGovernanceStatus, UnifiedMonitoringStatus.map(this.governanceStatusMessages.maxSeverity));
            if ((this.umGovernanceStatus == UnifiedMonitoringStatus.WARNING || this.umGovernanceStatus == UnifiedMonitoringStatus.ERROR) && this.governCheckPolicy != null) {
                this.umGovernanceStatus = switch (this.governCheckPolicy) {
                    default -> throw new IncompatibleClassChangeError();
                    case AbstractDeploymentInfra.GovernCheckPolicy.WARN -> UnifiedMonitoringStatus.WARNING;
                    case AbstractDeploymentInfra.GovernCheckPolicy.PREVENT -> UnifiedMonitoringStatus.ERROR;
                    case AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK -> UnifiedMonitoringStatus.NO_STATUS;
                };
            }
        }
        UnifiedMonitoringStatus projectDataStatus = UnifiedMonitoringStatus.worstStatus(this.dataQualityStatuses.values().stream().map(UnifiedMonitoringStatus::map).collect(Collectors.toSet()));
        UnifiedMonitoringStatus projectDataStatusFromMessages = UnifiedMonitoringStatus.worstStatus(this.dataQualityStatusMessages.values().stream().filter(infoMessages -> infoMessages.anyMessage && infoMessages.maxSeverity != null).map(infoMessages -> UnifiedMonitoringStatus.map(infoMessages.maxSeverity)).collect(Collectors.toSet()));
        this.umDataQualityStatus = UnifiedMonitoringStatus.worstStatus(projectDataStatus, projectDataStatusFromMessages);
        UnifiedMonitoringStatus projectModelStatus = UnifiedMonitoringStatus.worstStatus(this.projectModelStatuses.values().stream().map(UnifiedMonitoringStatus::map).collect(Collectors.toSet()));
        UnifiedMonitoringStatus projectModelStatusFromMessages = UnifiedMonitoringStatus.worstStatus(this.projectModelStatusMessages.values().stream().filter(infoMessages -> infoMessages.anyMessage && infoMessages.maxSeverity != null).map(infoMessages -> UnifiedMonitoringStatus.map(infoMessages.maxSeverity)).collect(Collectors.toSet()));
        this.umProjectModelStatus = UnifiedMonitoringStatus.worstStatus(projectModelStatus, projectModelStatusFromMessages);
        this.umProjectExecutionStatus = UnifiedMonitoringStatus.worstStatus(this.projectExecutionStatuses.values().stream().map(UnifiedMonitoringStatus::map).collect(Collectors.toSet()));
        this.umGlobalStatus = UnifiedMonitoringStatus.worstStatus(this.umDeploymentStatus, this.umProjectModelStatus, this.umProjectExecutionStatus, this.umDataQualityStatus, this.umGovernanceStatus);
    }
}

