/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebAppsService;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class WebAppBackendRestartThread
extends Thread {
    @Autowired
    WebAppsService webAppsService;
    public AuthCtx authCtx;
    public String projectKey;
    public Mode mode;
    @Nullable
    public String webAppId;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.backends.restart");

    private WebAppBackendRestartThread(String projectKey, String webAppId, AuthCtx authCtx, Mode mode) {
        this.projectKey = projectKey;
        this.webAppId = webAppId;
        this.authCtx = authCtx;
        this.mode = mode;
    }

    public static void restartAll(String projectKey, AuthCtx authCtx) {
        WebAppBackendRestartThread.runThread(projectKey, null, authCtx, Mode.RESTART_ALL, null);
    }

    public static void stopAll(String projectKey, AuthCtx authCtx, Long allowedWait) {
        WebAppBackendRestartThread.runThread(projectKey, null, authCtx, Mode.STOP_ALL, allowedWait);
    }

    public static void stop(String projectKey, AuthCtx authCtx, String webAppId, Long allowedWait) {
        WebAppBackendRestartThread.runThread(projectKey, webAppId, authCtx, Mode.REMOVE, allowedWait);
    }

    private static void runThread(String projectKey, String webAppId, AuthCtx authCtx, Mode mode, Long allowedWait) {
        WebAppBackendRestartThread t = new WebAppBackendRestartThread(projectKey, webAppId, authCtx, mode);
        t.start();
        if (allowedWait != null) {
            try {
                t.join(allowedWait);
                if (t.isAlive()) {
                    logger.warn((Object)("Webapps " + String.valueOf((Object)mode) + " didn't complete in " + allowedWait + " ms"));
                }
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Interrupted while waiting for webapps", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        SpringUtils.getInstance().autowire((Object)this);
        try {
            switch (this.mode) {
                case RESTART_ALL: {
                    this.webAppsService.stopAllAndStartAutoForProject_NT(this.authCtx, this.projectKey);
                    break;
                }
                case STOP_ALL: {
                    this.webAppsService.stopAllForProject_NT(this.projectKey);
                    break;
                }
                case REMOVE: {
                    this.webAppsService.removeBackend_NT(this.projectKey, this.webAppId);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to read webapps for project " + this.projectKey), (Throwable)e);
        }
    }

    private static enum Mode {
        RESTART_ALL,
        STOP_ALL,
        REMOVE;

    }
}

