/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.proxy;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.scheduler.runnables.StoppableWithTimeoutService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppTemplateDesc;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.google.gson.JsonObject;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class VirtualWebappRunner {
    @Autowired
    private WebAppBackendsManager webAppBackendsManager;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private StoppableWithTimeoutService stoppableWithTimeoutService;
    AuthCtx authCtx;
    String projectKey;
    String webappId;
    WebAppTemplateDesc templateDesc;
    StandardWebAppMeta.StandardWebAppParams params;
    String name;
    float aliveMins;
    Map<String, String> envParams;
    JsonObject config;
    boolean keepFutureIdInState;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.webapps.virtual.runner");

    public VirtualWebappRunner() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    FutureResponse<WebAppBackendInstance.BackendState> startWebappIfNotRunning() throws Exception {
        String lockName = "com.dataiku.dip.webapps." + this.webappId;
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            WebAppsService.WebAppCreateResponse created;
            WebAppBackend backend = this.webAppBackendsManager.getBackendOrNull(this.projectKey, this.webappId);
            if (backend != null && backend.getState(this.keepFutureIdInState) != null && backend.getState((boolean)this.keepFutureIdInState).futureInfo.alive) {
                FutureResponse fr = new FutureResponse();
                fr.hasResult = true;
                fr.result = backend.getState(this.keepFutureIdInState);
                FutureResponse futureResponse = fr;
                return futureResponse;
            }
            try (Transaction t = this.transactionService.beginRead();){
                created = this.webAppsService.createVirtual(this.authCtx, this.webappId, this.projectKey, this.name, "PROXY", this.templateDesc, this.params == null ? null : JSON.toJsonObject((Object)this.params, (String[])new String[0]), this.config, null);
            }
            WebApp webapp = created.webapp;
            this.webappId = webapp.id;
            if (webapp.params.isBackendEnabled()) {
                boolean backendHasPreviouslyCrashed = backend != null && backend.getState(this.keepFutureIdInState) != null && !backend.getState((boolean)this.keepFutureIdInState).futureInfo.alive;
                this.stoppableWithTimeoutService.stopWithTimeout(this.webappId, new StoppableWithTimeoutService.Stoppable(){

                    @Override
                    public void stop() {
                        try {
                            VirtualWebappRunner.this.webAppBackendsManager.stop_NT(VirtualWebappRunner.this.projectKey, VirtualWebappRunner.this.webappId);
                        }
                        catch (Exception e) {
                            logger.errorV("Couldn't stop webapp, project : %s, webapp: %s", new Object[]{VirtualWebappRunner.this.projectKey, VirtualWebappRunner.this.webappId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        }
                    }
                }, this.aliveMins, backendHasPreviouslyCrashed);
                FutureResponse<WebAppBackendInstance.BackendState> futureResponse = this.webAppsService.restartBackend_NT(this.authCtx, webapp, this.envParams, this.keepFutureIdInState);
                return futureResponse;
            }
            FutureResponse futureResponse = new FutureResponse();
            return futureResponse;
        }
    }
}

